/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.resource.FileUtils;
import org.exoplatform.commons.file.resource.TreeFile;
import org.exoplatform.commons.file.resource.TreeFileUtils;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class FileSystemResourceProvider
implements BinaryProvider {
    private static final Log log = LogFactory.getLog(FileSystemResourceProvider.class);
    private static final String ROOT_PATH_PARAM = "rootPath";
    protected File root;
    private TreeFileUtils treeFileUtils = null;

    public FileSystemResourceProvider(String rootPath) throws Exception {
        if (StringUtils.isEmpty((CharSequence)rootPath)) {
            throw new Exception("Init param 'rootPath' not defined for " + this.getClass().getSimpleName());
        }
        if ("/".equals(rootPath)) {
            rootPath = "";
        } else if (!((String)rootPath).endsWith("/")) {
            rootPath = (String)rootPath + "/";
        }
        this.root = new File((String)rootPath);
        if (!FileUtils.exists(this.root)) {
            FileUtils.mkdirs(this.root);
        }
        this.treeFileUtils = new TreeFileUtils(new File((String)rootPath));
    }

    public FileSystemResourceProvider(InitParams initParams) throws Exception {
        if (initParams == null) {
            throw new IllegalArgumentException("Init params cannot be null, it must define file system root path in 'rootPath' value param");
        }
        ValueParam rootPathValueParam = initParams.getValueParam(ROOT_PATH_PARAM);
        if (rootPathValueParam == null) {
            throw new Exception("Missing init param 'rootPath' for " + this.getClass().getSimpleName());
        }
        Object rootPath = rootPathValueParam.getValue();
        if (StringUtils.isEmpty((CharSequence)rootPath)) {
            throw new Exception("Init param 'rootPath' not defined for " + this.getClass().getSimpleName());
        }
        if ("/".equals(rootPath)) {
            rootPath = "";
        } else if (!((String)rootPath).endsWith("/")) {
            rootPath = (String)rootPath + "/";
        }
        this.root = new File((String)rootPath);
        if (!FileUtils.exists(this.root)) {
            FileUtils.mkdirs(this.root);
        }
        this.treeFileUtils = new TreeFileUtils(new File((String)rootPath));
    }

    public File getRoot() {
        return this.root;
    }

    public final File getFile(String name) throws IOException {
        return this.treeFileUtils.getFile(name);
    }

    @Override
    public boolean exists(String name) throws IOException {
        return FileUtils.exists(this.getFile(name));
    }

    @Override
    public long lastModified(String name) throws IOException {
        return this.getFile(name).lastModified();
    }

    @Override
    public URL getURL(String name) {
        try {
            File file = this.getFile(name);
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to transform file to URL: " + name), (Throwable)e);
        }
        return null;
    }

    @Override
    public byte[] getBytes(String name) {
        InputStream in = this.getStream(name);
        if (in != null) {
            try {
                return FileUtils.readBytes(in);
            }
            catch (IOException e) {
                log.error((Object)("Failed to read file: " + name), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public InputStream getStream(String name) {
        try {
            return new FileInputStream(this.getFile(name));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                log.warn((Object)("Unable to read binary content from disk for file " + this.getFile(name).getPath() + ". The binary content is not accessible, it was removed, or may have been quarantined by an antivirus."));
            }
            catch (IOException ioException) {
                log.error((Object)("Unable to get file object for name " + name), (Throwable)ioException);
            }
        }
        catch (IOException ioException) {
            log.error((Object)("Unable to get file object for name " + name), (Throwable)ioException);
        }
        return null;
    }

    @Override
    public String getFilePath(FileInfo fileInfo) throws IOException {
        if (fileInfo == null || StringUtils.isEmpty((CharSequence)fileInfo.getChecksum()) || fileInfo.getChecksum().length() < 9) {
            return null;
        }
        return this.getFile(fileInfo.getChecksum()).getAbsolutePath();
    }

    @Override
    public String getFilePath(String name) throws IOException {
        if (name == null || StringUtils.isEmpty((CharSequence)name) || name.length() < 9) {
            return null;
        }
        return this.getFile(name).getAbsolutePath();
    }

    @Override
    public void remove(final String name) throws IOException {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    ((TreeFile)FileSystemResourceProvider.this.getFile(name)).delete();
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        };
        SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
    }

    @Override
    public boolean remove(final FileInfo fileInfo) throws IOException {
        File file = this.getFile(fileInfo.getChecksum());
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Cannot delete file " + this.getFilePath(fileInfo) + " since it does not exist");
        }
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    ((TreeFile)FileSystemResourceProvider.this.getFile(fileInfo.getChecksum())).delete();
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        };
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
    }

    @Override
    public void put(String name, byte[] data) throws IOException {
        boolean created = FileUtils.createNewFile(this.getFile(name));
        if (created) {
            FileUtils.writeFile(this.getFile(name), data);
        }
    }

    @Override
    public void put(String name, InputStream data) throws IOException {
        boolean created = FileUtils.createNewFile(this.getFile(name));
        if (created) {
            FileUtils.copyToFile(data, this.getFile(name));
        }
    }

    @Override
    public void put(FileItem fileItem) throws IOException {
        boolean created = FileUtils.createNewFile(this.getFile(fileItem.getFileInfo().getChecksum()));
        if (created) {
            FileUtils.copyToFile(fileItem.getAsStream(), this.getFile(fileItem.getFileInfo().getChecksum()));
        }
    }

    @Override
    public String getLocation() {
        return this.root.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileSystemResourceProvider) {
            FileSystemResourceProvider store = (FileSystemResourceProvider)obj;
            return store.root.equals(this.root);
        }
        return false;
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String toString() {
        return "FileSystemResourceProvider: " + this.root;
    }
}

