/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import javax.ws.rs.Path;
import org.exoplatform.services.rest.BaseObjectModel;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.impl.resource.PathValue;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.uri.UriPattern;

public class FilterDescriptorImpl
extends BaseObjectModel
implements FilterDescriptor {
    private final PathValue path;
    private final UriPattern uriPattern;

    public FilterDescriptorImpl(Class<?> filterClass) {
        this(filterClass, ComponentLifecycleScope.PER_REQUEST);
    }

    public FilterDescriptorImpl(Object filter) {
        this(filter.getClass(), ComponentLifecycleScope.SINGLETON);
    }

    private FilterDescriptorImpl(Class<?> filterClass, ComponentLifecycleScope scope) {
        super(filterClass, scope);
        Path p = filterClass.getAnnotation(Path.class);
        if (p != null) {
            this.path = new PathValue(p.value());
            this.uriPattern = new UriPattern(p.value());
        } else {
            this.path = null;
            this.uriPattern = null;
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitFilterDescriptor(this);
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ FilterDescriptorImpl: ");
        sb.append("path: " + String.valueOf(this.getPathValue()) + "; ").append("filter class: " + String.valueOf(this.getObjectClass()) + "; ").append(String.valueOf(this.getConstructorDescriptors()) + "; ").append(this.getFieldInjectors()).append(" ]");
        return sb.toString();
    }
}

