/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.log.LogLevel;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.picketlink.idm.api.IdentitySearchCriteria;

public class IDMGroupListAccess
implements ListAccess<Group>,
Serializable {
    private static final long serialVersionUID = 7072169099411659727L;
    private static final Log LOG = ExoLogger.getLogger(IDMGroupListAccess.class);
    private final IdentitySearchCriteria identitySearchCriteria;
    private final GroupDAOImpl groupDAOImpl;
    private final PicketLinkIDMService idmService;
    private int totalSize = -1;
    private String rootGroupName = null;

    public IDMGroupListAccess(GroupDAOImpl groupDAOImpl, PicketLinkIDMService idmService, IdentitySearchCriteria identitySearchCriteria) {
        this.groupDAOImpl = groupDAOImpl;
        this.idmService = idmService;
        this.identitySearchCriteria = identitySearchCriteria;
        this.rootGroupName = groupDAOImpl.orgService.getConfiguration().getRootGroupName();
    }

    public Group[] load(int index, int length) throws Exception {
        if (LOG.isTraceEnabled()) {
            Tools.logMethodIn(LOG, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        if (length == 0) {
            return new Group[0];
        }
        int size = this.getSize();
        if (index + length > size) {
            throw new IllegalArgumentException("Try to get more than groups can retrieve");
        }
        Collection<Object> groups = this.listQuery(index, length);
        groups = groups.stream().filter(group -> !group.getName().equals(this.rootGroupName)).collect(Collectors.toList());
        Group[] exoGroups = new Group[groups.size()];
        int i = 0;
        for (org.picketlink.idm.api.Group group2 : groups) {
            exoGroups[i++] = this.groupDAOImpl.convertGroup(group2);
        }
        if (LOG.isTraceEnabled()) {
            Tools.logMethodOut(LOG, LogLevel.TRACE, "load", exoGroups);
        }
        return exoGroups;
    }

    public int getSize() throws Exception {
        if (LOG.isTraceEnabled()) {
            Tools.logMethodIn(LOG, LogLevel.TRACE, "getSize", null);
        }
        if (this.totalSize > -1) {
            return this.totalSize;
        }
        this.totalSize = this.idmService.getIdentitySession().getPersistenceManager().findGroup("@@ALL_GROUPS@@", this.identitySearchCriteria).size();
        if (LOG.isTraceEnabled()) {
            Tools.logMethodOut(LOG, LogLevel.TRACE, "getSize", this.totalSize);
        }
        return this.totalSize;
    }

    private List<org.picketlink.idm.api.Group> listQuery(int index, int length) throws Exception {
        this.identitySearchCriteria.page(index, length);
        return (List)this.idmService.getIdentitySession().getPersistenceManager().findGroup("@@ALL_GROUPS@@", this.identitySearchCriteria);
    }
}

