/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.service;

import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.service.PollService;
import io.meeds.poll.storage.PollStorage;
import io.meeds.poll.utils.PollUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class PollServiceImpl
implements PollService {
    @Autowired
    private PollStorage pollStorage;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private UserACL userACL;

    public Poll createPoll(Poll poll, List<PollOption> pollOptions, String spaceId, String message, Identity currentIdentity, List<ActivityFile> files) throws IllegalAccessException {
        Space space = this.spaceService.getSpaceById(spaceId);
        if (!this.spaceService.canRedactOnSpace(space, currentIdentity)) {
            throw new IllegalAccessException(String.format("User %s is not allowed to create a poll with question %s in space %s", currentIdentity.getUserId(), poll.getQuestion(), spaceId));
        }
        long currentUserIdentityId = PollUtils.getUserIdentityId(this.identityManager, currentIdentity.getUserId());
        poll.setCreatorId(currentUserIdentityId);
        poll.setSpaceId(Long.parseLong(spaceId));
        Poll createdPoll = this.pollStorage.createPoll(poll, pollOptions);
        createdPoll = this.postPollActivity(message, spaceId, currentIdentity, createdPoll, files);
        PollUtils.broadcastEvent("meeds.poll.createPoll", currentIdentity.getUserId(), createdPoll);
        return createdPoll;
    }

    public Poll getPollById(long pollId, Identity currentIdentity) throws IllegalAccessException {
        Space space;
        Poll poll = this.pollStorage.getPollById(pollId);
        if (poll != null && !this.canViewPoll(space = this.spaceService.getSpaceById(String.valueOf(poll.getSpaceId())), currentIdentity)) {
            throw new IllegalAccessException(String.format("User %s is not allowed to get a poll with id %s from space %s", currentIdentity.getUserId(), pollId, poll.getSpaceId()));
        }
        return poll;
    }

    public PollOption getPollOptionById(long pollOptionId, Identity currentIdentity) throws IllegalAccessException {
        Space space;
        PollOption pollOption = this.pollStorage.getPollOptionById(pollOptionId);
        Poll poll = this.pollStorage.getPollById(pollOption.getPollId());
        if (poll != null && !this.canViewPoll(space = this.spaceService.getSpaceById(String.valueOf(poll.getSpaceId())), currentIdentity)) {
            throw new IllegalAccessException(String.format("User %s is not allowed to get a poll option with id %s from space %s", currentIdentity.getUserId(), pollOptionId, poll.getSpaceId()));
        }
        return pollOption;
    }

    public List<PollOption> getPollOptionsByPollId(long pollId, Identity currentIdentity) throws IllegalAccessException {
        Space space;
        Poll poll = this.pollStorage.getPollById(pollId);
        if (poll != null && !this.canViewPoll(space = this.spaceService.getSpaceById(String.valueOf(poll.getSpaceId())), currentIdentity)) {
            throw new IllegalAccessException(String.format("User %s is not allowed to get poll options of poll with id %s from space %s", currentIdentity.getUserId(), pollId, poll.getSpaceId()));
        }
        return this.pollStorage.getPollOptionsByPollId(pollId);
    }

    public PollVote vote(String pollOptionId, String spaceId, Identity currentIdentity) throws IllegalAccessException {
        Poll poll;
        Space space = this.spaceService.getSpaceById(spaceId);
        if (!this.spaceService.isMember(space, currentIdentity.getUserId())) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not allowed to vote a poll option with id " + pollOptionId + " in space " + spaceId);
        }
        PollVote pollVote = new PollVote();
        if (this.pollStorage.getPollOptionById(Long.parseLong(pollOptionId)) != null && (poll = this.getPollById(this.pollStorage.getPollOptionById(Long.parseLong(pollOptionId)).getPollId(), currentIdentity)) != null) {
            if (!poll.getEndDate().after(new Date())) {
                throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not allowed to vote in an expired poll with id " + poll.getId());
            }
            long currentUserIdentityId = PollUtils.getUserIdentityId(this.identityManager, currentIdentity.getUserId());
            pollVote.setVoterId(currentUserIdentityId);
            pollVote.setPollOptionId(Long.parseLong(pollOptionId));
            pollVote.setVoteDate(new Date());
            pollVote = this.pollStorage.createPollVote(pollVote);
            PollUtils.broadcastEvent("meeds.poll.votePoll", currentIdentity.getUserId(), poll);
        }
        return pollVote;
    }

    public int getPollOptionTotalVotes(long pollOptionId, String spaceId, Identity currentIdentity) throws IllegalAccessException {
        Space pollSpace = this.spaceService.getSpaceById(spaceId);
        if (!this.canViewPoll(pollSpace, currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not allowed to get total votes of poll option with id " + pollOptionId + " in space " + spaceId);
        }
        return this.pollStorage.countPollOptionTotalVotes(pollOptionId);
    }

    public boolean isPollOptionVoted(long pollOptionId, String spaceId, Identity currentIdentity) throws IllegalAccessException {
        Space pollSpace = this.spaceService.getSpaceById(spaceId);
        if (!this.canViewPoll(pollSpace, currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not allowed to check if poll option with id " + pollOptionId + " is voted in space " + pollSpace.getId());
        }
        long currentUserIdentityId = PollUtils.getUserIdentityId(this.identityManager, currentIdentity.getUserId());
        return this.pollStorage.countPollOptionTotalVotesByUser(pollOptionId, currentUserIdentityId) > 0;
    }

    public int getPollOptionsNumber(long pollId, Identity currentIdentity) throws IllegalAccessException {
        Space pollSpace;
        Poll poll = this.pollStorage.getPollById(pollId);
        if (poll != null && !this.canViewPoll(pollSpace = this.spaceService.getSpaceById(String.valueOf(poll.getSpaceId())), currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not allowed to get options number of poll with id " + pollId + " in space " + pollSpace.getId());
        }
        return this.pollStorage.countPollOptionsByPollId(pollId);
    }

    public int getPollTotalVotes(long pollId, Identity currentIdentity) throws IllegalAccessException {
        Space pollSpace;
        Poll poll = this.pollStorage.getPollById(pollId);
        if (poll != null && !this.canViewPoll(pollSpace = this.spaceService.getSpaceById(String.valueOf(poll.getSpaceId())), currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not allowed to get total votes of poll with id " + pollId + " in space " + pollSpace.getId());
        }
        return this.pollStorage.countPollTotalVotes(pollId);
    }

    public boolean didVote(Identity currentIdentity, Long pollId) {
        long currentUserIdentityId = PollUtils.getUserIdentityId(this.identityManager, currentIdentity.getUserId());
        return this.pollStorage.didVote(currentUserIdentityId, pollId);
    }

    private Poll postPollActivity(String message, String spaceId, Identity currentIdentity, Poll createdPoll, List<ActivityFile> files) {
        Space space = this.spaceService.getSpaceById(spaceId);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        org.exoplatform.social.core.identity.model.Identity pollActivityCreatorIdentity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(message);
        activity.setType("poll");
        activity.setUserId(pollActivityCreatorIdentity.getId());
        activity.setFiles(files);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("pollId", String.valueOf(createdPoll.getId()));
        activity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        createdPoll.setActivityId(Long.parseLong(activity.getId()));
        return this.pollStorage.updatePoll(createdPoll);
    }

    private boolean canViewPoll(Space pollSpace, Identity currentIdentity) {
        return this.spaceService.isMember(pollSpace, currentIdentity.getUserId()) || currentIdentity.isMemberOf(this.userACL.getAdminGroups()) || StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)currentIdentity.getUserId()) || this.spaceService.isSuperManager(currentIdentity.getUserId());
    }
}

