/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class ColumnValueBindingBuilder {
    private static final String SPLIT_REGEX = "[^\\s\"']+|\"([^\"]*)\"|'([^']*)'";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");

    public static ColumnValueBinding createValueBinding(String columnName, String writeExpression, JdbcMapping jdbcMapping, MutatingTableReference mutatingTableReference, ParameterUsage parameterUsage, Consumer<Object> parameterConsumer) {
        ColumnReference columnReference = new ColumnReference(mutatingTableReference, columnName, jdbcMapping);
        ColumnWriteFragment columnWriteFragment = ColumnValueBindingBuilder.buildWriteFragment(writeExpression, jdbcMapping, mutatingTableReference, columnReference, parameterUsage, parameterConsumer);
        return new ColumnValueBinding(columnReference, columnWriteFragment);
    }

    public static ColumnWriteFragment buildWriteFragment(String writeExpression, JdbcMapping jdbcMapping, MutatingTableReference mutatingTableReference, ColumnReference columnReference, ParameterUsage parameterUsage, Consumer<Object> parameterConsumer) {
        if (writeExpression == null) {
            return null;
        }
        if (writeExpression.equals("?") || writeExpression.contains("?") && !writeExpression.contains("'")) {
            return ColumnValueBindingBuilder.buildParameterizedWriteFragment(writeExpression, jdbcMapping, mutatingTableReference, columnReference, parameterUsage, parameterConsumer);
        }
        if (!writeExpression.contains("?")) {
            return new ColumnWriteFragment(writeExpression, jdbcMapping);
        }
        if (ColumnValueBindingBuilder.containsParameter(writeExpression)) {
            return ColumnValueBindingBuilder.buildParameterizedWriteFragment(writeExpression, jdbcMapping, mutatingTableReference, columnReference, parameterUsage, parameterConsumer);
        }
        return new ColumnWriteFragment(writeExpression, jdbcMapping);
    }

    private static ColumnWriteFragment buildParameterizedWriteFragment(String writeExpression, JdbcMapping jdbcMapping, MutatingTableReference mutatingTableReference, ColumnReference columnReference, ParameterUsage parameterUsage, Consumer<Object> parameterConsumer) {
        EmbeddableMappingType aggregateMappingType;
        JdbcType jdbcType = jdbcMapping.getJdbcType();
        EmbeddableMappingType embeddableMappingType = aggregateMappingType = jdbcType instanceof AggregateJdbcType ? ((AggregateJdbcType)jdbcType).getEmbeddableMappingType() : null;
        if (aggregateMappingType != null && !aggregateMappingType.shouldBindAggregateMapping()) {
            ColumnValueParameterList parameters = new ColumnValueParameterList(mutatingTableReference, parameterUsage, aggregateMappingType.getJdbcTypeCount());
            aggregateMappingType.forEachSelectable(parameters);
            parameterConsumer.accept(parameters);
            return new ColumnWriteFragment(writeExpression, parameters, jdbcMapping);
        }
        ColumnValueParameter parameter = new ColumnValueParameter(columnReference, parameterUsage);
        parameterConsumer.accept(parameter);
        return new ColumnWriteFragment(writeExpression, parameter, jdbcMapping);
    }

    private static boolean containsParameter(String writeExpression) {
        Matcher matcher = SPLIT_PATTERN.matcher(writeExpression);
        while (matcher.find()) {
            String group = matcher.group();
            if (group.startsWith("'") && group.endsWith("'") || !group.contains("?")) continue;
            return true;
        }
        return false;
    }
}

