/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.tree.diff;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.exoplatform.portal.tree.diff.ListAdapter;

public class Adapters {
    private static final ArrayAdapter ARRAY_INSTANCE = new ArrayAdapter();

    public static <E> ListAdapter<E[], E> list() {
        ArrayAdapter adapter = ARRAY_INSTANCE;
        return adapter;
    }

    private static class ArrayAdapter<E>
    implements ListAdapter<E[], E> {
        private ArrayAdapter() {
        }

        @Override
        public int size(E[] list) {
            return list.length;
        }

        @Override
        public Iterator<E> iterator(final E[] list, final boolean reverse) {
            return new Iterator<E>(){
                int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count < list.length;
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int index = this.count++;
                    if (reverse) {
                        index = list.length - index - 1;
                    }
                    return list[index];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

