/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.graph.SampleDiversity;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExploreControls
implements JsonpSerializable {
    @Nullable
    private final SampleDiversity sampleDiversity;
    @Nullable
    private final Integer sampleSize;
    @Nullable
    private final Time timeout;
    private final boolean useSignificance;
    public static final JsonpDeserializer<ExploreControls> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExploreControls::setupExploreControlsDeserializer);

    private ExploreControls(Builder builder) {
        this.sampleDiversity = builder.sampleDiversity;
        this.sampleSize = builder.sampleSize;
        this.timeout = builder.timeout;
        this.useSignificance = ApiTypeHelper.requireNonNull(builder.useSignificance, this, "useSignificance");
    }

    public static ExploreControls of(Function<Builder, ObjectBuilder<ExploreControls>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SampleDiversity sampleDiversity() {
        return this.sampleDiversity;
    }

    @Nullable
    public final Integer sampleSize() {
        return this.sampleSize;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final boolean useSignificance() {
        return this.useSignificance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.sampleDiversity != null) {
            generator.writeKey("sample_diversity");
            this.sampleDiversity.serialize(generator, mapper);
        }
        if (this.sampleSize != null) {
            generator.writeKey("sample_size");
            generator.write(this.sampleSize.intValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
        generator.writeKey("use_significance");
        generator.write(this.useSignificance);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupExploreControlsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::sampleDiversity, SampleDiversity._DESERIALIZER, "sample_diversity");
        op.add(Builder::sampleSize, JsonpDeserializer.integerDeserializer(), "sample_size");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
        op.add(Builder::useSignificance, JsonpDeserializer.booleanDeserializer(), "use_significance");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExploreControls> {
        @Nullable
        private SampleDiversity sampleDiversity;
        @Nullable
        private Integer sampleSize;
        @Nullable
        private Time timeout;
        private Boolean useSignificance;

        public final Builder sampleDiversity(@Nullable SampleDiversity value) {
            this.sampleDiversity = value;
            return this;
        }

        public final Builder sampleDiversity(Function<SampleDiversity.Builder, ObjectBuilder<SampleDiversity>> fn) {
            return this.sampleDiversity(fn.apply(new SampleDiversity.Builder()).build());
        }

        public final Builder sampleSize(@Nullable Integer value) {
            this.sampleSize = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder useSignificance(boolean value) {
            this.useSignificance = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExploreControls build() {
            this._checkSingleUse();
            return new ExploreControls(this);
        }
    }
}

