/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import com.google.javascript.jscomp.jarjar.com.google.re2j.Pattern;
import io.meeds.layout.model.PageCreateModel;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PermissionUpdateModel;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.rest.model.LayoutModel;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.util.JsonUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageLayoutService {
    public static final String EMPTY_PAGE_TEMPLATE = "empty";
    private static final Log LOG = ExoLogger.getLogger(PageLayoutService.class);
    private static final Pattern GENERIC_STYLE_MATCHER_VALIDATOR = Pattern.compile((String)"[#0-9a-zA-Z\\(\\),\\./\"'\\-%_ ]+");
    private static final String PAGE_NOT_EXISTS_MESSAGE = "Page with key %s doesn't exist";
    private static final String PAGE_NOT_ACCESSIBLE_MESSAGE = "Page with ref %s isn't accessible for user %s";
    private static final String PAGE_NOT_EDITABLE_MESSAGE = "Page with ref %s isn't editable for user %s";
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private LayoutAclService aclService;
    @Autowired
    private PageTemplateService pageTemplateService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private UserPortalConfigService userPortalConfigService;
    @Autowired
    private AddOnService addOnService;

    public List<PageContext> getPages(String siteTypeName, String siteName, String pageDisplayName, int offset, int limit, String username) {
        SiteType siteType = null;
        if (StringUtils.isNotBlank((CharSequence)siteTypeName)) {
            siteType = SiteType.valueOf((String)siteTypeName.toUpperCase());
        }
        QueryResult queryResult = this.layoutService.findPages(offset, limit, siteType, siteName, null, pageDisplayName);
        ArrayList pages = new ArrayList();
        queryResult.iterator().forEachRemaining(pages::add);
        return pages.stream().filter(p -> this.aclService.canViewPage(p.getKey(), username)).toList();
    }

    public PageContext getPage(PageKey pageKey, String username) throws ObjectNotFoundException, IllegalAccessException {
        PageContext page = this.layoutService.getPageContext(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        if (!this.aclService.canViewPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        return page;
    }

    public Application<Portlet> getPageApplicationLayout(PageKey pageKey, long applicationId, String username) throws ObjectNotFoundException, IllegalAccessException {
        Page page = this.getPageLayout(pageKey, username);
        Application<Portlet> application = this.findApplication((ModelObject)page, applicationId);
        if (application == null) {
            throw new ObjectNotFoundException(String.format("Application with id %s wasn't found in page %s", applicationId, pageKey));
        }
        this.computeApplicationPreferences(application, username);
        return application;
    }

    public Page getPageLayout(PageKey pageKey, String username) throws ObjectNotFoundException, IllegalAccessException {
        Page page = this.getPageLayout(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        if (!this.aclService.canViewPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        return page;
    }

    public Page getPageLayout(PageKey pageKey) {
        Page page = this.layoutService.getPage(pageKey);
        if (page != null) {
            this.expandAddonContainerChildren((Container)page);
        }
        return page;
    }

    public PageContext createPage(PageCreateModel pageModel, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalArgumentException {
        SiteKey siteKey = new SiteKey(pageModel.getPageSiteType(), pageModel.getPageSiteName());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with key %s doesn't exist", siteKey));
        }
        if (!this.aclService.canEditNavigation(siteKey, username)) {
            throw new IllegalAccessException();
        }
        String pageName = pageModel.getPageName() == null ? UUID.randomUUID().toString() : pageModel.getPageName() + "_" + String.valueOf(UUID.randomUUID());
        Page page = this.createPageInstance(pageModel.getPageSiteType(), pageModel.getPageSiteName(), pageName, this.getPageType(pageModel.getPageType()), pageModel.getPageTemplateId(), pageModel.getLink());
        page.setName(pageName);
        page.setTitle(pageModel.getPageTitle());
        String[] accessPermissions = pageModel.getAccessPermissions() == null ? portalConfig.getAccessPermissions() : pageModel.getAccessPermissions();
        page.setAccessPermissions(accessPermissions);
        String editPermission = pageModel.getEditPermission() == null ? portalConfig.getEditPermission() : pageModel.getEditPermission();
        page.setEditPermission(editPermission);
        this.validateCSSInputs((ModelObject)page);
        this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)), page);
        return this.layoutService.getPageContext(page.getPageKey());
    }

    public PageKey clonePage(PageKey pageKey, String username) throws IllegalAccessException, ObjectNotFoundException {
        Page page = this.getPageLayout(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        page.resetStorage();
        page.setName(page.getName() + "_draft_" + username);
        page.setTitle(page.getTitle() + " Draft " + username);
        this.replaceAddonContainerChildren((Container)page);
        this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)), page);
        return page.getPageKey();
    }

    public PageContext updatePageLayout(String pageRef, Page page, boolean publish, String username) throws IllegalAccessException, ObjectNotFoundException {
        PageKey pageKey = PageKey.parse((String)pageRef);
        Page existingPage = this.layoutService.getPage(pageKey);
        if (existingPage == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        try {
            if (publish) {
                page.resetStorage();
            } else {
                page.checkStorage();
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.debug((Object)"Error while accessing page applications storage information", (Throwable)e);
            throw new IllegalStateException("layout.pageOutdatedError");
        }
        this.validateCSSInputs((ModelObject)page);
        existingPage.setChildren(page.getChildren());
        this.layoutService.save(existingPage);
        return this.layoutService.getPageContext(existingPage.getPageKey());
    }

    public void updatePageLink(PageKey pageKey, String link, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalStateException {
        PageContext pageContext = this.layoutService.getPageContext(pageKey);
        if (pageContext == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException();
        }
        PageState pageState = pageContext.getState();
        PageType pageType = this.getPageType(pageState.getType());
        if (pageType != PageType.LINK) {
            throw new IllegalStateException(String.format("Page %s isn't of type 'LINK'", pageKey));
        }
        pageContext.setState(new PageState(pageState.getDisplayName(), pageState.getDescription(), pageState.getShowMaxWindow(), pageState.getFactoryId(), pageState.getAccessPermissions(), pageState.getEditPermission(), pageState.getMoveAppsPermissions(), pageState.getMoveContainersPermissions(), pageState.getType(), link));
        this.layoutService.save(pageContext);
    }

    public void updatePagePermissions(PageKey pageKey, PermissionUpdateModel permissionUpdateModel, String username) throws ObjectNotFoundException, IllegalAccessException {
        PageContext pageContext = this.layoutService.getPageContext(pageKey);
        if (pageContext == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException();
        }
        PageState pageState = pageContext.getState();
        List<String> accessPermissionsList = permissionUpdateModel.getAccessPermissions();
        String editPermission = permissionUpdateModel.getEditPermission();
        pageContext.setState(new PageState(pageState.getDisplayName(), pageState.getDescription(), pageState.getShowMaxWindow(), pageState.getFactoryId(), accessPermissionsList, editPermission, pageState.getMoveAppsPermissions(), pageState.getMoveContainersPermissions(), pageState.getType(), pageState.getLink()));
        this.layoutService.save(pageContext);
    }

    private Page createPageInstance(String siteType, String siteName, String pageName, PageType pageType, Long pageTemplateId, String pageLink) throws IllegalArgumentException {
        return switch (pageType) {
            case PageType.PAGE -> {
                if (pageTemplateId == null) {
                    throw new IllegalArgumentException("pageTemplateId is mandatory");
                }
                PageTemplate pageTemplate = this.pageTemplateService.getPageTemplate(pageTemplateId);
                if (pageTemplate == null) {
                    throw new ObjectNotFoundException("pageTemplate not found");
                }
                if (pageTemplate.isDisabled()) {
                    throw new IllegalArgumentException("pageTemplate with designated Id is disabled");
                }
                Page page = this.userPortalConfigService.createPageTemplate(EMPTY_PAGE_TEMPLATE, siteType, siteName);
                Page pageLayout = JsonUtils.fromJsonString(pageTemplate.getContent(), LayoutModel.class).toPage();
                page.setChildren(pageLayout.getChildren());
                page.resetStorage();
                page.setName(pageName);
                page.setType(pageType.name());
                yield page;
            }
            case PageType.LINK -> {
                Page page = new Page(siteType, siteName, pageName);
                page.setLink(pageLink);
                page.setType(pageType.name());
                yield page;
            }
            default -> throw new IllegalArgumentException("pageType is mandatory");
        };
    }

    private PageType getPageType(String pageType) {
        return StringUtils.isBlank((CharSequence)pageType) ? PageType.PAGE : PageType.valueOf((String)pageType.toUpperCase());
    }

    private void expandAddonContainerChildren(Container container) {
        if (StringUtils.equals((CharSequence)container.getFactoryId(), (CharSequence)"addonContainer")) {
            List applications = this.addOnService.getApplications(container.getName());
            if (CollectionUtils.isNotEmpty((Collection)applications)) {
                container.setChildren(new ArrayList(applications));
            }
        } else if (container.getChildren() != null) {
            container.getChildren().stream().filter(Objects::nonNull).filter(Container.class::isInstance).map(Container.class::cast).forEach(this::expandAddonContainerChildren);
        }
    }

    private void replaceAddonContainerChildren(Container container) {
        ArrayList subContainers = container.getChildren();
        if (subContainers == null) {
            return;
        }
        LinkedHashMap<Integer, List> addonContainerChildren = new LinkedHashMap<Integer, List>();
        for (int i = subContainers.size() - 1; i >= 0; --i) {
            ModelObject modelObject = (ModelObject)subContainers.get(i);
            if (!(modelObject instanceof Container)) continue;
            Container subContainer = (Container)modelObject;
            if (StringUtils.equals((CharSequence)subContainer.getFactoryId(), (CharSequence)"addonContainer")) {
                List applications2 = this.addOnService.getApplications(subContainer.getName());
                if (!CollectionUtils.isNotEmpty((Collection)applications2)) continue;
                addonContainerChildren.put(i, applications2);
                continue;
            }
            this.replaceAddonContainerChildren(subContainer);
        }
        if (!addonContainerChildren.isEmpty()) {
            addonContainerChildren.forEach((index, applications) -> {
                subContainers.remove((int)index);
                subContainers.addAll((int)index, applications);
            });
            container.setChildren(subContainers);
        }
    }

    private void validateCSSInputs(ModelObject modelObject) {
        Container container;
        ModelStyle cssStyle = modelObject.getCssStyle();
        Arrays.asList(modelObject.getHeight(), modelObject.getWidth(), cssStyle == null ? null : cssStyle.getBorderColor(), cssStyle == null ? null : cssStyle.getBorderSize(), cssStyle == null ? null : cssStyle.getBoxShadow(), cssStyle == null ? null : cssStyle.getBackgroundColor(), cssStyle == null ? null : cssStyle.getBackgroundImage(), cssStyle == null ? null : cssStyle.getBackgroundEffect(), cssStyle == null ? null : cssStyle.getBackgroundPosition(), cssStyle == null ? null : cssStyle.getBackgroundSize(), cssStyle == null ? null : cssStyle.getBackgroundRepeat(), cssStyle == null ? null : cssStyle.getTextTitleColor(), cssStyle == null ? null : cssStyle.getTextTitleFontSize(), cssStyle == null ? null : cssStyle.getTextTitleFontWeight(), cssStyle == null ? null : cssStyle.getTextTitleFontStyle(), cssStyle == null ? null : cssStyle.getTextColor(), cssStyle == null ? null : cssStyle.getTextFontSize(), cssStyle == null ? null : cssStyle.getTextFontWeight(), cssStyle == null ? null : cssStyle.getTextFontStyle(), cssStyle == null ? null : cssStyle.getTextHeaderColor(), cssStyle == null ? null : cssStyle.getTextHeaderFontSize(), cssStyle == null ? null : cssStyle.getTextHeaderFontWeight(), cssStyle == null ? null : cssStyle.getTextHeaderFontStyle(), cssStyle == null ? null : cssStyle.getTextSubtitleColor(), cssStyle == null ? null : cssStyle.getTextSubtitleFontSize(), cssStyle == null ? null : cssStyle.getTextSubtitleFontWeight(), cssStyle == null ? null : cssStyle.getTextSubtitleFontStyle()).forEach(this::validateCSSStyleValue);
        if (modelObject instanceof Container && !CollectionUtils.isEmpty((Collection)(container = (Container)modelObject).getChildren())) {
            container.getChildren().forEach(this::validateCSSInputs);
        }
    }

    private void validateCSSStyleValue(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && (!GENERIC_STYLE_MATCHER_VALIDATOR.matches(value) || value.contains("javascript") || value.contains("eval"))) {
            throw new IllegalArgumentException(String.format("Invalid css value input %s", value));
        }
    }

    private void computeApplicationPreferences(Application<Portlet> application, String username) throws IllegalAccessException, ObjectNotFoundException {
        String portletContentId = this.layoutService.getId(application.getState());
        Portlet portletPreferences = this.getApplicationPreferences(Long.parseLong(application.getStorageId()), username);
        TransientApplicationState applicationState = new TransientApplicationState(portletContentId, (Object)portletPreferences);
        application.setState((ApplicationState)applicationState);
    }

    private Portlet getApplicationPreferences(long applicationId, String username) throws IllegalAccessException, ObjectNotFoundException {
        List<PortletInstancePreference> preferences = this.portletInstanceService.getApplicationPreferences(applicationId, username);
        Map<String, Preference> preferencesMap = preferences.stream().collect(Collectors.toMap(PortletInstancePreference::getName, p -> new Preference(p.getName(), p.getValue(), false)));
        return new Portlet(preferencesMap);
    }

    private Application<Portlet> findApplication(ModelObject modelObject, long applicationId) {
        ModelObject modelObject2 = modelObject;
        Objects.requireNonNull(modelObject2);
        ModelObject modelObject3 = modelObject2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Application.class}, (Object)modelObject3, n)) {
            case 0 -> {
                Container container = (Container)modelObject3;
                if (!CollectionUtils.isEmpty((Collection)container.getChildren())) {
                    yield container.getChildren().stream().map(m -> this.findApplication((ModelObject)m, applicationId)).filter(Objects::nonNull).findFirst().orElse(null);
                }
                yield null;
            }
            case 1 -> {
                Application application = (Application)modelObject3;
                if (StringUtils.equals((CharSequence)application.getStorageId(), (CharSequence)String.valueOf(applicationId))) {
                    yield application;
                }
                yield null;
            }
            default -> null;
        };
    }
}

