/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.service.impl;

import io.meeds.news.filter.NewsFilter;
import io.meeds.news.model.News;
import io.meeds.news.model.NewsDraftObject;
import io.meeds.news.model.NewsLatestDraftObject;
import io.meeds.news.model.NewsPageObject;
import io.meeds.news.model.NewsPageVersionObject;
import io.meeds.news.notification.plugin.MentionInNewsNotificationPlugin;
import io.meeds.news.notification.plugin.PostNewsNotificationPlugin;
import io.meeds.news.notification.utils.NotificationConstants;
import io.meeds.news.notification.utils.NotificationUtils;
import io.meeds.news.search.NewsESSearchResult;
import io.meeds.news.search.NewsSearchConnector;
import io.meeds.news.service.NewsService;
import io.meeds.news.service.NewsTargetingService;
import io.meeds.news.utils.NewsUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.metadata.MetadataFilter;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class NewsServiceImpl
implements NewsService {
    public static final String NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME = "Articles";
    private static final String HTML_AT_SYMBOL_PATTERN = "@";
    private static final String HTML_AT_SYMBOL_ESCAPED_PATTERN = "&#64;";
    public static final MetadataType NEWS_METADATA_TYPE = new MetadataType(1000L, "news");
    public static final String NEWS_METADATA_NAME = "news";
    public static final String NEWS_METADATA_DRAFT_OBJECT_TYPE = "newsDraftPage";
    public static final String NEWS_FILE_API_NAME_SPACE = "news";
    public static final String NEWS_SUMMARY = "summary";
    public static final String NEWS_ILLUSTRATION_ID = "illustrationId";
    public static final String NEWS_UPLOAD_ID = "uploadId";
    public static final String PUBLISHED = "published";
    public static final String POSTED = "posted";
    public static final String DRAFT = "draft";
    public static final String STAGED = "staged";
    public static final String NEWS_AUDIENCE = "audience";
    public static final String NEWS_DELETED = "deleted";
    public static final String NEWS_ID = "newsId";
    public static final String SCHEDULE_POST_DATE = "schedulePostDate";
    public static final String NEWS_ACTIVITIES = "activities";
    public static final String NEWS_PUBLICATION_STATE = "publicationState";
    public static final String NEWS_ACTIVITY_POSTED = "activityPosted";
    public static final String NEWS_METADATA_PAGE_OBJECT_TYPE = "newsPage";
    public static final String NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE = "newsPageVersion";
    public static final String NEWS_VIEWERS = "viewers";
    public static final String NEWS_VIEWS = "viewsCount";
    public static final String NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE = "newsLatestDraftPage";
    public static final String NEWS_ATTACHMENTS_IDS = "attachmentsIds";
    public static final String ARTICLE_CONTENT = "content";
    public static final MetadataKey NEWS_METADATA_KEY = new MetadataKey(NEWS_METADATA_TYPE.getName(), "news", 0L);
    private static final Log LOG = ExoLogger.getLogger(NewsServiceImpl.class);
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private NoteService noteService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private FileService fileService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private NewsTargetingService newsTargetingService;
    @Autowired
    private IndexingService indexingService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private WikiService wikiService;
    @Autowired
    private NewsSearchConnector newsSearchConnector;

    @Override
    public News createNews(News news, Identity currentIdentity) throws Exception {
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        try {
            if (!this.canCreateNews(space, currentIdentity)) {
                throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to create news");
            }
            News createdNews = POSTED.equals(news.getPublicationState()) ? this.postNews(news, currentIdentity.getUserId()) : (news.getSchedulePostDate() != null ? this.unScheduleNews(news, space.getGroupId(), currentIdentity.getUserId()) : this.createDraftArticleForNewPage(news, space.getGroupId(), currentIdentity.getUserId(), System.currentTimeMillis()));
            return createdNews;
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating the news " + news.getTitle()), (Throwable)e);
            return null;
        }
    }

    @Override
    public News postNews(News news, String poster) throws Exception {
        news = news.getPublicationState().equals(STAGED) || news.getSchedulePostDate() != null ? this.postScheduledArticle(news) : this.createNewsArticlePage(news, poster);
        this.postNewsActivity(news);
        this.sendNotification(poster, news, NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS);
        if (news.isPublished()) {
            this.publishNews(news, poster);
        }
        NewsUtils.broadcastEvent("exo.news.gamification.postArticle", news.getId(), news);
        NewsUtils.broadcastEvent("exo.news.postArticle", news.getAuthor(), news);
        return news;
    }

    @Override
    public boolean canCreateNews(Space space, Identity currentIdentity) throws Exception {
        return space != null && (NewsUtils.canPublishNews(space.getId(), currentIdentity) || this.spaceService.canRedactOnSpace(space, currentIdentity));
    }

    @Override
    public News updateNews(News news, String updater, Boolean post, boolean publish) throws Exception {
        return null;
    }

    @Override
    public News updateNews(News news, String updater, Boolean post, boolean publish, String newsObjectType, String newsUpdateType) throws Exception {
        boolean displayed;
        if (!this.canEditNews(news, updater)) {
            throw new IllegalAccessException("User " + updater + " is not authorized to update news");
        }
        Identity updaterIdentity = NewsUtils.getUserIdentity(updater);
        News originalNews = this.getNewsById(news.getId(), updaterIdentity, false, newsObjectType);
        List<String> oldTargets = this.newsTargetingService.getTargetsByNews(news);
        boolean canPublish = NewsUtils.canPublishNews(news.getSpaceId(), updaterIdentity);
        Set<String> previousMentions = NewsUtils.processMentions(originalNews.getOriginalBody(), this.spaceService.getSpaceById(news.getSpaceId()));
        if (NewsUtils.NewsObjectType.DRAFT.name().toLowerCase().equals(newsObjectType)) {
            return this.updateDraftArticleForNewPage(news, updater);
        }
        if (NewsUtils.NewsObjectType.LATEST_DRAFT.name().toLowerCase().equals(newsObjectType)) {
            return this.createOrUpdateDraftForExistingPage(news, updater);
        }
        if (publish != news.isPublished() && news.isCanPublish()) {
            news.setPublished(publish);
            if (news.isPublished()) {
                this.publishNews(news, updater);
            } else {
                this.unpublishNews(news.getId(), updater);
            }
        }
        boolean bl = displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)STAGED);
        if (publish == news.isPublished() && news.isPublished() && canPublish) {
            if (!(news.getTargets() == null || oldTargets != null && oldTargets.equals(news.getTargets()))) {
                this.newsTargetingService.deleteNewsTargets(news, updater);
                this.newsTargetingService.saveNewsTarget(news, displayed, news.getTargets(), updater);
            }
            if (news.getAudience() != null && news.getAudience().equals("all") && originalNews.getAudience() != null && originalNews.getAudience().equals("space")) {
                this.sendNotification(updater, news, NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS);
            }
        }
        if (NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase().equals(newsObjectType)) {
            news = this.updateNewsArticle(news, updaterIdentity, newsUpdateType);
        }
        if (POSTED.equals(news.getPublicationState())) {
            if (StringUtils.isNotEmpty((CharSequence)news.getId()) && news.getCreationDate() != null) {
                News newMentionedNews = news;
                if (!previousMentions.isEmpty()) {
                    previousMentions.forEach(username -> newMentionedNews.setBody(newMentionedNews.getBody().replaceAll(HTML_AT_SYMBOL_PATTERN + username, "")));
                }
                this.sendNotification(updater, newMentionedNews, NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS);
            }
            this.indexingService.reindex("news", String.valueOf(news.getId()));
        }
        if (!news.getPublicationState().isEmpty() && !DRAFT.equals(news.getPublicationState())) {
            if (post != null) {
                this.updateNewsActivity(news, post);
            }
            NewsUtils.broadcastEvent("exo.news.updateArticle", updater, news);
        }
        return news;
    }

    @Override
    public void deleteNews(String newsId, Identity currentIdentity, String newsObjectType) throws Exception {
        News news = this.getNewsById(newsId, currentIdentity, false, newsObjectType);
        if (!news.isCanDelete()) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to delete news");
        }
        if (NewsUtils.NewsObjectType.DRAFT.name().toLowerCase().equals(newsObjectType)) {
            this.deleteDraftArticle(newsId, currentIdentity.getUserId(), true);
        } else if (NewsUtils.NewsObjectType.LATEST_DRAFT.name().toLowerCase().equals(newsObjectType)) {
            DraftPage draft;
            Page newsArticlePage = this.noteService.getNoteById(newsId);
            if (newsArticlePage != null && (draft = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(newsArticlePage.getId())), currentIdentity.getUserId(), null)) != null) {
                this.deleteDraftArticle(draft.getId(), currentIdentity.getUserId(), !this.isSameIllustration(draft.getId(), newsArticlePage.getId()));
            }
        } else {
            this.deleteArticle(news, currentIdentity.getUserId());
            if (news.getActivities() != null) {
                String newsActivities = news.getActivities();
                Stream.of(newsActivities.split(";")).map(activity -> activity.split(":")[1]).forEach(arg_0 -> ((ActivityManager)this.activityManager).deleteActivity(arg_0));
            }
            MetadataObject newsMetadataObject = new MetadataObject("news", newsId);
            this.metadataService.deleteMetadataItemsByObject(newsMetadataObject);
            this.indexingService.unindex("news", String.valueOf(news.getId()));
            NewsUtils.broadcastEvent("exo.news.deleteArticle", currentIdentity.getUserId(), news);
        }
    }

    @Override
    public void publishNews(News newsToPublish, String publisher) throws Exception {
        Identity publisherIdentity = NewsUtils.getUserIdentity(publisher);
        News news = this.getNewsArticleById(newsToPublish.getId());
        boolean displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)STAGED);
        NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
        MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
        if (metadataItem != null) {
            HashMap<String, String> properties = metadataItem.getProperties();
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            properties.put(PUBLISHED, String.valueOf(true));
            if (StringUtils.isNotEmpty((CharSequence)newsToPublish.getAudience())) {
                properties.put(NEWS_AUDIENCE, news.getAudience());
            }
            metadataItem.setProperties(properties);
            Date updatedDate = Calendar.getInstance().getTime();
            metadataItem.setUpdatedDate(updatedDate.getTime());
            String publisherId = this.identityManager.getOrCreateUserIdentity(publisherIdentity.getUserId()).getId();
            this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(publisherId));
        }
        if (newsToPublish.getTargets() != null) {
            this.newsTargetingService.deleteNewsTargets(news, publisher);
            this.newsTargetingService.saveNewsTarget(news, displayed, newsToPublish.getTargets(), publisher);
        }
        NewsUtils.broadcastEvent("exo.news.gamification.PublishArticle", news.getId(), news);
        try {
            news.setAudience(newsToPublish.getAudience());
            this.sendNotification(publisher, news, NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS);
        }
        catch (Error | Exception e) {
            LOG.warn((Object)("Error sending notification when publishing news with Id " + news.getId()), e);
        }
    }

    @Override
    public void unpublishNews(String newsId, String publisher) throws Exception {
        News news = this.getNewsArticleById(newsId);
        this.newsTargetingService.deleteNewsTargets(news, publisher);
        NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
        MetadataItem newsMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
        if (newsMetadataItem != null) {
            Map properties = newsMetadataItem.getProperties();
            if (properties != null) {
                properties.put(PUBLISHED, String.valueOf(false));
                properties.remove(NEWS_AUDIENCE);
            }
            newsMetadataItem.setProperties(properties);
            Date updatedDate = Calendar.getInstance().getTime();
            newsMetadataItem.setUpdatedDate(updatedDate.getTime());
            String publisherId = this.identityManager.getOrCreateUserIdentity(publisher).getId();
            this.metadataService.updateMetadataItem(newsMetadataItem, Long.parseLong(publisherId));
        }
    }

    @Override
    public News getNewsById(String newsId, Identity currentIdentity, boolean editMode, String newsObjectType) throws IllegalAccessException {
        News news = null;
        try {
            if (newsObjectType == null) {
                throw new IllegalArgumentException("Required argument news object type could not be null");
            }
            if (NewsUtils.NewsObjectType.DRAFT.name().toLowerCase().equals(newsObjectType)) {
                news = this.buildDraftArticle(newsId, currentIdentity.getUserId());
            } else if (NewsUtils.NewsObjectType.LATEST_DRAFT.name().toLowerCase().equals(newsObjectType)) {
                news = this.buildLatestDraftArticle(newsId, currentIdentity.getUserId());
            } else if (NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase().equals(newsObjectType)) {
                news = this.buildArticle(newsId);
            }
        }
        catch (Exception exception) {
            LOG.error("An error occurred while retrieving news with id {}", new Object[]{newsId, exception});
        }
        if (news != null) {
            if (editMode) {
                if (!this.canEditNews(news, currentIdentity.getUserId())) {
                    throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to edit News");
                }
            } else if (!this.canViewNews(news, currentIdentity.getUserId())) {
                throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to view News");
            }
            news.setCanEdit(this.canEditNews(news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity));
            news.setTargets(this.newsTargetingService.getTargetsByNews(news));
            ExoSocialActivity activity = null;
            try {
                activity = this.activityManager.getActivity(news.getActivityId());
            }
            catch (Exception e) {
                LOG.debug("Error getting activity of News with id {}", new Object[]{news.getActivityId(), e});
            }
            if (activity != null) {
                RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess(activity, true);
                news.setCommentsCount(listAccess.getSize());
                news.setLikesCount(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
            }
        }
        return news;
    }

    @Override
    public News getNewsArticleById(String newsId) {
        News news = null;
        try {
            news = this.buildArticle(newsId);
            news.setTargets(this.newsTargetingService.getTargetsByNews(news));
        }
        catch (Exception exception) {
            LOG.error("An error occurred while retrieving news with id {}", new Object[]{newsId, exception});
        }
        return news;
    }

    @Override
    public List<News> getNews(NewsFilter filter, Identity currentIdentity) throws Exception {
        List<Object> newsList = new ArrayList();
        if (filter != null) {
            newsList = StringUtils.isNotBlank((CharSequence)filter.getSearchText()) ? this.searchNews(filter, this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId())) : (filter.isPublishedNews() ? this.getPublishedArticles(filter, currentIdentity) : (filter.isDraftNews() ? this.buildDraftArticles(filter, currentIdentity) : (filter.isScheduledNews() ? this.getScheduledArticles(filter, currentIdentity) : (filter.getAuthor() != null ? this.getMyPostedArticles(filter, currentIdentity) : this.getPostedArticles(filter, currentIdentity)))));
        } else {
            throw new Exception("Unable to build query, filter is null");
        }
        newsList.stream().filter(Objects::nonNull).forEach(news -> {
            news.setCanEdit(this.canEditNews((News)news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity));
        });
        return newsList;
    }

    @Override
    public List<News> getNewsByTargetName(NewsFilter newsFilter, String targetName, Identity currentIdentity) throws Exception {
        List<MetadataItem> newsTargetItems = this.newsTargetingService.getNewsTargetItemsByTargetName(targetName, newsFilter.getOffset(), 0L);
        return newsTargetItems.stream().filter(target -> {
            try {
                News news = this.getNewsById(target.getObjectId(), currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
                return news != null && (StringUtils.isEmpty((CharSequence)news.getAudience()) || news.getAudience().equals("all") || news.isSpaceMember());
            }
            catch (Exception e) {
                return false;
            }
        }).map(target -> {
            try {
                News news = this.getNewsById(target.getObjectId(), currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
                news.setPublishDate(new Date(target.getCreatedDate()));
                news.setIllustration(null);
                return news;
            }
            catch (Exception e) {
                return null;
            }
        }).limit(newsFilter.getLimit()).toList();
    }

    @Override
    public int getNewsCount(NewsFilter filter) throws Exception {
        return 0;
    }

    @Override
    public void markAsRead(News news, String userId) throws Exception {
        try {
            MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()))).get(0);
            if (metadataItem != null) {
                HashMap<String, String> properties = metadataItem.getProperties();
                if (properties == null) {
                    properties = new HashMap<String, String>();
                }
                if (properties.containsKey(NEWS_VIEWERS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWERS)))) {
                    String newsViewers = (String)properties.get(NEWS_VIEWERS);
                    String[] newsViewersArray = newsViewers.split(",");
                    boolean isUserInNewsViewers = Arrays.stream(newsViewersArray).anyMatch(userId::equals);
                    if (isUserInNewsViewers) {
                        return;
                    }
                    newsViewers.concat("," + userId);
                    properties.put(NEWS_VIEWERS, newsViewers);
                    if (properties.containsKey(NEWS_VIEWS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWS)))) {
                        Long newsViewsCount = Long.parseLong((String)properties.get(NEWS_VIEWS)) + 1L;
                        properties.put(NEWS_VIEWS, String.valueOf(newsViewsCount));
                    } else {
                        properties.put(NEWS_VIEWS, "1");
                    }
                } else {
                    properties.put(NEWS_VIEWERS, userId);
                    properties.put(NEWS_VIEWS, "1");
                }
                metadataItem.setProperties(properties);
                String userIdentityId = this.identityManager.getOrCreateUserIdentity(userId).getId();
                this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(userIdentityId));
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("Failed to mark news article " + news.getId() + " as read for current user"), (Throwable)exception);
            return;
        }
        NewsUtils.broadcastEvent("exo.news.viewArticle", userId, news);
    }

    @Override
    public List<News> searchNews(NewsFilter filter, org.exoplatform.social.core.identity.model.Identity currentIdentity) throws Exception {
        return this.newsSearchConnector.search(currentIdentity, filter).stream().map(articleSearchResult -> {
            try {
                return this.buildArticle(articleSearchResult.getId());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).toList();
    }

    @Override
    public News getNewsByActivityId(String activityId, Identity currentIdentity) throws IllegalAccessException, ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " wasn't found");
        }
        Identity viewerIdentity = NewsUtils.getUserIdentity(currentIdentity.getUserId());
        if (!this.activityManager.isActivityViewable(activity, viewerIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " isn't allowed to access activity with id " + activityId);
        }
        Map templateParams = activity.getTemplateParams();
        if (templateParams == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        String newsId = (String)templateParams.get(NEWS_ID);
        if (StringUtils.isBlank((CharSequence)newsId)) {
            String originalActivityId = (String)templateParams.get("originalActivityId");
            if (StringUtils.isNotBlank((CharSequence)originalActivityId)) {
                org.exoplatform.social.core.identity.model.Identity sharedActivityPosterIdentity = this.identityManager.getIdentity(activity.getPosterId());
                if (sharedActivityPosterIdentity == null) {
                    throw new IllegalAccessException("Shared Activity '" + activityId + "' Poster " + activity.getPosterId() + " isn't found");
                }
                return this.getNewsByActivityId(originalActivityId, NewsUtils.getUserIdentity(sharedActivityPosterIdentity.getRemoteId()));
            }
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        return this.getNewsById(newsId, currentIdentity, false, NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
    }

    @Override
    public News scheduleNews(News news, Identity currentIdentity, String newsObjectType) throws Exception {
        Space space;
        Space space2 = space = news.getSpaceId() == null ? null : this.spaceService.getSpaceById(news.getSpaceId());
        if (!this.canScheduleNews(space, currentIdentity)) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " is not authorized to schedule news");
        }
        if (newsObjectType.equalsIgnoreCase(NewsUtils.NewsObjectType.DRAFT.name())) {
            news = this.createNewsArticlePage(news, currentIdentity.getUserId());
        } else if (newsObjectType.equalsIgnoreCase(NewsUtils.NewsObjectType.ARTICLE.name())) {
            this.updateNewsArticle(news, currentIdentity, NewsUtils.NewsUpdateType.SCHEDULE.name().toLowerCase());
        }
        if (news != null) {
            if (NewsUtils.canPublishNews(space.getId(), currentIdentity)) {
                if (news.isPublished()) {
                    this.publishNews(news, currentIdentity.getUserId());
                } else {
                    this.unpublishNews(news.getId(), currentIdentity.getUserId());
                }
            }
            news.setUrl(NewsUtils.buildNewsArticleUrl(news, currentIdentity.getUserId()));
            news.setSpaceUrl(NewsUtils.buildSpaceUrl(news.getSpaceId()));
            return news;
        }
        return null;
    }

    @Override
    public News unScheduleNews(News news, String pageOwnerId, String articleCreator) throws Exception {
        News existingNews = this.getNewsArticleById(news.getId());
        if (existingNews != null) {
            Map<String, String> illustrationInfo = this.getArticleIllustrationInfo(news);
            news.setId(null);
            news.setUploadId(null);
            news = this.createDraftArticleForNewPage(news, pageOwnerId, articleCreator, System.currentTimeMillis());
            if (!MapUtils.isEmpty(illustrationInfo)) {
                MetadataItem draftMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()))).stream().findFirst().orElse(null);
                HashMap<String, String> draftProperties = draftMetadataItem.getProperties();
                if (draftProperties == null) {
                    draftProperties = new HashMap<String, String>();
                }
                if (illustrationInfo.get(NEWS_UPLOAD_ID) != null) {
                    draftProperties.put(NEWS_UPLOAD_ID, illustrationInfo.get(NEWS_UPLOAD_ID));
                }
                if (illustrationInfo.get(NEWS_ILLUSTRATION_ID) != null) {
                    draftProperties.put(NEWS_ILLUSTRATION_ID, illustrationInfo.get(NEWS_ILLUSTRATION_ID));
                }
                draftMetadataItem.setProperties(draftProperties);
                String draftArticleMetadataItemUpdaterIdentityId = this.identityManager.getOrCreateUserIdentity(articleCreator).getId();
                this.metadataService.updateMetadataItem(draftMetadataItem, Long.parseLong(draftArticleMetadataItemUpdaterIdentityId));
            }
            this.deleteArticle(existingNews, articleCreator);
            return this.buildDraftArticle(news.getId(), articleCreator);
        }
        return null;
    }

    @Override
    public List<NewsESSearchResult> search(org.exoplatform.social.core.identity.model.Identity currentIdentity, NewsFilter filter) {
        return this.newsSearchConnector.search(currentIdentity, filter);
    }

    @Override
    public boolean canScheduleNews(Space space, Identity currentIdentity) {
        return this.spaceService.isManager(space, currentIdentity.getUserId()) || this.spaceService.isRedactor(space, currentIdentity.getUserId()) || NewsUtils.canPublishNews(space.getId(), currentIdentity);
    }

    @Override
    public boolean canViewNews(News news, String authenticatedUser) {
        try {
            Space space;
            String spaceId = news.getSpaceId();
            Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                LOG.warn("Can't find space with id {} when checking access on news with id {}", new Object[]{spaceId, news.getId()});
                return false;
            }
            if (!(news.isPublished() || !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)POSTED) || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isMember(space, authenticatedUser) || this.isMemberOfsharedInSpaces(news, authenticatedUser))) {
                return false;
            }
            if (news.isPublished() && StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)POSTED) && "space".equals(news.getAudience()) && !this.spaceService.isMember(space, authenticatedUser) && !this.isMemberOfsharedInSpaces(news, authenticatedUser)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)STAGED) && !this.canScheduleNews(space, NewsUtils.getUserIdentity(authenticatedUser))) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving access permission for user {} on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        return true;
    }

    @Override
    public void shareNews(News news, Space space, org.exoplatform.social.core.identity.model.Identity userIdentity, String sharedActivityId) throws Exception {
        if (!this.canViewNews(news, userIdentity.getRemoteId())) {
            throw new IllegalAccessException("User with id " + userIdentity.getRemoteId() + "doesn't have access to news");
        }
        if (sharedActivityId != null) {
            NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
            MetadataItem metadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
            if (metadataItem == null) {
                throw new ObjectNotFoundException("News metadata object with id " + news.getId() + " wasn't found");
            }
            HashMap<String, String> properties = metadataItem.getProperties();
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            if (properties.containsKey(NEWS_ACTIVITIES)) {
                String newsActivities = (String)properties.get(NEWS_ACTIVITIES);
                newsActivities = newsActivities.concat(";").concat(space.getId()).concat(":").concat(sharedActivityId);
                properties.put(NEWS_ACTIVITIES, newsActivities);
            } else {
                properties.put(NEWS_ACTIVITIES, space.getId().concat(":").concat(sharedActivityId));
            }
            metadataItem.setProperties(properties);
            this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(userIdentity.getId()));
            NewsUtils.broadcastEvent("content.share.attachments", Map.of(NEWS_ATTACHMENTS_IDS, this.getArticleAttachmentIdsToShare(news, Long.parseLong(space.getId()), Long.parseLong(newsPageObject.getId())), ARTICLE_CONTENT, news.getBody()), space);
            NewsUtils.broadcastEvent("exo.news.shareArticle", userIdentity.getRemoteId(), news);
        }
    }

    private List<String> getArticleAttachmentIdsToShare(News article, long spaceId, long articlePageId) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(articlePageId), null);
        NewsPageVersionObject newsPageVersionObject = new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, pageVersion.getId(), null, spaceId);
        List newsPageVersionMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageVersionObject);
        Map newsPageVersionMetadataItemProperties = ((MetadataItem)newsPageVersionMetadataItems.get(0)).getProperties();
        if (!MapUtils.isEmpty((Map)((MetadataItem)newsPageVersionMetadataItems.get(0)).getProperties()) && newsPageVersionMetadataItemProperties.containsKey(NEWS_ATTACHMENTS_IDS) && newsPageVersionMetadataItemProperties.get(NEWS_ATTACHMENTS_IDS) != null) {
            attachmentIds.addAll(List.of(((String)newsPageVersionMetadataItemProperties.get(NEWS_ATTACHMENTS_IDS)).split(";")));
        }
        return attachmentIds;
    }

    @Override
    public News createDraftArticleForNewPage(News draftArticle, String pageOwnerId, String draftArticleCreator, long creationDate) throws Exception {
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
        Page newsArticlesRootNotePage = null;
        if (wiki != null) {
            newsArticlesRootNotePage = this.noteService.getNoteOfNoteBookByName(WikiType.GROUP.name().toLowerCase(), pageOwnerId, NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            if (newsArticlesRootNotePage == null) {
                newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
            }
        } else {
            pageOwnerId = this.formatWikiOwnerToGroupId(pageOwnerId);
            wiki = this.wikiService.createWiki(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
            newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
        }
        if (newsArticlesRootNotePage != null) {
            DraftPage draftArticlePage = new DraftPage();
            draftArticlePage.setNewPage(true);
            draftArticlePage.setTargetPageId(null);
            draftArticlePage.setTitle(draftArticle.getTitle());
            draftArticlePage.setContent(draftArticle.getBody());
            draftArticlePage.setParentPageId(newsArticlesRootNotePage.getId());
            draftArticlePage.setAuthor(draftArticle.getAuthor());
            draftArticlePage = this.noteService.createDraftForNewPage(draftArticlePage, creationDate);
            draftArticle.setId(draftArticlePage.getId());
            draftArticle.setCreationDate(draftArticlePage.getCreatedDate());
            draftArticle.setUpdateDate(draftArticlePage.getUpdatedDate());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(pageOwnerId);
            draftArticle.setSpaceId(draftArticleSpace.getId());
            NewsDraftObject draftArticleMetaDataObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), null, Long.parseLong(draftArticleSpace.getId()));
            String draftArticleMetadataItemCreatorIdentityId = this.identityManager.getOrCreateUserIdentity(draftArticleCreator).getId();
            HashMap<String, String> draftArticleMetadataItemProperties = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)draftArticle.getUploadId())) {
                Long draftArticleIllustrationId = this.saveArticleIllustration(draftArticle.getUploadId(), null);
                this.setArticleIllustration(draftArticle, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
                draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                draftArticleMetadataItemProperties.put(NEWS_UPLOAD_ID, draftArticle.getUploadId());
            }
            if (StringUtils.isNotEmpty((CharSequence)draftArticle.getSummary())) {
                draftArticleMetadataItemProperties.put(NEWS_SUMMARY, draftArticle.getSummary());
            }
            this.metadataService.createMetadataItem((MetadataObject)draftArticleMetaDataObject, NEWS_METADATA_KEY, draftArticleMetadataItemProperties, Long.parseLong(draftArticleMetadataItemCreatorIdentityId));
            return draftArticle;
        }
        return null;
    }

    @Override
    public News createNewsArticlePage(News newsArticle, String newsArticleCreator) throws Exception {
        String draftNewsId = newsArticle.getId();
        Identity poster = NewsUtils.getUserIdentity(newsArticleCreator);
        Space space = this.spaceService.getSpaceById(newsArticle.getSpaceId());
        String pageOwnerId = space.getGroupId();
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
        Page newsArticlesRootNotePage = null;
        if (wiki != null) {
            newsArticlesRootNotePage = this.noteService.getNoteOfNoteBookByName(WikiType.GROUP.name().toLowerCase(), pageOwnerId, NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            if (newsArticlesRootNotePage == null) {
                newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
            }
        } else {
            pageOwnerId = this.formatWikiOwnerToGroupId(pageOwnerId);
            wiki = this.wikiService.createWiki(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
            newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
        }
        if (newsArticlesRootNotePage != null) {
            Page newsArticlePage = new Page();
            newsArticlePage.setName(newsArticle.getName());
            newsArticlePage.setTitle(newsArticle.getTitle());
            newsArticlePage.setContent(newsArticle.getBody());
            newsArticlePage.setParentPageId(newsArticlesRootNotePage.getId());
            newsArticlePage.setAuthor(newsArticle.getAuthor());
            newsArticlePage.setLang(null);
            newsArticlePage = this.noteService.createNote(wiki, newsArticlesRootNotePage.getName(), newsArticlePage, poster);
            this.noteService.createVersionOfNote(newsArticlePage, poster.getUserId());
            if (newsArticlePage != null) {
                PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(newsArticlePage.getId())), null);
                newsArticle.setId(newsArticlePage.getId());
                newsArticle.setCreationDate(pageVersion.getCreatedDate());
                NewsPageVersionObject newsArticleVersionMetaDataObject = new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, pageVersion.getId(), null, Long.parseLong(space.getId()));
                String newsArticleMetadataItemCreatorIdentityId = this.identityManager.getOrCreateUserIdentity(newsArticleCreator).getId();
                HashMap<String, String> newsArticleVersionMetadataItemProperties = new HashMap<String, String>();
                NewsDraftObject newsDraftObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftNewsId, null, Long.parseLong(space.getId()));
                MetadataItem draftMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsDraftObject).stream().findFirst().orElse(null);
                if (draftMetadataItem != null && draftMetadataItem.getProperties() != null && !draftMetadataItem.getProperties().isEmpty()) {
                    if (draftMetadataItem.getProperties().containsKey(NEWS_UPLOAD_ID)) {
                        newsArticleVersionMetadataItemProperties.put(NEWS_UPLOAD_ID, (String)draftMetadataItem.getProperties().get(NEWS_UPLOAD_ID));
                    }
                    if (draftMetadataItem.getProperties().containsKey(NEWS_ILLUSTRATION_ID)) {
                        newsArticleVersionMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, (String)draftMetadataItem.getProperties().get(NEWS_ILLUSTRATION_ID));
                        this.setArticleIllustration(newsArticle, Long.parseLong((String)newsArticleVersionMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)), NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)newsArticle.getSummary())) {
                    newsArticleVersionMetadataItemProperties.put(NEWS_SUMMARY, newsArticle.getSummary());
                }
                this.metadataService.createMetadataItem((MetadataObject)newsArticleVersionMetaDataObject, NEWS_METADATA_KEY, newsArticleVersionMetadataItemProperties, Long.parseLong(newsArticleMetadataItemCreatorIdentityId));
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, newsArticlePage.getId(), null, Long.parseLong(space.getId()));
                HashMap<String, String> newsPageProperties = new HashMap<String, String>();
                if (StringUtils.isNotEmpty((CharSequence)newsArticle.getAudience())) {
                    newsPageProperties.put(NEWS_AUDIENCE, newsArticle.getAudience());
                }
                if (StringUtils.isNotEmpty((CharSequence)newsArticle.getSchedulePostDate())) {
                    this.setSchedulePostDate(newsArticle, newsPageProperties);
                }
                if (StringUtils.isNotEmpty((CharSequence)newsArticle.getPublicationState())) {
                    newsPageProperties.put(NEWS_PUBLICATION_STATE, newsArticle.getPublicationState());
                }
                newsPageProperties.put(NEWS_ACTIVITY_POSTED, String.valueOf(newsArticle.isActivityPosted()));
                newsPageProperties.put(PUBLISHED, String.valueOf(newsArticle.isPublished()));
                newsPageProperties.put(NEWS_DELETED, String.valueOf(newsArticlePage.isDeleted()));
                this.metadataService.createMetadataItem((MetadataObject)newsPageObject, NEWS_METADATA_KEY, newsPageProperties, Long.parseLong(newsArticleMetadataItemCreatorIdentityId));
                this.deleteDraftArticle(draftNewsId, poster.getUserId(), newsArticle.getIllustration() == null);
                return newsArticle;
            }
        }
        return null;
    }

    @Override
    public News createDraftForExistingPage(News draftArticle, String updater, Page targetArticlePage, long creationDate) throws Exception {
        DraftPage draftArticlePage = new DraftPage();
        draftArticlePage.setNewPage(false);
        draftArticlePage.setTargetPageId(targetArticlePage.getId());
        draftArticlePage.setTitle(draftArticle.getTitle());
        draftArticlePage.setContent(draftArticle.getBody());
        draftArticlePage.setParentPageId(targetArticlePage.getParentPageId());
        draftArticlePage.setAuthor(draftArticle.getAuthor());
        draftArticlePage.setLang(null);
        draftArticlePage = this.noteService.createDraftForExistPage(draftArticlePage, targetArticlePage, null, creationDate, updater);
        draftArticle.setDraftUpdateDate(draftArticlePage.getCreatedDate());
        draftArticle.setDraftUpdater(draftArticlePage.getAuthor());
        draftArticle.setId(draftArticlePage.getId());
        NewsLatestDraftObject latestDraftObject = new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), targetArticlePage.getId(), Long.parseLong(draftArticle.getSpaceId()));
        HashMap<String, String> draftArticleMetadataItemProperties = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)draftArticle.getSummary())) {
            draftArticleMetadataItemProperties.put(NEWS_SUMMARY, draftArticle.getSummary());
        }
        draftArticleMetadataItemProperties.put(NEWS_ACTIVITY_POSTED, String.valueOf(draftArticle.isActivityPosted()));
        PageVersion latestPageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(targetArticlePage.getId())), null);
        if (latestPageVersion != null) {
            MetadataItem pageVersionMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, latestPageVersion.getId(), null, Long.parseLong(draftArticle.getSpaceId()))).stream().findFirst().orElse(null);
            boolean hasIllustration = false;
            Long oldIllustrationId = null;
            String oldIllustrationUploadId = null;
            if (pageVersionMetadataItem != null && pageVersionMetadataItem.getProperties() != null && !pageVersionMetadataItem.getProperties().isEmpty()) {
                Map properties = pageVersionMetadataItem.getProperties();
                boolean bl = hasIllustration = properties.containsKey(NEWS_ILLUSTRATION_ID) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_ILLUSTRATION_ID)));
                if (hasIllustration) {
                    oldIllustrationId = Long.parseLong((String)properties.get(NEWS_ILLUSTRATION_ID));
                    oldIllustrationUploadId = (String)properties.get(NEWS_UPLOAD_ID);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)draftArticle.getUploadId())) {
                Long newIllustrationId = this.saveArticleIllustration(draftArticle.getUploadId(), null);
                if (newIllustrationId != null) {
                    draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(newIllustrationId));
                    draftArticleMetadataItemProperties.put(NEWS_UPLOAD_ID, draftArticle.getUploadId());
                    this.setArticleIllustration(draftArticle, newIllustrationId, NewsUtils.NewsObjectType.DRAFT.name().toLowerCase());
                }
            } else if (draftArticle.getUploadId() == null && hasIllustration) {
                draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(oldIllustrationId));
                draftArticleMetadataItemProperties.put(NEWS_UPLOAD_ID, oldIllustrationUploadId);
                this.setArticleIllustration(draftArticle, oldIllustrationId, NewsUtils.NewsObjectType.DRAFT.name().toLowerCase());
            }
        }
        String draftArticleMetadataItemCreatorIdentityId = this.identityManager.getOrCreateUserIdentity(updater).getId();
        this.metadataService.createMetadataItem((MetadataObject)latestDraftObject, NEWS_METADATA_KEY, draftArticleMetadataItemProperties, Long.parseLong(draftArticleMetadataItemCreatorIdentityId));
        return draftArticle;
    }

    @Override
    public void deleteArticle(News news, String articleCreator) throws Exception {
        Page articlePage = this.noteService.getNoteById(news.getId());
        if (articlePage != null && !articlePage.isDeleted()) {
            NewsPageObject newsPageMetadataObject;
            MetadataItem metadataItem;
            boolean hasDraft = true;
            while (hasDraft) {
                try {
                    DraftPage latestDraftPage = this.noteService.getLatestDraftOfPage(articlePage, articleCreator);
                    if (latestDraftPage != null) {
                        this.deleteDraftArticle(latestDraftPage.getId(), articleCreator, true);
                        continue;
                    }
                    hasDraft = false;
                }
                catch (Exception exception) {
                    hasDraft = false;
                }
            }
            boolean isDeleted = this.noteService.deleteNote(articlePage.getWikiType(), articlePage.getWikiOwner(), articlePage.getName());
            if (isDeleted && (metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)(newsPageMetadataObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId())))).stream().findFirst().orElse(null)) != null) {
                Map properties = metadataItem.getProperties();
                properties.put(NEWS_DELETED, String.valueOf(true));
                metadataItem.setProperties(properties);
                String currentIdentityId = this.identityManager.getOrCreateUserIdentity(articleCreator).getId();
                this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(currentIdentityId));
            }
        }
    }

    @Override
    public void deleteDraftArticle(String draftArticleId, String draftArticleCreator, boolean deleteIllustration) throws Exception {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticleId, draftArticleCreator);
        if (draftArticlePage != null) {
            this.noteService.removeDraftById(draftArticlePage.getId());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            MetadataObject draftArticleMetaDataObject = new MetadataObject(draftArticlePage.getTargetPageId() != null ? NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE : NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), draftArticlePage.getTargetPageId(), Long.parseLong(draftArticleSpace.getId()));
            List draftArticleMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, draftArticleMetaDataObject);
            if (draftArticleMetadataItems != null && !draftArticleMetadataItems.isEmpty()) {
                Map draftArticleMetadataItemProperties = ((MetadataItem)draftArticleMetadataItems.get(0)).getProperties();
                if (deleteIllustration && draftArticleMetadataItemProperties != null && draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                    FileItem draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)));
                    this.fileService.deleteFile(draftArticleIllustrationFileItem.getFileInfo().getId().longValue());
                }
                this.metadataService.deleteMetadataItem(((MetadataItem)draftArticleMetadataItems.get(0)).getId(), false);
            }
        }
    }

    private News updateDraftArticleForNewPage(News draftArticle, String draftArticleUpdater) throws WikiException, IllegalAccessException, FileStorageException {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticle.getId(), draftArticleUpdater);
        if (draftArticlePage != null) {
            draftArticlePage.setTitle(draftArticle.getTitle());
            draftArticlePage.setContent(draftArticle.getBody());
            draftArticlePage = this.noteService.updateDraftForNewPage(draftArticlePage, System.currentTimeMillis());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            NewsDraftObject draftArticleMetaDataObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), null, Long.parseLong(draftArticleSpace.getId()));
            List draftArticleMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)draftArticleMetaDataObject);
            if (draftArticleMetadataItems != null && !draftArticleMetadataItems.isEmpty()) {
                MetadataItem draftArticleMetadataItem = (MetadataItem)draftArticleMetadataItems.get(0);
                HashMap<String, String> draftArticleMetadataItemProperties = draftArticleMetadataItem.getProperties();
                if (draftArticleMetadataItemProperties == null) {
                    draftArticleMetadataItemProperties = new HashMap<String, String>();
                }
                if (StringUtils.isNotEmpty((CharSequence)draftArticle.getUploadId())) {
                    if (draftArticleMetadataItemProperties.containsKey(NEWS_UPLOAD_ID) && draftArticleMetadataItemProperties.get(NEWS_UPLOAD_ID) != null && draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                        if (!((String)draftArticleMetadataItemProperties.get(NEWS_UPLOAD_ID)).equals(draftArticle.getUploadId())) {
                            draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)));
                            Long draftArticleIllustrationId = this.saveArticleIllustration(draftArticle.getUploadId(), draftArticleIllustrationFileItem.getFileInfo().getId());
                            draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                            this.setArticleIllustration(draftArticle, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
                        }
                    } else {
                        Long draftArticleIllustrationId = this.saveArticleIllustration(draftArticle.getUploadId(), null);
                        draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                        draftArticleMetadataItemProperties.put(NEWS_UPLOAD_ID, draftArticle.getUploadId());
                        this.setArticleIllustration(draftArticle, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
                    }
                    draftArticleMetadataItemProperties.put(NEWS_UPLOAD_ID, draftArticle.getUploadId());
                } else if (draftArticleMetadataItemProperties.containsKey(NEWS_UPLOAD_ID) && draftArticleMetadataItemProperties.get(NEWS_UPLOAD_ID) != null && draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null && draftArticle.getUploadId() != null) {
                    draftArticleMetadataItemProperties.remove(NEWS_UPLOAD_ID);
                    draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)));
                    draftArticleMetadataItemProperties.remove(NEWS_ILLUSTRATION_ID);
                    this.fileService.deleteFile(draftArticleIllustrationFileItem.getFileInfo().getId().longValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)draftArticle.getSummary())) {
                    draftArticleMetadataItemProperties.put(NEWS_SUMMARY, draftArticle.getSummary());
                }
                draftArticleMetadataItem.setProperties(draftArticleMetadataItemProperties);
                String draftArticleMetadataItemUpdaterIdentityId = this.identityManager.getOrCreateUserIdentity(draftArticleUpdater).getId();
                this.metadataService.updateMetadataItem(draftArticleMetadataItem, Long.parseLong(draftArticleMetadataItemUpdaterIdentityId));
            }
            return draftArticle;
        }
        return null;
    }

    private News buildDraftArticle(String draftArticleId, String currentUserId) throws Exception {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticleId, currentUserId);
        if (draftArticlePage != null) {
            News draftArticle = new News();
            draftArticle.setId(draftArticlePage.getId());
            draftArticle.setTitle(draftArticlePage.getTitle());
            draftArticle.setAuthor(draftArticlePage.getAuthor());
            draftArticle.setCreationDate(draftArticlePage.getCreatedDate());
            draftArticle.setUpdateDate(draftArticlePage.getUpdatedDate());
            draftArticle.setDraftUpdateDate(draftArticlePage.getUpdatedDate());
            draftArticle.setDraftUpdaterUserName(draftArticlePage.getAuthor());
            org.exoplatform.social.core.identity.model.Identity draftUpdaterIdentity = this.identityManager.getOrCreateUserIdentity(currentUserId);
            if (draftUpdaterIdentity != null && draftUpdaterIdentity.getProfile() != null) {
                draftArticle.setDraftUpdaterDisplayName(draftUpdaterIdentity.getProfile().getFullName());
            }
            this.processPageContent((Page)draftArticlePage, draftArticle);
            draftArticle.setPublicationState(DRAFT);
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            draftArticle.setSpaceId(draftArticleSpace.getId());
            draftArticle.setSpaceAvatarUrl(draftArticleSpace.getAvatarUrl());
            draftArticle.setSpaceDisplayName(draftArticleSpace.getDisplayName());
            boolean hiddenSpace = draftArticleSpace.getVisibility().equals("hidden") && !this.spaceService.isMember(draftArticleSpace, currentUserId) && !this.spaceService.isSuperManager(currentUserId);
            draftArticle.setHiddenSpace(hiddenSpace);
            boolean isSpaceMember = this.spaceService.isSuperManager(currentUserId) || this.spaceService.isMember(draftArticleSpace, currentUserId);
            draftArticle.setSpaceMember(isSpaceMember);
            if (StringUtils.isNotEmpty((CharSequence)draftArticleSpace.getGroupId())) {
                draftArticle.setSpaceUrl(NewsUtils.buildSpaceUrl(draftArticleSpace.getId()));
            }
            draftArticle.setUrl(NewsUtils.buildDraftUrl(draftArticlePage));
            MetadataObject draftArticleMetaDataObject = draftArticlePage.getTargetPageId() == null ? new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticle.getId(), null, Long.parseLong(draftArticleSpace.getId())) : new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, draftArticle.getId(), draftArticlePage.getTargetPageId(), Long.parseLong(draftArticleSpace.getId()));
            MetadataItem draftArticleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, draftArticleMetaDataObject).stream().findFirst().orElse(null);
            this.buildDraftArticleProperties(draftArticle, draftArticleMetadataItem);
            if (draftArticlePage.getTargetPageId() != null) {
                draftArticle.setPublicationDate(this.noteService.getNoteById(draftArticlePage.getTargetPageId()).getCreatedDate());
            }
            return draftArticle;
        }
        return null;
    }

    private void buildArticleVersionProperties(News article, List<MetadataItem> newsPageVersionMetadataItems) {
        Map newsPageVersionMetadataItemProperties;
        if (!CollectionUtils.isEmpty(newsPageVersionMetadataItems) && !MapUtils.isEmpty((Map)(newsPageVersionMetadataItemProperties = newsPageVersionMetadataItems.get(0).getProperties()))) {
            if (newsPageVersionMetadataItemProperties.containsKey(NEWS_SUMMARY)) {
                article.setSummary((String)newsPageVersionMetadataItemProperties.get(NEWS_SUMMARY));
            }
            if (newsPageVersionMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && newsPageVersionMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                this.setArticleIllustration(article, Long.valueOf((String)newsPageVersionMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)), NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
            }
            if (newsPageVersionMetadataItemProperties.containsKey(NEWS_UPLOAD_ID) && newsPageVersionMetadataItemProperties.get(NEWS_UPLOAD_ID) != null) {
                article.setUploadId((String)newsPageVersionMetadataItemProperties.get(NEWS_UPLOAD_ID));
            }
            if (newsPageVersionMetadataItemProperties.containsKey(NEWS_ATTACHMENTS_IDS) && newsPageVersionMetadataItemProperties.get(NEWS_ATTACHMENTS_IDS) != null) {
                List<String> attachmentsIds = List.of(((String)newsPageVersionMetadataItemProperties.get(NEWS_ATTACHMENTS_IDS)).split(";"));
                article.setAttachmentsIds(attachmentsIds);
            }
        }
    }

    private void buildArticleProperties(News article, Page articlePage, String currentUsername, MetadataItem metadataItem) throws Exception {
        if (metadataItem != null && !MapUtils.isEmpty((Map)metadataItem.getProperties())) {
            Map properties = metadataItem.getProperties();
            if (properties.containsKey(NEWS_ACTIVITIES) && properties.get(NEWS_ACTIVITIES) != null) {
                String[] activities = ((String)properties.get(NEWS_ACTIVITIES)).split(";");
                StringBuilder memberSpaceActivities = new StringBuilder();
                String newsActivityId = activities[0].split(":")[1];
                article.setActivityId(newsActivityId);
                memberSpaceActivities.append(activities[0]).append(";");
                ArrayList<String> sharedInSpacesList = new ArrayList<String>();
                for (int i = 1; i < activities.length; ++i) {
                    String sharedInSpaceId = activities[i].split(":")[0];
                    sharedInSpacesList.add(sharedInSpaceId);
                    Space sharedInSpace = this.spaceService.getSpaceById(sharedInSpaceId);
                    String activityId = activities[i].split(":")[1];
                    if (sharedInSpace == null || currentUsername == null || !this.spaceService.isMember(sharedInSpace, currentUsername) || !this.activityManager.isActivityExists(activityId)) continue;
                    memberSpaceActivities.append(activities[i]).append(";");
                }
                article.setActivities(memberSpaceActivities.toString());
                article.setSharedInSpacesList(sharedInSpacesList);
            }
            if (properties.containsKey(NEWS_AUDIENCE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_AUDIENCE)))) {
                article.setAudience((String)properties.get(NEWS_AUDIENCE));
            }
            if (properties.containsKey(SCHEDULE_POST_DATE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(SCHEDULE_POST_DATE)))) {
                article.setSchedulePostDate((String)properties.get(SCHEDULE_POST_DATE));
            }
            if (properties.containsKey(NEWS_PUBLICATION_STATE) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_PUBLICATION_STATE)))) {
                article.setPublicationState((String)properties.get(NEWS_PUBLICATION_STATE));
            }
            if (properties.containsKey(PUBLISHED) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(PUBLISHED)))) {
                article.setPublished(Boolean.parseBoolean((String)properties.get(PUBLISHED)));
            }
            if (properties.containsKey(NEWS_VIEWS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWS)))) {
                article.setViewsCount(Long.parseLong((String)properties.get(NEWS_VIEWS)));
            }
            if (properties.containsKey(NEWS_ACTIVITY_POSTED)) {
                article.setActivityPosted(Boolean.parseBoolean((String)properties.get(NEWS_ACTIVITY_POSTED)));
            } else {
                article.setActivityPosted(false);
            }
        }
    }

    private void buildDraftArticleProperties(News draftArticle, MetadataItem metadataItem) {
        if (metadataItem != null) {
            Map draftArticleMetadataItemProperties = metadataItem.getProperties();
            if (!MapUtils.isEmpty((Map)draftArticleMetadataItemProperties)) {
                if (draftArticleMetadataItemProperties.containsKey(NEWS_SUMMARY)) {
                    draftArticle.setSummary((String)draftArticleMetadataItemProperties.get(NEWS_SUMMARY));
                }
                if (draftArticleMetadataItemProperties.containsKey(NEWS_ACTIVITY_POSTED)) {
                    draftArticle.setActivityPosted(Boolean.parseBoolean((String)draftArticleMetadataItemProperties.get(NEWS_ACTIVITY_POSTED)));
                } else {
                    draftArticle.setActivityPosted(false);
                }
                if (draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                    this.setArticleIllustration(draftArticle, Long.valueOf((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)), NewsUtils.NewsObjectType.DRAFT.name().toLowerCase());
                }
            }
            if (metadataItem.getParentObjectId() != null) {
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, metadataItem.getParentObjectId(), null, metadataItem.getSpaceId());
                MetadataItem parentMetadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
                Map properties = parentMetadataItem.getProperties();
                if (properties.containsKey(NEWS_ACTIVITIES) && properties.get(NEWS_ACTIVITIES) != null) {
                    String[] activities = ((String)properties.get(NEWS_ACTIVITIES)).split(";");
                    String newsActivityId = activities[0].split(":")[1];
                    draftArticle.setActivityId(newsActivityId);
                }
                if (properties.containsKey(NEWS_VIEWS) && StringUtils.isNotEmpty((CharSequence)((CharSequence)properties.get(NEWS_VIEWS)))) {
                    draftArticle.setViewsCount(Long.parseLong((String)properties.get(NEWS_VIEWS)));
                }
            }
        }
    }

    private List<News> getPublishedArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName("news");
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "space", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getMyFilteredSpacesIds(currentIdentity, filter.getSpaces()));
        metadataFilter.setCombinedMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "all", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building published news article", (Throwable)e);
                return null;
            }
        }).toList();
    }

    private List<News> getPostedArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName("news");
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setMetadataProperties(Map.of(NEWS_PUBLICATION_STATE, POSTED, NEWS_DELETED, "false"));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getMyFilteredSpacesIds(currentIdentity, filter.getSpaces()));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setCombinedMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "all", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).toList();
    }

    private List<News> getScheduledArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName("news");
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setMetadataProperties(Map.of(NEWS_PUBLICATION_STATE, STAGED, NEWS_DELETED, "false"));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setMetadataSpaceIds(NewsUtils.getAllowedScheduledNewsSpacesIds(currentIdentity, filter.getSpaces()));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).toList();
    }

    private List<News> getMyPostedArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName("news");
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_OBJECT_TYPE));
        metadataFilter.setCreatorId(Long.valueOf(Long.parseLong(this.identityManager.getOrCreateUserIdentity(filter.getAuthor()).getId())));
        metadataFilter.setMetadataProperties(Map.of(NEWS_PUBLICATION_STATE, POSTED, NEWS_DELETED, "false"));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getMyFilteredSpacesIds(currentIdentity, filter.getSpaces()));
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setCombinedMetadataProperties(Map.of(PUBLISHED, "true", NEWS_AUDIENCE, "all", NEWS_DELETED, "false", NEWS_PUBLICATION_STATE, POSTED));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(article -> {
            try {
                return this.buildArticle(article.getObjectId());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building news article", (Throwable)e);
                return null;
            }
        }).toList();
    }

    private List<News> buildDraftArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName("news");
        metadataFilter.setMetadataTypeName(NEWS_METADATA_TYPE.getName());
        metadataFilter.setSortField(filter.getOrder());
        metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_DRAFT_OBJECT_TYPE, NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE));
        metadataFilter.setMetadataSpaceIds(NewsUtils.getAllowedDraftArticleSpaceIds(currentIdentity, filter.getSpaces()));
        return this.metadataService.getMetadataItemsByFilter(metadataFilter, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(draftArticle -> {
            try {
                News draft = this.buildDraftArticle(draftArticle.getObjectId(), currentIdentity.getUserId());
                if (draft != null && draftArticle.getParentObjectId() != null) {
                    draft.setId(draftArticle.getParentObjectId());
                }
                return draft;
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("User with id " + currentIdentity.getUserId() + " not authorized to view news"), (Throwable)e);
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building new draft article", (Throwable)e);
                return null;
            }
        }).toList();
    }

    private boolean canEditNews(News news, String authenticatedUser) {
        Space space;
        String spaceId = news.getSpaceId();
        Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        Identity authenticatedUserIdentity = NewsUtils.getUserIdentity(authenticatedUser);
        if (authenticatedUserIdentity == null) {
            LOG.warn("Can't find user with id {} when checking access on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        return NewsUtils.canPublishNews(news.getSpaceId(), authenticatedUserIdentity) || this.spaceService.canRedactOnSpace(space, authenticatedUserIdentity);
    }

    private void setArticleIllustration(News article, Long articleIllustrationId, String newsObjectType) {
        try {
            FileItem articleIllustrationFileItem = this.fileService.getFile(articleIllustrationId.longValue());
            if (articleIllustrationFileItem != null && !articleIllustrationFileItem.getFileInfo().isDeleted()) {
                article.setIllustration(articleIllustrationFileItem.getAsByte());
                article.setIllustrationMimeType(articleIllustrationFileItem.getFileInfo().getMimetype());
                article.setIllustrationUpdateDate(articleIllustrationFileItem.getFileInfo().getUpdatedDate());
                long lastModified = article.getIllustrationUpdateDate().getTime();
                article.setIllustrationURL("/content/rest/contents/" + article.getId() + "/illustration?v=" + lastModified + "&type=" + newsObjectType);
            }
        }
        catch (Exception exception) {
            LOG.info((Object)"Failed to set article illustration");
        }
    }

    private Long saveArticleIllustration(String articleUploadId, Long oldArticleIllustrationFileId) {
        UploadResource articleUploadResource;
        if (StringUtils.isEmpty((CharSequence)articleUploadId)) {
            throw new IllegalArgumentException("Article uploadId is mandatory");
        }
        if (oldArticleIllustrationFileId != null && oldArticleIllustrationFileId != 0L) {
            this.fileService.deleteFile(oldArticleIllustrationFileId.longValue());
        }
        if ((articleUploadResource = this.uploadService.getUploadResource(articleUploadId)) == null) {
            throw new IllegalStateException("Can't find article uploaded resource with id : " + articleUploadId);
        }
        try {
            FileInputStream articleIllustrationFileInputStream = new FileInputStream(articleUploadResource.getStoreLocation());
            FileItem articleIllustrationFileItem = new FileItem(null, articleUploadResource.getFileName(), articleUploadResource.getMimeType(), "news", (long)articleUploadResource.getUploadedSize(), new Date(), IdentityConstants.SYSTEM, false, (InputStream)articleIllustrationFileInputStream);
            articleIllustrationFileItem = this.fileService.writeFile(articleIllustrationFileItem);
            Long l = articleIllustrationFileItem != null && articleIllustrationFileItem.getFileInfo() != null ? articleIllustrationFileItem.getFileInfo().getId() : null;
            return l;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while saving article illustration file", e);
        }
        finally {
            this.uploadService.removeUploadResource(articleUploadResource.getUploadId());
        }
    }

    private boolean canDeleteNews(Identity currentIdentity, String posterId, String spaceId) {
        Space space;
        Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        return this.spaceService.canRedactOnSpace(space, currentIdentity);
    }

    private boolean isMemberOfsharedInSpaces(News news, String username) {
        for (String sharedInSpaceId : news.getSharedInSpacesList()) {
            Space sharedInSpace = this.spaceService.getSpaceById(sharedInSpaceId);
            if (sharedInSpace == null || !this.spaceService.isMember(sharedInSpace, username)) continue;
            return true;
        }
        return false;
    }

    private Page createNewsArticlesNoteRootPage(Wiki wiki) throws WikiException {
        if (wiki != null) {
            Page newsArticlesRootNotePage = new Page();
            newsArticlesRootNotePage.setWikiType(wiki.getType());
            newsArticlesRootNotePage.setWikiOwner(wiki.getOwner());
            newsArticlesRootNotePage.setName(NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            newsArticlesRootNotePage.setTitle(NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            Date now = Calendar.getInstance().getTime();
            newsArticlesRootNotePage.setCreatedDate(now);
            newsArticlesRootNotePage.setUpdatedDate(now);
            newsArticlesRootNotePage.setContent("");
            newsArticlesRootNotePage.setSyntax(wiki.getPreferences().getWikiPreferencesSyntax().getDefaultSyntax());
            return this.noteService.createNote(wiki, null, newsArticlesRootNotePage);
        }
        return null;
    }

    private String formatWikiOwnerToGroupId(String wikiOwner) {
        if (wikiOwner == null || ((String)wikiOwner).length() == 0) {
            return null;
        }
        if (!((String)wikiOwner).startsWith("/")) {
            wikiOwner = "/" + (String)wikiOwner;
        }
        if (((String)wikiOwner).endsWith("/")) {
            wikiOwner = ((String)wikiOwner).substring(0, ((String)wikiOwner).length() - 1);
        }
        return wikiOwner;
    }

    private void sendNotification(String currentUserId, News news, NotificationConstants.NOTIFICATION_CONTEXT context) throws Exception {
        if (news.getActivities() == null || news.getActivities().isEmpty()) {
            return;
        }
        String newsId = news.getId();
        String contentAuthor = news.getAuthor();
        String currentUser = currentUserId != null ? currentUserId : contentAuthor;
        String activities = news.getActivities();
        String contentTitle = news.getTitle();
        String contentBody = news.getBody();
        String lastSpaceIdActivityId = activities.split(";")[activities.split(";").length - 1];
        String contentSpaceId = lastSpaceIdActivityId.split(":")[0];
        String contentActivityId = lastSpaceIdActivityId.split(":")[1];
        Space contentSpace = this.spaceService.getSpaceById(contentSpaceId);
        boolean isMember = this.spaceService.isMember(contentSpace, contentAuthor);
        if (contentSpace == null) {
            throw new NullPointerException("Cannot find a space with id " + contentSpaceId + ", it may not exist");
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(contentAuthor);
        String authorAvatarUrl = LinkProviderUtils.getUserAvatarUrl((Profile)identity.getProfile());
        String activityLink = NotificationUtils.getNotificationActivityLink(contentSpace, contentActivityId, isMember);
        String contentSpaceName = contentSpace.getDisplayName();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTEXT, (Object)context).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(PostNewsNotificationPlugin.NEWS_ID, (Object)newsId);
        if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS)) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PostNewsNotificationPlugin"))).execute(ctx);
            Matcher matcher = MentionInNewsNotificationPlugin.MENTION_PATTERN.matcher(contentBody);
            if (matcher.find()) {
                this.sendMentionInNewsNotification(newsId, contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, authorAvatarUrl, activityLink, contentSpaceName);
            }
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS)) {
            this.sendMentionInNewsNotification(newsId, contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, authorAvatarUrl, activityLink, contentSpaceName);
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS)) {
            if (news.getAudience() != null) {
                News originalNews = this.getNewsArticleById(news.getId());
                if (news.getAudience().equals("all") && originalNews.getAudience() != null && originalNews.getAudience().equals("space")) {
                    ctx.append(PostNewsNotificationPlugin.AUDIENCE, (Object)"excludeSpaceMembers");
                } else {
                    ctx.append(PostNewsNotificationPlugin.AUDIENCE, (Object)news.getAudience());
                }
            }
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PublishNewsNotificationPlugin"))).execute(ctx);
        }
    }

    private void updateNewsActivity(News news, boolean post) {
        ExoSocialActivity activity = this.activityManager.getActivity(news.getActivityId());
        if (activity != null) {
            if (post) {
                activity.setUpdated(Long.valueOf(System.currentTimeMillis()));
            }
            activity.isHidden(!news.isActivityPosted());
            Map<String, String> templateParams = activity.getTemplateParams() == null ? new HashMap() : activity.getTemplateParams();
            templateParams.put(NEWS_ID, news.getId());
            activity.setTemplateParams(templateParams);
            activity.setMetadataObjectId(news.getId());
            activity.setMetadataObjectType("news");
            this.activityManager.updateActivity(activity, true);
        }
    }

    private void sendMentionInNewsNotification(String newsId, String contentAuthor, String currentUser, String contentTitle, String contentBody, String contentSpaceId, String authorAvatarUrl, String activityLink, String contentSpaceName) {
        Space space = this.spaceService.getSpaceById(contentSpaceId);
        Set<String> mentionedIds = NewsUtils.processMentions(contentBody, space);
        NotificationContext mentionNotificationCtx = NotificationContextImpl.cloneInstance().append(MentionInNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(MentionInNewsNotificationPlugin.MENTIONED_IDS, mentionedIds).append(PostNewsNotificationPlugin.NEWS_ID, (Object)newsId);
        mentionNotificationCtx.getNotificationExecutor().with(mentionNotificationCtx.makeCommand(PluginKey.key((String)"MentionInNewsNotificationPlugin"))).execute(mentionNotificationCtx);
    }

    private Identity getCurrentIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState == null ? null : conversationState.getIdentity();
    }

    private void updateNewsActivities(String activityId, News news) throws Exception {
        if (activityId != null && !StringUtils.isEmpty((CharSequence)news.getId())) {
            Page newsPage = this.noteService.getNoteById(news.getId());
            if (newsPage != null) {
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, newsPage.getId(), null, Long.parseLong(news.getSpaceId()));
                MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
                if (metadataItem != null) {
                    HashMap<String, String> properties = metadataItem.getProperties();
                    if (properties == null) {
                        properties = new HashMap<String, String>();
                    }
                    String newsActivity = news.getSpaceId().concat(":").concat(activityId);
                    if (properties.containsKey(NEWS_ACTIVITIES)) {
                        properties.put(NEWS_ACTIVITIES, ((String)properties.get(NEWS_ACTIVITIES)).concat("; ").concat(newsActivity));
                    } else {
                        properties.put(NEWS_ACTIVITIES, newsActivity);
                    }
                    metadataItem.setProperties(properties);
                    String updaterId = this.identityManager.getOrCreateUserIdentity(news.getAuthor()).getId();
                    Date updateDate = Calendar.getInstance().getTime();
                    metadataItem.setUpdatedDate(updateDate.getTime());
                    this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(updaterId));
                    news.setActivities((String)properties.get(NEWS_ACTIVITIES));
                    news.setActivityId(activityId);
                }
            } else {
                throw new ObjectNotFoundException("No metadata item found for the news article page " + news.getId());
            }
        }
    }

    private void postNewsActivity(News news) throws Exception {
        org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getOrCreateUserIdentity(news.getAuthor());
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(news.getTitle());
        activity.setType("news");
        activity.setUserId(poster.getId());
        activity.isHidden(!news.isActivityPosted());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(NEWS_ID, news.getId());
        activity.setTemplateParams(templateParams);
        activity.setMetadataObjectId(news.getId());
        activity.setMetadataObjectType("news");
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.updateNewsActivities(activity.getId(), news);
    }

    private News updateNewsArticle(News news, Identity updater, String newsUpdateType) throws Exception {
        Page existingPage = this.noteService.getNoteById(news.getId());
        if (existingPage != null) {
            Map newsPageProperties;
            if (newsUpdateType.equals(NewsUtils.NewsUpdateType.CONTENT.name().toLowerCase())) {
                existingPage.setTitle(news.getTitle());
                existingPage.setContent(news.getBody());
            }
            existingPage.setUpdatedDate(Calendar.getInstance().getTime());
            existingPage = this.noteService.updateNote(existingPage);
            news.setUpdateDate(existingPage.getUpdatedDate());
            news.setUpdater(existingPage.getAuthor());
            news.setUpdaterFullName(existingPage.getAuthorFullName());
            String newsArticleUpdaterIdentityId = this.identityManager.getOrCreateUserIdentity(updater.getUserId()).getId();
            NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
            MetadataItem existingPageMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
            if (existingPageMetadataItem != null) {
                String existingSchedulePostDate;
                newsPageProperties = existingPageMetadataItem.getProperties();
                if (StringUtils.isNotEmpty((CharSequence)news.getAudience())) {
                    newsPageProperties.put(NEWS_AUDIENCE, news.getAudience());
                }
                if (StringUtils.isNotEmpty((CharSequence)news.getSchedulePostDate()) && ((existingSchedulePostDate = (String)newsPageProperties.getOrDefault(SCHEDULE_POST_DATE, null)) == null || !existingSchedulePostDate.equals(news.getSchedulePostDate()))) {
                    this.setSchedulePostDate(news, newsPageProperties);
                }
                if (StringUtils.isNotEmpty((CharSequence)news.getPublicationState())) {
                    newsPageProperties.put(NEWS_PUBLICATION_STATE, news.getPublicationState());
                }
            } else {
                throw new ObjectNotFoundException("No such news article metadata item exists with id " + news.getId());
            }
            newsPageProperties.put(NEWS_ACTIVITY_POSTED, String.valueOf(news.isActivityPosted()));
            existingPageMetadataItem.setProperties(newsPageProperties);
            Date updateDate = Calendar.getInstance().getTime();
            existingPageMetadataItem.setUpdatedDate(updateDate.getTime());
            this.metadataService.updateMetadataItem(existingPageMetadataItem, Long.parseLong(newsArticleUpdaterIdentityId));
            if (newsUpdateType.equals(NewsUtils.NewsUpdateType.CONTENT.name().toLowerCase())) {
                this.noteService.createVersionOfNote(existingPage, updater.getUserId());
                PageVersion createdVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(existingPage.getId())), null);
                NewsPageVersionObject newsArticleVersionMetaDataObject = new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, createdVersion.getId(), null, Long.parseLong(news.getSpaceId()));
                HashMap<String, String> newsArticleVersionMetadataItemProperties = new HashMap<String, String>();
                String draftNewsId = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(existingPage.getId())), updater.getUserId(), null).getId();
                NewsLatestDraftObject newsLatestDraftObject = new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, draftNewsId, existingPage.getId(), Long.parseLong(news.getSpaceId()));
                MetadataItem metadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsLatestDraftObject).stream().findFirst().orElse(null);
                if (metadataItem != null && metadataItem.getProperties() != null && !metadataItem.getProperties().isEmpty()) {
                    Map properties = metadataItem.getProperties();
                    if (properties.containsKey(NEWS_UPLOAD_ID)) {
                        newsArticleVersionMetadataItemProperties.put(NEWS_UPLOAD_ID, (String)properties.get(NEWS_UPLOAD_ID));
                    }
                    if (properties.containsKey(NEWS_ILLUSTRATION_ID)) {
                        newsArticleVersionMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, (String)properties.get(NEWS_ILLUSTRATION_ID));
                        this.setArticleIllustration(news, Long.parseLong((String)properties.get(NEWS_ILLUSTRATION_ID)), NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
                    }
                } else {
                    throw new ObjectNotFoundException("No such news draft article metadata item exists with id " + draftNewsId);
                }
                if (StringUtils.isNotEmpty((CharSequence)news.getSummary())) {
                    newsArticleVersionMetadataItemProperties.put(NEWS_SUMMARY, news.getSummary());
                }
                this.metadataService.createMetadataItem((MetadataObject)newsArticleVersionMetaDataObject, NEWS_METADATA_KEY, newsArticleVersionMetadataItemProperties, Long.parseLong(newsArticleUpdaterIdentityId));
            }
            if (newsUpdateType.equalsIgnoreCase(NewsUtils.NewsUpdateType.CONTENT.name())) {
                DraftPage draftPage = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(existingPage.getId())), updater.getUserId(), null);
                this.deleteDraftArticle(draftPage.getId(), updater.getUserId(), news.getIllustration() == null);
            }
            return news;
        }
        return null;
    }

    private News buildArticle(String newsId) throws Exception {
        if (StringUtils.isNumeric((CharSequence)newsId)) {
            String currentUsername;
            Page articlePage = this.noteService.getNoteById(newsId);
            Identity userIdentity = this.getCurrentIdentity();
            String string = currentUsername = userIdentity == null ? null : userIdentity.getUserId();
            if (articlePage != null) {
                org.exoplatform.social.core.identity.model.Identity identity;
                Space space = this.spaceService.getSpaceByGroupId(articlePage.getWikiOwner());
                News news = new News();
                news.setId(articlePage.getId());
                news.setCreationDate(articlePage.getCreatedDate());
                news.setAuthor(articlePage.getAuthor());
                news.setUpdater(articlePage.getAuthor());
                NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, articlePage.getId(), null, Long.parseLong(space.getId()));
                MetadataItem metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).get(0);
                news.setSpaceId(space.getId());
                news.setSpaceAvatarUrl(space.getAvatarUrl());
                news.setSpaceDisplayName(space.getDisplayName());
                boolean hiddenSpace = space.getVisibility().equals("hidden") && !this.spaceService.isMember(space, currentUsername) && !this.spaceService.isSuperManager(currentUsername);
                news.setHiddenSpace(hiddenSpace);
                boolean isSpaceMember = this.spaceService.isSuperManager(currentUsername) || this.spaceService.isMember(space, currentUsername);
                news.setSpaceMember(isSpaceMember);
                if (StringUtils.isNotEmpty((CharSequence)space.getGroupId())) {
                    news.setSpaceUrl(NewsUtils.buildSpaceUrl(space.getId()));
                }
                if ((identity = this.identityManager.getOrCreateIdentity("organization", news.getAuthor())) != null && identity.getProfile() != null) {
                    news.setAuthorDisplayName(identity.getProfile().getFullName());
                    news.setAuthorAvatarUrl(identity.getProfile().getAvatarUrl());
                }
                this.buildArticleProperties(news, articlePage, currentUsername, metadataItem);
                news.setDeleted(articlePage.isDeleted());
                news.setUrl(NewsUtils.buildNewsArticleUrl(news, currentUsername));
                news.setPublicationDate(articlePage.getCreatedDate());
                news.setUpdateDate(new Date(metadataItem.getUpdatedDate()));
                PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(articlePage.getId())), null);
                news.setTitle(pageVersion.getTitle());
                this.processPageContent((Page)pageVersion, news);
                news.setUpdaterFullName(pageVersion.getAuthorFullName());
                NewsPageVersionObject newsPageVersionObject = new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, pageVersion.getId(), null, Long.parseLong(space.getId()));
                List newsPageVersionMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageVersionObject);
                this.buildArticleVersionProperties(news, newsPageVersionMetadataItems);
                return news;
            }
        }
        return null;
    }

    private News createOrUpdateDraftForExistingPage(News news, String updater) throws Exception {
        String pageId = news.getId();
        Page existingPage = this.noteService.getNoteById(pageId);
        if (existingPage == null) {
            return null;
        }
        DraftPage draftPage = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(pageId)), updater, null);
        news = draftPage == null ? this.createDraftForExistingPage(news, updater, existingPage, System.currentTimeMillis()) : this.updateDraftForExistingPage(news, updater, existingPage, draftPage);
        return news;
    }

    private News updateDraftForExistingPage(News news, String updater, Page page, DraftPage draftPage) {
        try {
            draftPage.setTitle(news.getTitle());
            draftPage.setContent(news.getBody());
            draftPage.setAuthor(news.getAuthor());
            draftPage.setTargetPageId(page.getId());
            draftPage.setLang(null);
            draftPage = this.noteService.updateDraftForExistPage(draftPage, page, null, System.currentTimeMillis(), updater);
            news.setDraftUpdateDate(draftPage.getUpdatedDate());
            news.setDraftUpdater(draftPage.getAuthor());
            NewsLatestDraftObject latestDraftObject = new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, draftPage.getId(), page.getId(), Long.parseLong(news.getSpaceId()));
            MetadataItem latestDraftArticleMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)latestDraftObject).stream().findFirst().orElse(null);
            if (latestDraftArticleMetadataItem != null) {
                HashMap<String, String> latestDraftArticleMetadataItemProperties = latestDraftArticleMetadataItem.getProperties();
                if (latestDraftArticleMetadataItemProperties == null) {
                    latestDraftArticleMetadataItemProperties = new HashMap<String, String>();
                }
                this.setLatestDraftProperties(latestDraftArticleMetadataItemProperties, news);
                latestDraftArticleMetadataItem.setProperties(latestDraftArticleMetadataItemProperties);
                String draftArticleMetadataItemUpdaterIdentityId = this.identityManager.getOrCreateUserIdentity(updater).getId();
                this.metadataService.updateMetadataItem(latestDraftArticleMetadataItem, Long.parseLong(draftArticleMetadataItemUpdaterIdentityId));
            } else {
                HashMap<String, String> latestDraftArticleMetadataItemProperties = new HashMap<String, String>();
                this.setLatestDraftProperties(latestDraftArticleMetadataItemProperties, news);
                this.metadataService.createMetadataItem((MetadataObject)latestDraftObject, NEWS_METADATA_KEY, latestDraftArticleMetadataItemProperties);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return news;
    }

    private void setLatestDraftProperties(Map<String, String> properties, News news) throws FileStorageException {
        if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
            if (properties.containsKey(NEWS_UPLOAD_ID) && properties.get(NEWS_UPLOAD_ID) != null && properties.containsKey(NEWS_ILLUSTRATION_ID) && properties.get(NEWS_ILLUSTRATION_ID) != null) {
                if (!properties.get(NEWS_UPLOAD_ID).equals(news.getUploadId())) {
                    FileItem draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong(properties.get(NEWS_ILLUSTRATION_ID)));
                    Long draftArticleIllustrationId = this.saveArticleIllustration(news.getUploadId(), draftArticleIllustrationFileItem.getFileInfo().getId());
                    properties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                    this.setArticleIllustration(news, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
                }
            } else {
                Long draftArticleIllustrationId = this.saveArticleIllustration(news.getUploadId(), null);
                properties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                properties.put(NEWS_UPLOAD_ID, news.getUploadId());
                this.setArticleIllustration(news, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
            }
            properties.put(NEWS_UPLOAD_ID, news.getUploadId());
        } else if (properties.containsKey(NEWS_ILLUSTRATION_ID) && properties.get(NEWS_ILLUSTRATION_ID) != null && news.getUploadId() != null) {
            properties.remove(NEWS_UPLOAD_ID);
            FileItem draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong(properties.get(NEWS_ILLUSTRATION_ID)));
            properties.remove(NEWS_ILLUSTRATION_ID);
            this.fileService.deleteFile(draftArticleIllustrationFileItem.getFileInfo().getId().longValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)news.getSummary())) {
            properties.put(NEWS_SUMMARY, news.getSummary());
        }
        properties.put(NEWS_ACTIVITY_POSTED, String.valueOf(news.isActivityPosted()));
    }

    private News buildLatestDraftArticle(String parentPageId, String currentIdentityId) throws Exception {
        Page parentPage = this.noteService.getNoteById(parentPageId);
        if (parentPage == null) {
            return null;
        }
        DraftPage latestDraft = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(Long.parseLong(parentPageId)), currentIdentityId, null);
        if (latestDraft == null) {
            return this.buildArticle(parentPageId);
        }
        News draftArticle = this.buildDraftArticle(latestDraft.getId(), currentIdentityId);
        draftArticle.setId(parentPageId);
        return draftArticle;
    }

    private void processPageContent(Page page, News news) throws Exception {
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        String body = page.getContent();
        String sanitizedBody = HTMLSanitizer.sanitize((String)body);
        sanitizedBody = sanitizedBody.replaceAll(HTML_AT_SYMBOL_ESCAPED_PATTERN, HTML_AT_SYMBOL_PATTERN);
        news.setBody(MentionUtils.substituteUsernames((String)portalOwner, (String)sanitizedBody));
        news.setOriginalBody(sanitizedBody);
    }

    private void setSchedulePostDate(News news, Map<String, String> newsProperties) throws ParseException {
        String schedulePostDate = news.getSchedulePostDate();
        ZoneOffset userTimeZone = StringUtils.isBlank((CharSequence)news.getTimeZoneId()) ? ZoneOffset.UTC : ZoneId.of(news.getTimeZoneId());
        String offsetTimeZone = String.valueOf(OffsetTime.now(userTimeZone).getOffset()).replace(":", "");
        schedulePostDate = schedulePostDate.concat(" ").concat(offsetTimeZone);
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ssZ");
        Calendar startPublishedDate = Calendar.getInstance();
        startPublishedDate.setTime(format.parse(schedulePostDate));
        SimpleDateFormat defaultFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        defaultFormat.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String startPublishedDateString = defaultFormat.format(startPublishedDate.getTime());
        newsProperties.put(SCHEDULE_POST_DATE, startPublishedDateString);
    }

    private boolean isSameIllustration(String newsDraftId, String newsArticleId) throws ObjectNotFoundException, FileStorageException {
        String draftIllustrationId;
        FileItem fileItem;
        News news = this.getNewsArticleById(newsArticleId);
        if (news == null || news.getIllustration() == null) {
            return false;
        }
        NewsLatestDraftObject draftObject = new NewsLatestDraftObject(NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE, newsDraftId, newsArticleId, Long.parseLong(news.getSpaceId()));
        MetadataItem draftMetadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)draftObject).stream().findFirst().orElse(null);
        if (draftMetadataItem == null) {
            throw new ObjectNotFoundException("Metadata items not found for news draft " + newsDraftId);
        }
        Map draftProperties = draftMetadataItem.getProperties();
        if (draftProperties != null && (fileItem = this.fileService.getFile(Long.parseLong(draftIllustrationId = (String)draftProperties.getOrDefault(NEWS_ILLUSTRATION_ID, null)))) != null) {
            return Arrays.equals(fileItem.getAsByte(), news.getIllustration());
        }
        return false;
    }

    private News postScheduledArticle(News news) throws ObjectNotFoundException {
        NewsPageObject newsPageObject = new NewsPageObject(NEWS_METADATA_PAGE_OBJECT_TYPE, news.getId(), null, Long.parseLong(news.getSpaceId()));
        MetadataItem metadataItem = this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)newsPageObject).stream().findFirst().orElse(null);
        if (metadataItem == null) {
            throw new ObjectNotFoundException("Metadata items not found for news " + news.getId());
        }
        Map properties = metadataItem.getProperties();
        if (properties != null) {
            properties.put(NEWS_PUBLICATION_STATE, POSTED);
            properties.remove(SCHEDULE_POST_DATE);
            String poster = this.identityManager.getOrCreateUserIdentity(news.getAuthor()).getId();
            Date updateDate = Calendar.getInstance().getTime();
            metadataItem.setUpdatedDate(updateDate.getTime());
            this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(poster));
            news.setSchedulePostDate(null);
            return news;
        }
        if (!news.isPublished()) {
            this.newsTargetingService.deleteNewsTargets(news);
        }
        return null;
    }

    private Map<String, String> getArticleIllustrationInfo(News news) {
        MetadataItem metadataItem;
        PageVersion pageVersion;
        HashMap<String, String> illustrationInfo = new HashMap<String, String>();
        if (news.getIllustration() != null && (pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(Long.parseLong(news.getId())), null)) != null && (metadataItem = (MetadataItem)this.metadataService.getMetadataItemsByMetadataAndObject(NEWS_METADATA_KEY, (MetadataObject)new NewsPageVersionObject(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, pageVersion.getId(), null, Long.parseLong(news.getSpaceId()))).stream().findFirst().orElse(null)) != null && metadataItem.getProperties() != null && !metadataItem.getProperties().isEmpty()) {
            illustrationInfo.put(NEWS_ILLUSTRATION_ID, (String)metadataItem.getProperties().get(NEWS_ILLUSTRATION_ID));
            illustrationInfo.put(NEWS_UPLOAD_ID, (String)metadataItem.getProperties().get(NEWS_UPLOAD_ID));
        }
        return illustrationInfo;
    }
}

