/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.storage.cache;

import io.meeds.social.link.dao.LinkDAO;
import io.meeds.social.link.dao.LinkSettingDAO;
import io.meeds.social.link.model.Link;
import io.meeds.social.link.model.LinkSetting;
import io.meeds.social.link.storage.LinkStorage;
import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CachedLinkStorage
extends LinkStorage {
    public static final String CACHE_NAME = "social.linkSettings";
    private ExoCache<Serializable, LinkSetting> cache;
    private FutureExoCache<Serializable, LinkSetting, Object> futureCache;

    public CachedLinkStorage(LinkSettingDAO linkSettingDAO, LinkDAO linkDAO, CacheService cacheService) {
        super(linkSettingDAO, linkDAO);
        this.cache = cacheService.getCacheInstance(CACHE_NAME);
        Loader<Serializable, LinkSetting, Object> loader = new Loader<Serializable, LinkSetting, Object>(){

            public LinkSetting retrieve(Object context, Serializable key) throws Exception {
                if (key instanceof String) {
                    String name = (String)((Object)key);
                    return CachedLinkStorage.super.getLinkSetting(name);
                }
                if (key instanceof Long) {
                    Long id = (Long)key;
                    return CachedLinkStorage.super.getLinkSetting(id);
                }
                return null;
            }
        };
        this.futureCache = new FutureExoCache((Loader)loader, this.cache);
    }

    @Override
    public LinkSetting getLinkSetting(String name) {
        return this.clone((LinkSetting)this.futureCache.get(null, (Object)name));
    }

    @Override
    public LinkSetting getLinkSetting(Long id) {
        return this.clone((LinkSetting)this.futureCache.get(null, (Object)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkSetting initLinkSetting(String name, String pageId, long spaceId) {
        try {
            LinkSetting linkSetting = super.initLinkSetting(name, pageId, spaceId);
            return linkSetting;
        }
        finally {
            this.clearLinkSetting(name);
        }
    }

    @Override
    public LinkSetting saveLinkSetting(LinkSetting linkSetting) {
        try {
            LinkSetting linkSetting2 = super.saveLinkSetting(linkSetting);
            return linkSetting2;
        }
        finally {
            this.futureCache.remove((Serializable)((Object)linkSetting.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Link createLink(String linkSettingName, Link link) {
        try {
            Link link2 = super.createLink(linkSettingName, link);
            return link2;
        }
        finally {
            this.clearLinkSetting(linkSettingName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Link updateLink(String linkSettingName, Link link) {
        try {
            Link link2 = super.updateLink(linkSettingName, link);
            return link2;
        }
        finally {
            this.clearLinkSetting(linkSettingName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLink(String linkSettingName, long id) {
        try {
            super.deleteLink(linkSettingName, id);
        }
        finally {
            this.clearLinkSetting(linkSettingName);
        }
    }

    private void clearLinkSetting(String name) {
        LinkSetting linkSetting = (LinkSetting)this.futureCache.get((Serializable)((Object)name));
        if (linkSetting != null) {
            this.futureCache.remove((Serializable)((Object)name));
            this.futureCache.remove((Serializable)Long.valueOf(linkSetting.getId()));
        }
    }

    private LinkSetting clone(LinkSetting linkSetting) {
        return linkSetting == null ? null : linkSetting.clone();
    }
}

