/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.SharedSessionContract;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.internal.StandardBagSemantics;
import org.hibernate.collection.internal.StandardIdentifierBagSemantics;
import org.hibernate.collection.internal.StandardListSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingModelCreationLogging;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.PropertyBasedMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractEntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.metamodel.mapping.internal.CollectionIdentifierDescriptorImpl;
import org.hibernate.metamodel.mapping.internal.DiscriminatedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddableMappingTypeImpl;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.FetchOptionsHelper;
import org.hibernate.metamodel.mapping.internal.InverseNonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ManyToManyCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.NonAggregatedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.OneToManyCollectionPart;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SimpleAttributeMetadata;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.internal.VirtualEmbeddedAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.property.access.internal.ChainedPropertyAccessImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class MappingModelCreationHelper {
    private MappingModelCreationHelper() {
    }

    public static EntityIdentifierMapping buildEncapsulatedCompositeIdentifierMapping(EntityPersister entityPersister, Property bootProperty, String attributeName, String rootTableName, String[] rootTableKeyColumnNames, CompositeType cidType, MappingModelCreationProcess creationProcess) {
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        PropertyAccess propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        Component component = (Component)bootProperty.getValue();
        EmbeddableMappingTypeImpl embeddableMappingType = EmbeddableMappingTypeImpl.from(component, cidType, rootTableName, rootTableKeyColumnNames, bootProperty, null, 0, component.getColumnInsertability(), component.getColumnUpdateability(), embeddable -> new EmbeddedIdentifierMappingImpl(entityPersister, attributeName, (EmbeddableMappingType)embeddable, propertyAccess, rootTableName, creationProcess), creationProcess);
        return (EmbeddedIdentifierMappingImpl)embeddableMappingType.getEmbeddedValueMapping();
    }

    public static CompositeIdentifierMapping buildNonEncapsulatedCompositeIdentifierMapping(EntityPersister entityPersister, String rootTableName, String[] rootTableKeyColumnNames, PersistentClass bootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        return new NonAggregatedIdentifierMappingImpl(entityPersister, bootEntityDescriptor.getRootClass(), rootTableName, rootTableKeyColumnNames, creationProcess);
    }

    public static BasicAttributeMapping buildBasicAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, BasicType attrType, String tableExpression, String attrColumnName, SelectablePath selectablePath, boolean isAttrFormula, String readExpr, String writeExpr, String columnDefinition, Long length, Integer precision, Integer scale, boolean isLob, boolean nullable, boolean insertable, boolean updateable, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        boolean partitioned;
        FetchStyle fetchStyle;
        FetchTiming fetchTiming;
        SimpleValue value = (SimpleValue)bootProperty.getValue();
        BasicValue.Resolution<?> resolution = ((Resolvable)((Object)value)).resolve();
        SimpleAttributeMetadata attributeMetadata = new SimpleAttributeMetadata(propertyAccess, resolution.getMutabilityPlan(), bootProperty, value);
        if (declaringType instanceof EmbeddableMappingType) {
            if (bootProperty.isLazy()) {
                MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.debugf("Attribute was declared lazy, but is part of an embeddable - `%s#%s` - LAZY will be ignored", declaringType.getNavigableRole().getFullPath(), bootProperty.getName());
            }
            fetchTiming = FetchTiming.IMMEDIATE;
            fetchStyle = FetchStyle.JOIN;
            partitioned = value.isPartitionKey() && !((EmbeddableMappingType)declaringType).getEmbeddedValueMapping().isVirtual();
        } else {
            fetchTiming = bootProperty.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
            fetchStyle = bootProperty.isLazy() ? FetchStyle.SELECT : FetchStyle.JOIN;
            partitioned = value.isPartitionKey();
        }
        return new BasicAttributeMapping(attrName, navigableRole, stateArrayPosition, fetchableIndex, attributeMetadata, fetchTiming, fetchStyle, tableExpression, attrColumnName, selectablePath, isAttrFormula, readExpr, writeExpr, columnDefinition, length, precision, scale, isLob, nullable, insertable, updateable, partitioned, attrType, declaringType, propertyAccess);
    }

    public static EmbeddedAttributeMapping buildEmbeddedAttributeMapping(String attrName, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, CompositeType attrType, String tableExpression, String[] rootTableKeyColumnNames, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildEmbeddedAttributeMapping(attrName, stateArrayPosition, fetchableIndex, bootProperty, null, 0, declaringType, attrType, tableExpression, rootTableKeyColumnNames, propertyAccess, cascadeStyle, creationProcess);
    }

    public static EmbeddedAttributeMapping buildEmbeddedAttributeMapping(String attrName, int stateArrayPosition, int fetchableIndex, Property bootProperty, DependantValue dependantValue, int dependantColumnIndex, ManagedMappingType declaringType, CompositeType attrType, String tableExpression, String[] rootTableKeyColumnNames, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        AttributeMetadata attributeMetadataAccess = MappingModelCreationHelper.getAttributeMetadata(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
        Value componentValue = bootProperty.getValue();
        if (componentValue instanceof DependantValue && dependantValue != null) {
            componentValue = dependantValue.getWrappedValue();
        }
        Component component = (Component)componentValue;
        EmbeddableMappingTypeImpl embeddableMappingType = EmbeddableMappingTypeImpl.from(component, attrType, tableExpression, rootTableKeyColumnNames, bootProperty, dependantValue, dependantColumnIndex, component.getColumnInsertability(), component.getColumnUpdateability(), attributeMappingType -> {
            if (component.isEmbedded()) {
                return new VirtualEmbeddedAttributeMapping(attrName, declaringType.getNavigableRole().append(attrName), stateArrayPosition, fetchableIndex, tableExpression, attributeMetadataAccess, component.getParentProperty(), FetchTiming.IMMEDIATE, FetchStyle.JOIN, (EmbeddableMappingType)attributeMappingType, declaringType, propertyAccess);
            }
            return new EmbeddedAttributeMapping(attrName, declaringType.getNavigableRole().append(attrName), stateArrayPosition, fetchableIndex, tableExpression, attributeMetadataAccess, component.getParentProperty(), FetchTiming.IMMEDIATE, FetchStyle.JOIN, (EmbeddableMappingType)attributeMappingType, declaringType, propertyAccess);
        }, creationProcess);
        return (EmbeddedAttributeMapping)embeddableMappingType.getEmbeddedValueMapping();
    }

    protected static AttributeMetadata getAttributeMetadata(Property bootProperty, Type attrType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        MutabilityPlan mutabilityPlan = MappingModelCreationHelper.getMutabilityPlan(bootProperty, attrType, creationProcess);
        return new SimpleAttributeMetadata(propertyAccess, mutabilityPlan, bootProperty.getValue().isNullable(), bootProperty.isInsertable(), bootProperty.isUpdateable(), bootProperty.isOptimisticLocked(), bootProperty.isSelectable(), cascadeStyle);
    }

    private static MutabilityPlan getMutabilityPlan(Property bootProperty, final Type attrType, final MappingModelCreationProcess creationProcess) {
        if (bootProperty.isUpdateable()) {
            return new MutabilityPlan(){
                final SessionFactoryImplementor sessionFactory;
                {
                    this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
                }

                @Override
                public boolean isMutable() {
                    return true;
                }

                public Object deepCopy(Object value) {
                    if (value == null) {
                        return null;
                    }
                    return attrType.deepCopy(value, this.sessionFactory);
                }

                public Serializable disassemble(Object value, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }

                public Object assemble(Serializable cached, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return ImmutableMutabilityPlan.INSTANCE;
    }

    public static AttributeMetadata getAttributeMetadata(PropertyAccess propertyAccess) {
        return new SimpleAttributeMetadata(propertyAccess, ImmutableMutabilityPlan.INSTANCE, false, true, false, false, true, null);
    }

    public static PluralAttributeMapping buildPluralAttributeMapping(String attrName, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, FetchMode fetchMode, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildPluralAttributeMapping(attrName, stateArrayPosition, fetchableIndex, bootProperty, declaringType, propertyAccess, cascadeStyle, fetchMode, creationProcess, Function.identity());
    }

    public static PluralAttributeMapping buildPluralAttributeMapping(String attrName, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, FetchMode fetchMode, MappingModelCreationProcess creationProcess, Function<PluralAttributeMappingImpl, PluralAttributeMappingImpl> mappingConverter) {
        CollectionPart indexDescriptor;
        CollectionMappingTypeImpl collectionMappingType;
        org.hibernate.mapping.Collection bootValueMapping = (org.hibernate.mapping.Collection)bootProperty.getValue();
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        Dialect dialect = creationContext.getDialect();
        MappingMetamodelImplementor domainModel = creationContext.getDomainModel();
        CollectionPersister collectionDescriptor = domainModel.findCollectionDescriptor(bootValueMapping.getRole());
        assert (collectionDescriptor != null);
        String tableExpression = ((Joinable)((Object)collectionDescriptor)).getTableName();
        String sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(bootProperty.getName());
        JavaTypeRegistry jtdRegistry = creationContext.getJavaTypeRegistry();
        CollectionPart elementDescriptor = MappingModelCreationHelper.interpretElement(bootValueMapping, tableExpression, collectionDescriptor, sqlAliasStem, dialect, creationProcess);
        CollectionIdentifierDescriptorImpl identifierDescriptor = null;
        CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
        switch (collectionSemantics.getCollectionClassification()) {
            case ARRAY: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Object[].class)), StandardArraySemantics.INSTANCE);
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, index.getSelectables().get(0), creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), creationProcess.getCreationContext().getTypeConfiguration(), index.isColumnInsertable(0), index.isColumnUpdateable(0), false, dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, selectableMapping);
                break;
            }
            case BAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Collection.class)), StandardBagSemantics.INSTANCE);
                indexDescriptor = null;
                break;
            }
            case ID_BAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Collection.class)), StandardIdentifierBagSemantics.INSTANCE);
                indexDescriptor = null;
                assert (collectionDescriptor instanceof SQLLoadableCollection);
                SQLLoadableCollection loadableCollection = (SQLLoadableCollection)collectionDescriptor;
                String identifierColumnName = loadableCollection.getIdentifierColumnName();
                assert (identifierColumnName != null);
                identifierDescriptor = new CollectionIdentifierDescriptorImpl(collectionDescriptor, tableExpression, identifierColumnName, (BasicType)loadableCollection.getIdentifierType());
                break;
            }
            case LIST: {
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, index.getSelectables().get(0), creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), creationProcess.getCreationContext().getTypeConfiguration(), index.isColumnInsertable(0), index.isColumnUpdateable(0), false, dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, selectableMapping);
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)List.class)), StandardListSemantics.INSTANCE);
                break;
            }
            case MAP: 
            case ORDERED_MAP: 
            case SORTED_MAP: {
                Class mapJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedMap.class : java.util.Map.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)mapJavaType)), collectionSemantics);
                String mapKeyTableExpression = bootValueMapping instanceof Map && ((Map)bootValueMapping).getMapKeyPropertyName() != null ? MappingModelCreationHelper.getTableIdentifierExpression(((Map)bootValueMapping).getIndex().getTable(), creationProcess) : tableExpression;
                indexDescriptor = MappingModelCreationHelper.interpretMapKey(bootValueMapping, collectionDescriptor, mapKeyTableExpression, sqlAliasStem, dialect, creationProcess);
                break;
            }
            case SET: 
            case ORDERED_SET: 
            case SORTED_SET: {
                Class setJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedSet.class : Set.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)setJavaType)), collectionSemantics);
                indexDescriptor = null;
                break;
            }
            default: {
                throw new MappingException("Unexpected CollectionClassification : " + collectionSemantics.getCollectionClassification());
            }
        }
        SimpleAttributeMetadata attributeMetadata = new SimpleAttributeMetadata(propertyAccess, ImmutableMutabilityPlan.instance(), bootProperty.isOptional(), bootProperty.isInsertable(), bootProperty.isUpdateable(), bootProperty.isOptimisticLocked(), bootProperty.isSelectable(), cascadeStyle);
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        FetchStyle style = FetchOptionsHelper.determineFetchStyleByMetadata(fetchMode, collectionDescriptor.getCollectionType(), sessionFactory);
        FetchTiming timing = FetchOptionsHelper.determineFetchTiming(style, collectionDescriptor.getCollectionType(), collectionDescriptor.isLazy(), collectionDescriptor.getRole(), sessionFactory);
        PluralAttributeMappingImpl pluralAttributeMapping = mappingConverter.apply(new PluralAttributeMappingImpl(attrName, bootValueMapping, propertyAccess, attributeMetadata, collectionMappingType, stateArrayPosition, fetchableIndex, elementDescriptor, indexDescriptor, identifierDescriptor, timing, style, cascadeStyle, declaringType, collectionDescriptor, creationProcess));
        creationProcess.registerInitializationCallback("PluralAttributeMapping(" + bootValueMapping.getRole() + ")#finishInitialization", () -> {
            pluralAttributeMapping.finishInitialization(bootProperty, bootValueMapping, creationProcess);
            return true;
        });
        creationProcess.registerInitializationCallback("PluralAttributeMapping(" + bootValueMapping.getRole() + ") - key descriptor", () -> {
            MappingModelCreationHelper.interpretPluralAttributeMappingKeyDescriptor(pluralAttributeMapping, bootValueMapping, collectionDescriptor, declaringType, dialect, creationProcess);
            return true;
        });
        return pluralAttributeMapping;
    }

    private static void interpretPluralAttributeMappingKeyDescriptor(PluralAttributeMappingImpl attributeMapping, org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, ManagedMappingType declaringType, Dialect dialect, MappingModelCreationProcess creationProcess) {
        ModelPart attributeMappingSubPart = null;
        if (!StringHelper.isEmpty(collectionDescriptor.getMappedByProperty())) {
            attributeMappingSubPart = ((ModelPartContainer)((Object)attributeMapping.getElementDescriptor().getPartMappingType())).findSubPart(collectionDescriptor.getMappedByProperty(), null);
        }
        if (attributeMappingSubPart instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping referencedAttributeMapping = (ToOneAttributeMapping)attributeMappingSubPart;
            MappingModelCreationHelper.setReferencedAttributeForeignKeyDescriptor(attributeMapping, referencedAttributeMapping, referencedAttributeMapping.findContainingEntityMapping().getEntityPersister(), collectionDescriptor.getMappedByProperty(), dialect, creationProcess);
            return;
        }
        KeyValue bootValueMappingKey = bootValueMapping.getKey();
        Type keyType = bootValueMappingKey.getType();
        String lhsPropertyName = collectionDescriptor.getCollectionType().getLHSPropertyName();
        boolean isReferenceToPrimaryKey = lhsPropertyName == null;
        String collectionTableName = ((AbstractCollectionPersister)collectionDescriptor).getTableName();
        ManagedMappingType keyDeclaringType = collectionDescriptor.getElementType().isEntityType() ? ((QueryableCollection)collectionDescriptor).getElementPersister() : declaringType;
        ValuedModelPart fkTargetPart = isReferenceToPrimaryKey ? collectionDescriptor.getOwnerEntityPersister().getIdentifierMapping() : declaringType.findContainingEntityMapping().findAttributeMapping(lhsPropertyName);
        if (keyType instanceof BasicType) {
            assert (bootValueMappingKey.getColumnSpan() == 1);
            assert (fkTargetPart instanceof BasicValuedModelPart);
            BasicValuedModelPart simpleFkTargetPart = (BasicValuedModelPart)fkTargetPart;
            String keyTableExpression = collectionTableName;
            SelectableMapping keySelectableMapping = SelectableMappingImpl.from(keyTableExpression, bootValueMappingKey.getSelectables().get(0), (JdbcMapping)((Object)keyType), creationProcess.getCreationContext().getTypeConfiguration(), bootValueMappingKey.isColumnInsertable(0), bootValueMappingKey.isColumnUpdateable(0), false, dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
            SimpleForeignKeyDescriptor keyDescriptor = new SimpleForeignKeyDescriptor(keyDeclaringType, keySelectableMapping, simpleFkTargetPart, isReferenceToPrimaryKey, ((SimpleValue)bootValueMappingKey).isConstrained());
            attributeMapping.setForeignKeyDescriptor(keyDescriptor);
            creationProcess.registerForeignKey(collectionDescriptor.getAttributeMapping(), keyDescriptor);
        } else if (fkTargetPart instanceof EmbeddableValuedModelPart) {
            EmbeddedForeignKeyDescriptor keyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)fkTargetPart, bootValueMapping, keyDeclaringType, collectionDescriptor.getAttributeMapping(), collectionTableName, false, bootValueMappingKey.getColumnInsertability(), bootValueMappingKey.getColumnUpdateability(), dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(keyDescriptor);
            creationProcess.registerForeignKey(collectionDescriptor.getAttributeMapping(), keyDescriptor);
        } else {
            throw new UnsupportedOperationException("Support for " + fkTargetPart.getClass() + " foreign keys not yet implemented: " + bootValueMapping.getRole());
        }
    }

    public static boolean interpretToOneKeyDescriptor(ToOneAttributeMapping attributeMapping, Property bootProperty, ToOne bootValueMapping, PropertyAccess inversePropertyAccess, Dialect dialect, MappingModelCreationProcess creationProcess) {
        String referencedPropertyName;
        if (attributeMapping.getForeignKeyDescriptor() != null) {
            return true;
        }
        String tableName = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMapping.getTable(), creationProcess);
        attributeMapping.setIdentifyingColumnsTableExpression(tableName);
        EntityPersister referencedEntityDescriptor = creationProcess.getEntityPersister(bootValueMapping.getReferencedEntityName());
        boolean swapDirection = false;
        if (bootValueMapping instanceof OneToOne) {
            OneToOne oneToOne = (OneToOne)bootValueMapping;
            swapDirection = oneToOne.getForeignKeyType() == ForeignKeyDirection.TO_PARENT;
            referencedPropertyName = oneToOne.getMappedByProperty();
            if (referencedPropertyName == null) {
                referencedPropertyName = oneToOne.getReferencedPropertyName();
            }
        } else {
            referencedPropertyName = null;
        }
        if (referencedPropertyName != null) {
            if (referencedPropertyName.indexOf(46) > 0) {
                return MappingModelCreationHelper.interpretNestedToOneKeyDescriptor(referencedEntityDescriptor, referencedPropertyName, attributeMapping);
            }
            ModelPart modelPart = referencedEntityDescriptor.findByPath(referencedPropertyName);
            if (modelPart instanceof ToOneAttributeMapping) {
                MappingModelCreationHelper.setReferencedAttributeForeignKeyDescriptor(attributeMapping, (ToOneAttributeMapping)modelPart, referencedEntityDescriptor, referencedPropertyName, dialect, creationProcess);
            } else if (modelPart instanceof EmbeddableValuedModelPart) {
                EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)modelPart, bootValueMapping, attributeMapping.getDeclaringType(), attributeMapping.findContainingEntityMapping(), true, bootValueMapping.getColumnInsertability(), bootValueMapping.getColumnUpdateability(), dialect, creationProcess);
                attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
            } else {
                if (modelPart == null) {
                    throw new IllegalArgumentException("Unable to find attribute " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
                }
                throw new UnsupportedOperationException("Support for foreign-keys based on `" + modelPart + "` not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
            }
            return true;
        }
        ModelPart fkTarget = bootValueMapping.isReferenceToPrimaryKey() ? referencedEntityDescriptor.getIdentifierMapping() : referencedEntityDescriptor.findByPath(bootValueMapping.getReferencedPropertyName());
        if (fkTarget instanceof BasicValuedModelPart) {
            SelectableMapping keySelectableMapping;
            PropertyAccess declaringKeyPropertyAccess;
            BasicValuedModelPart simpleFkTarget = (BasicValuedModelPart)fkTarget;
            Iterator<Selectable> columnIterator = bootValueMapping.getSelectables().iterator();
            Table table = bootValueMapping.getTable();
            String tableExpression = MappingModelCreationHelper.getTableIdentifierExpression(table, creationProcess);
            if (inversePropertyAccess == null) {
                if (bootValueMapping instanceof OneToOne) {
                    EntityIdentifierMapping identifierMapping = attributeMapping.findContainingEntityMapping().getIdentifierMapping();
                    declaringKeyPropertyAccess = ((PropertyBasedMapping)((Object)identifierMapping)).getPropertyAccess();
                } else {
                    declaringKeyPropertyAccess = new ChainedPropertyAccessImpl(attributeMapping.getPropertyAccess(), ((PropertyBasedMapping)((Object)simpleFkTarget)).getPropertyAccess());
                }
            } else {
                declaringKeyPropertyAccess = new ChainedPropertyAccessImpl(inversePropertyAccess, ((PropertyBasedMapping)((Object)simpleFkTarget)).getPropertyAccess());
            }
            int i = 0;
            Value value = bootProperty.getValue();
            if (columnIterator.hasNext()) {
                keySelectableMapping = SelectableMappingImpl.from(tableExpression, columnIterator.next(), simpleFkTarget.getJdbcMapping(), creationProcess.getCreationContext().getTypeConfiguration(), value.isColumnInsertable(i), value.isColumnUpdateable(i), ((SimpleValue)value).isPartitionKey(), dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
                ++i;
            } else {
                keySelectableMapping = SelectableMappingImpl.from(tableExpression, table.getPrimaryKey().getColumn(0), simpleFkTarget.getJdbcMapping(), creationProcess.getCreationContext().getTypeConfiguration(), value.isColumnInsertable(0), value.isColumnUpdateable(0), ((SimpleValue)value).isPartitionKey(), dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
            }
            SimpleForeignKeyDescriptor foreignKeyDescriptor = new SimpleForeignKeyDescriptor(attributeMapping.getDeclaringType(), keySelectableMapping, declaringKeyPropertyAccess, simpleFkTarget, bootValueMapping.isReferenceToPrimaryKey(), bootValueMapping.isConstrained(), swapDirection);
            attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
            creationProcess.registerForeignKey(attributeMapping, foreignKeyDescriptor);
        } else if (fkTarget instanceof EmbeddableValuedModelPart) {
            Value value = bootProperty.getValue();
            EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)fkTarget, bootValueMapping, attributeMapping.getDeclaringType(), attributeMapping.findContainingEntityMapping(), swapDirection, value.getColumnInsertability(), value.getColumnUpdateability(), dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
            creationProcess.registerForeignKey(attributeMapping, embeddedForeignKeyDescriptor);
        } else {
            throw new UnsupportedOperationException("Support for " + fkTarget.getClass() + " foreign-keys not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
        }
        return true;
    }

    private static boolean interpretNestedToOneKeyDescriptor(EntityPersister referencedEntityDescriptor, String referencedPropertyName, ToOneAttributeMapping attributeMapping) {
        String[] propertyPath = StringHelper.split(".", referencedPropertyName);
        EmbeddableValuedModelPart lastEmbeddableModelPart = null;
        for (int i = 0; i < propertyPath.length; ++i) {
            String path = propertyPath[i];
            ModelPart modelPart = i == 0 ? referencedEntityDescriptor.findSubPart(path) : lastEmbeddableModelPart.findSubPart(path, null);
            if (modelPart == null) {
                return false;
            }
            if (modelPart instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping referencedAttributeMapping = (ToOneAttributeMapping)modelPart;
                ForeignKeyDescriptor foreignKeyDescriptor = referencedAttributeMapping.getForeignKeyDescriptor();
                if (foreignKeyDescriptor == null) {
                    return false;
                }
                attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
                return true;
            }
            if (!(modelPart instanceof EmbeddableValuedModelPart)) {
                return false;
            }
            lastEmbeddableModelPart = (EmbeddableValuedModelPart)modelPart;
        }
        return false;
    }

    public static EmbeddedForeignKeyDescriptor buildEmbeddableForeignKeyDescriptor(EmbeddableValuedModelPart embeddableValuedModelPart, Value bootValueMapping, ManagedMappingType keyDeclaringType, TableGroupProducer keyDeclaringTableGroupProducer, boolean inverse, boolean[] insertable, boolean[] updateable, Dialect dialect, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor(embeddableValuedModelPart, bootValueMapping, keyDeclaringType, keyDeclaringTableGroupProducer, null, inverse, insertable, updateable, dialect, creationProcess);
    }

    private static EmbeddedForeignKeyDescriptor buildEmbeddableForeignKeyDescriptor(EmbeddableValuedModelPart embeddableValuedModelPart, Value bootValueMapping, ManagedMappingType keyDeclaringType, TableGroupProducer keyDeclaringTableGroupProducer, String keyTableExpression, boolean inverse, boolean[] insertable, boolean[] updateable, Dialect dialect, MappingModelCreationProcess creationProcess) {
        SelectableMappings keySelectableMappings;
        boolean hasConstraint;
        if (bootValueMapping instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionBootValueMapping = (org.hibernate.mapping.Collection)bootValueMapping;
            hasConstraint = ((SimpleValue)collectionBootValueMapping.getKey()).isConstrained();
            keyTableExpression = keyTableExpression != null ? keyTableExpression : MappingModelCreationHelper.getTableIdentifierExpression(collectionBootValueMapping.getCollectionTable(), creationProcess);
            keySelectableMappings = SelectableMappingsImpl.from(keyTableExpression, collectionBootValueMapping.getKey(), MappingModelCreationHelper.getPropertyOrder(bootValueMapping, creationProcess), creationProcess.getCreationContext().getMetadata(), creationProcess.getCreationContext().getTypeConfiguration(), insertable, updateable, dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
        } else {
            hasConstraint = bootValueMapping instanceof OneToMany ? !bootValueMapping.isNullable() : ((SimpleValue)bootValueMapping).isConstrained();
            keyTableExpression = keyTableExpression != null ? keyTableExpression : MappingModelCreationHelper.getTableIdentifierExpression(bootValueMapping.getTable(), creationProcess);
            keySelectableMappings = SelectableMappingsImpl.from(keyTableExpression, bootValueMapping, MappingModelCreationHelper.getPropertyOrder(bootValueMapping, creationProcess), creationProcess.getCreationContext().getMetadata(), creationProcess.getCreationContext().getTypeConfiguration(), insertable, updateable, dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
        }
        if (inverse) {
            return new EmbeddedForeignKeyDescriptor(embeddableValuedModelPart, MappingModelCreationHelper.createInverseModelPart(embeddableValuedModelPart, keyDeclaringType, keyDeclaringTableGroupProducer, keySelectableMappings, creationProcess), embeddableValuedModelPart.getContainingTableExpression(), embeddableValuedModelPart.getEmbeddableTypeDescriptor(), keyTableExpression, keySelectableMappings, hasConstraint, creationProcess);
        }
        return new EmbeddedForeignKeyDescriptor(MappingModelCreationHelper.createInverseModelPart(embeddableValuedModelPart, keyDeclaringType, keyDeclaringTableGroupProducer, keySelectableMappings, creationProcess), embeddableValuedModelPart, keyTableExpression, keySelectableMappings, embeddableValuedModelPart.getContainingTableExpression(), embeddableValuedModelPart.getEmbeddableTypeDescriptor(), hasConstraint, creationProcess);
    }

    public static int[] getPropertyOrder(Value bootValueMapping, MappingModelCreationProcess creationProcess) {
        boolean sorted;
        ComponentType componentType;
        if (bootValueMapping instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionBootValueMapping = (org.hibernate.mapping.Collection)bootValueMapping;
            componentType = (ComponentType)collectionBootValueMapping.getKey().getType();
            assert (((SortableValue)((Object)collectionBootValueMapping.getKey())).isSorted());
            sorted = ((SortableValue)((Object)collectionBootValueMapping.getKey())).isSorted();
        } else {
            EntityType entityType = (EntityType)bootValueMapping.getType();
            Type identifierOrUniqueKeyType = entityType.getIdentifierOrUniqueKeyType(creationProcess.getCreationContext().getMetadata());
            if (identifierOrUniqueKeyType instanceof ComponentType) {
                componentType = (ComponentType)identifierOrUniqueKeyType;
                if (bootValueMapping instanceof ToOne) {
                    assert (((ToOne)bootValueMapping).isSorted());
                    sorted = ((ToOne)bootValueMapping).isSorted();
                } else {
                    sorted = true;
                }
            } else {
                return new int[]{0};
            }
        }
        if (!sorted && componentType.getOriginalPropertyOrder() != null) {
            return componentType.getOriginalPropertyOrder();
        }
        int columnSpan = componentType.getColumnSpan(creationProcess.getCreationContext().getBootModel());
        int[] propertyReordering = new int[columnSpan];
        for (int i = 0; i < columnSpan; ++i) {
            propertyReordering[i] = i;
        }
        return propertyReordering;
    }

    private static void setReferencedAttributeForeignKeyDescriptor(AbstractAttributeMapping attributeMapping, ToOneAttributeMapping referencedAttributeMapping, EntityPersister referencedEntityDescriptor, String referencedPropertyName, Dialect dialect, MappingModelCreationProcess creationProcess) {
        ForeignKeyDescriptor foreignKeyDescriptor = referencedAttributeMapping.getForeignKeyDescriptor();
        if (foreignKeyDescriptor == null) {
            PersistentClass entityBinding = creationProcess.getCreationContext().getBootModel().getEntityBinding(referencedEntityDescriptor.getEntityName());
            Property property = entityBinding.getRecursiveProperty(referencedPropertyName);
            MappingModelCreationHelper.interpretToOneKeyDescriptor(referencedAttributeMapping, property, (ToOne)property.getValue(), referencedAttributeMapping.getPropertyAccess(), dialect, creationProcess);
            foreignKeyDescriptor = referencedAttributeMapping.getForeignKeyDescriptor();
        }
        EntityMappingType declaringEntityMapping = attributeMapping.findContainingEntityMapping();
        if (foreignKeyDescriptor.getTargetPart() instanceof EntityIdentifierMapping && foreignKeyDescriptor.getTargetPart() != declaringEntityMapping.getIdentifierMapping()) {
            attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor.withTargetPart(declaringEntityMapping.getIdentifierMapping()));
        } else {
            attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
        }
    }

    public static String getTableIdentifierExpression(Table table, MappingModelCreationProcess creationProcess) {
        if (table.getSubselect() != null) {
            return "( " + table.getSubselect() + " )";
        }
        return creationProcess.getCreationContext().getSqlStringGenerationContext().format(table.getQualifiedTableName());
    }

    public static String getTableIdentifierExpression(Table table, SessionFactoryImplementor sessionFactory) {
        if (table.getSubselect() != null) {
            return "( " + table.getSubselect() + " )";
        }
        return sessionFactory.getSqlStringGenerationContext().format(table.getQualifiedTableName());
    }

    private static CollectionPart interpretMapKey(org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, String tableExpression, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        assert (bootValueMapping instanceof IndexedCollection);
        IndexedCollection indexedCollection = (IndexedCollection)bootValueMapping;
        Value bootMapKeyDescriptor = indexedCollection.getIndex();
        if (bootMapKeyDescriptor instanceof BasicValue) {
            boolean updatable;
            boolean insertable;
            BasicValue basicValue = (BasicValue)bootMapKeyDescriptor;
            if (indexedCollection instanceof Map && ((Map)indexedCollection).getMapKeyPropertyName() != null) {
                insertable = false;
                updatable = false;
            } else {
                updatable = basicValue.isColumnInsertable(0) || basicValue.isColumnUpdateable(0);
                insertable = updatable;
            }
            SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, basicValue.getSelectables().get(0), basicValue.resolve().getJdbcMapping(), creationProcess.getCreationContext().getTypeConfiguration(), insertable, updatable, false, dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, selectableMapping);
        }
        if (bootMapKeyDescriptor instanceof Component) {
            Component component = (Component)bootMapKeyDescriptor;
            CompositeType compositeType = component.getType();
            EmbeddableMappingTypeImpl mappingType = EmbeddableMappingTypeImpl.from(component, compositeType, component.getColumnInsertability(), component.getColumnUpdateability(), inflightDescriptor -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, (EmbeddableMappingType)inflightDescriptor, component.getParentProperty(), tableExpression, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (bootMapKeyDescriptor instanceof OneToMany || bootMapKeyDescriptor instanceof ToOne) {
            EntityType indexEntityType = (EntityType)collectionDescriptor.getIndexType();
            EntityPersister associatedEntity = creationProcess.getEntityPersister(indexEntityType.getAssociatedEntityName());
            AbstractEntityCollectionPart indexDescriptor = bootMapKeyDescriptor instanceof OneToMany ? new OneToManyCollectionPart(CollectionPart.Nature.INDEX, bootValueMapping, collectionDescriptor, associatedEntity, creationProcess) : new ManyToManyCollectionPart(CollectionPart.Nature.INDEX, bootValueMapping, collectionDescriptor, associatedEntity, creationProcess);
            creationProcess.registerInitializationCallback("PluralAttributeMapping( " + bootValueMapping.getRole() + ") - index descriptor", () -> indexDescriptor.finishInitialization(collectionDescriptor, bootValueMapping, indexEntityType.getRHSUniqueKeyPropertyName(), creationProcess));
            return indexDescriptor;
        }
        throw new UnsupportedOperationException("Support for plural attributes with index type [" + bootMapKeyDescriptor + "] not yet implemented");
    }

    private static CollectionPart interpretElement(org.hibernate.mapping.Collection bootDescriptor, String tableExpression, CollectionPersister collectionDescriptor, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        Value element = bootDescriptor.getElement();
        if (element instanceof BasicValue) {
            BasicValue basicElement = (BasicValue)element;
            SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, basicElement.getSelectables().get(0), basicElement.resolve().getJdbcMapping(), creationProcess.getCreationContext().getTypeConfiguration(), basicElement.isColumnInsertable(0), basicElement.isColumnUpdateable(0), basicElement.isPartitionKey(), true, dialect, creationProcess.getSqmFunctionRegistry(), creationProcess.getCreationContext());
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, selectableMapping);
        }
        if (element instanceof Component) {
            Component component = (Component)element;
            CompositeType compositeType = (CompositeType)collectionDescriptor.getElementType();
            EmbeddableMappingTypeImpl mappingType = EmbeddableMappingTypeImpl.from(component, compositeType, component.getColumnInsertability(), component.getColumnUpdateability(), embeddableMappingType -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, (EmbeddableMappingType)embeddableMappingType, component.getParentProperty(), tableExpression, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (element instanceof Any) {
            Any anyBootMapping = (Any)element;
            TypeConfiguration typeConfiguration = creationProcess.getCreationContext().getTypeConfiguration();
            JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
            JavaType<Object> baseJtd = jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Object.class));
            return new DiscriminatedCollectionPart(CollectionPart.Nature.ELEMENT, collectionDescriptor, baseJtd, anyBootMapping, anyBootMapping.getType(), creationProcess);
        }
        if (element instanceof OneToMany || element instanceof ToOne) {
            EntityType elementEntityType = (EntityType)collectionDescriptor.getElementType();
            EntityPersister associatedEntity = creationProcess.getEntityPersister(elementEntityType.getAssociatedEntityName());
            AbstractEntityCollectionPart elementDescriptor = element instanceof OneToMany ? new OneToManyCollectionPart(CollectionPart.Nature.ELEMENT, bootDescriptor, collectionDescriptor, associatedEntity, ((OneToMany)element).getNotFoundAction(), creationProcess) : new ManyToManyCollectionPart(CollectionPart.Nature.ELEMENT, bootDescriptor, collectionDescriptor, associatedEntity, ((ManyToOne)element).getNotFoundAction(), creationProcess);
            creationProcess.registerInitializationCallback("PluralAttributeMapping( " + elementDescriptor.getNavigableRole() + ") - element descriptor", () -> elementDescriptor.finishInitialization(collectionDescriptor, bootDescriptor, elementEntityType.getRHSUniqueKeyPropertyName(), creationProcess));
            return elementDescriptor;
        }
        throw new UnsupportedOperationException("Unexpected plural-attribute element type : " + element.getClass().getName());
    }

    public static EmbeddedAttributeMapping createInverseModelPart(EmbeddableValuedModelPart modelPart, ManagedMappingType keyDeclaringType, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        EmbeddableMappingType embeddableTypeDescriptor = modelPart.getEmbeddableTypeDescriptor();
        if (modelPart instanceof NonAggregatedIdentifierMapping) {
            return new InverseNonAggregatedIdentifierMapping(keyDeclaringType, declaringTableGroupProducer, selectableMappings, (NonAggregatedIdentifierMapping)modelPart, embeddableTypeDescriptor, creationProcess);
        }
        if (modelPart instanceof VirtualModelPart) {
            return new VirtualEmbeddedAttributeMapping(keyDeclaringType, declaringTableGroupProducer, selectableMappings, modelPart, embeddableTypeDescriptor, creationProcess);
        }
        return new EmbeddedAttributeMapping(keyDeclaringType, declaringTableGroupProducer, selectableMappings, modelPart, embeddableTypeDescriptor, creationProcess);
    }

    public static Expression buildColumnReferenceExpression(TableGroup tableGroup, ModelPart modelPart, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        int jdbcTypeCount = modelPart.getJdbcTypeCount();
        if (modelPart instanceof EmbeddableValuedModelPart) {
            ArrayList columnReferences = new ArrayList(jdbcTypeCount);
            modelPart.forEachSelectable((columnIndex, selection) -> {
                String qualifier = tableGroup == null ? selection.getContainingTableExpression() : tableGroup.resolveTableReference(selection.getContainingTableExpression()).getIdentificationVariable();
                ColumnReference colRef = sqlExpressionResolver == null ? new ColumnReference(qualifier, selection) : (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(qualifier, selection), sqlAstProcessingState -> new ColumnReference(qualifier, selection));
                columnReferences.add(colRef);
            });
            return new SqlTuple(columnReferences, modelPart);
        }
        assert (modelPart instanceof BasicValuedModelPart);
        BasicValuedModelPart basicPart = (BasicValuedModelPart)modelPart;
        String qualifier = tableGroup == null ? basicPart.getContainingTableExpression() : tableGroup.resolveTableReference(basicPart.getContainingTableExpression()).getIdentificationVariable();
        if (sqlExpressionResolver == null) {
            return new ColumnReference(qualifier, (SelectableMapping)basicPart);
        }
        return sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(qualifier, (SelectableMapping)basicPart), sqlAstProcessingState -> new ColumnReference(qualifier, (SelectableMapping)basicPart));
    }

    public static ToOneAttributeMapping buildSingularAssociationAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, EntityType attrType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildSingularAssociationAttributeMapping(attrName, navigableRole, stateArrayPosition, fetchableIndex, bootProperty, declaringType, declaringEntityPersister, attrType, propertyAccess, cascadeStyle, creationProcess, Function.identity());
    }

    public static ToOneAttributeMapping buildSingularAssociationAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, Property bootProperty, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, EntityType attrType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess, Function<ToOneAttributeMapping, ToOneAttributeMapping> mappingConverter) {
        if (bootProperty.getValue() instanceof ToOne) {
            FetchTiming fetchTiming;
            ToOne value = (ToOne)bootProperty.getValue();
            EntityPersister entityPersister = creationProcess.getEntityPersister(value.getReferencedEntityName());
            AttributeMetadata attributeMetadata = MappingModelCreationHelper.getAttributeMetadata(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
            SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
            AssociationType type = (AssociationType)bootProperty.getType();
            FetchStyle fetchStyle = FetchOptionsHelper.determineFetchStyleByMetadata(bootProperty.getValue().getFetchMode(), type, sessionFactory);
            String role = declaringType.getNavigableRole().toString() + "." + bootProperty.getName();
            boolean lazy = value.isLazy();
            if (lazy && entityPersister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                fetchTiming = value.isUnwrapProxy() ? FetchOptionsHelper.determineFetchTiming(fetchStyle, type, lazy, role, sessionFactory) : (value instanceof ManyToOne && value.isNullable() && ((ManyToOne)value).isIgnoreNotFound() ? FetchTiming.IMMEDIATE : FetchOptionsHelper.determineFetchTiming(fetchStyle, type, lazy, role, sessionFactory));
            } else if (!lazy || value instanceof OneToOne && value.isNullable() || value instanceof ManyToOne && value.isNullable() && ((ManyToOne)value).isIgnoreNotFound()) {
                fetchTiming = FetchTiming.IMMEDIATE;
                if (lazy && MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.isDebugEnabled()) {
                    MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.debugf("Forcing FetchTiming.IMMEDIATE for to-one association : %s.%s", declaringType.getNavigableRole(), bootProperty.getName());
                }
            } else {
                fetchTiming = FetchOptionsHelper.determineFetchTiming(fetchStyle, type, lazy, role, sessionFactory);
            }
            ToOneAttributeMapping attributeMapping = mappingConverter.apply(new ToOneAttributeMapping(attrName, navigableRole, stateArrayPosition, fetchableIndex, (ToOne)bootProperty.getValue(), attributeMetadata, fetchTiming, fetchStyle, entityPersister, declaringType, declaringEntityPersister, propertyAccess));
            creationProcess.registerForeignKeyPostInitCallbacks("To-one key - " + navigableRole, () -> MappingModelCreationHelper.interpretToOneKeyDescriptor(attributeMapping, bootProperty, (ToOne)bootProperty.getValue(), null, creationProcess.getCreationContext().getDialect(), creationProcess));
            return attributeMapping;
        }
        throw new UnsupportedOperationException("AnyType support has not yet been implemented");
    }

    private static class CollectionMappingTypeImpl
    implements CollectionMappingType {
        private final JavaType<?> collectionJtd;
        private final CollectionSemantics<?, ?> semantics;

        public CollectionMappingTypeImpl(JavaType<?> collectionJtd, CollectionSemantics<?, ?> semantics) {
            this.collectionJtd = collectionJtd;
            this.semantics = semantics;
        }

        public CollectionSemantics<?, ?> getCollectionSemantics() {
            return this.semantics;
        }

        @Override
        public JavaType<?> getMappedJavaType() {
            return this.collectionJtd;
        }
    }
}

