/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.metadata.tag;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagFilter;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class TagServiceImpl
implements TagService {
    private static final Log LOG = ExoLogger.getLogger(TagServiceImpl.class);
    private static final Pattern TAG_PATTERN = Pattern.compile("<a [^>]*class=[\"']metadata-tag[\"'][^>]*>#([^\\s\u00a0]+)<[^>]*/a>");
    private static final String TAG_ADDED_EVENT = "metadata.tag.added";
    private static final String TAGS_METADATA_TYPE = "tags";
    private static final int DEFAULT_LIMIT = 10000;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private MetadataService metadataService;
    private ListenerService listenerService;

    public TagServiceImpl(MetadataService metadataService, SpaceService spaceService, IdentityManager identityManager, ListenerService listenerService) {
        this.metadataService = metadataService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
    }

    public Set<TagName> detectTagNames(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptySet();
        }
        content = StringEscapeUtils.unescapeHtml4((String)content);
        HashSet<TagName> tags = new HashSet<TagName>();
        Matcher matcher = TAG_PATTERN.matcher(content);
        while (matcher.find()) {
            String tagName = matcher.group(1);
            if (!StringUtils.isNotBlank((CharSequence)tagName)) continue;
            tags.add(new TagName(tagName));
        }
        return tags;
    }

    public Set<TagName> getTagNames(TagObject object) {
        Set metadataNames = this.metadataService.getMetadataNamesByObject((MetadataObject)object);
        return metadataNames.stream().map(TagName::new).collect(Collectors.toSet());
    }

    public Set<TagName> saveTags(TagObject object, Set<TagName> tagNames, long audienceId, long creatorId) {
        if (object == null) {
            throw new IllegalArgumentException("Tag object is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)object.getId())) {
            throw new IllegalArgumentException("objectId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)object.getType())) {
            throw new IllegalArgumentException("objectType is mandatory");
        }
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(TAGS_METADATA_TYPE, (MetadataObject)object);
        Set storedTagNames = metadataItems.stream().map(MetadataItem::getMetadata).map(Metadata::getName).map(TagName::new).collect(Collectors.toSet());
        HashSet<TagName> tagsToCreate = new HashSet<TagName>(tagNames);
        tagsToCreate.removeAll(storedTagNames);
        this.createTags(object, tagsToCreate, audienceId, creatorId);
        HashSet<TagName> tagsToDelete = new HashSet<TagName>(storedTagNames);
        tagsToDelete.removeAll(tagNames);
        this.deleteTags(metadataItems, tagsToDelete);
        Set newTags = tagsToCreate.stream().filter(tagName -> !storedTagNames.contains(tagName)).collect(Collectors.toSet());
        try {
            this.listenerService.broadcast(TAG_ADDED_EVENT, (Object)object, newTags);
        }
        catch (Exception e) {
            LOG.error((Object)"could not broadcast event", (Throwable)e);
        }
        return this.getTagNames(object);
    }

    public List<TagName> findTags(TagFilter tagFilter, long userIdentityId) {
        Identity identity;
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory.");
        }
        if (tagFilter == null) {
            tagFilter = new TagFilter();
            tagFilter.setLimit(10000L);
        }
        if (tagFilter.getLimit() <= 0L) {
            tagFilter.setLimit(10000L);
        }
        if ((identity = this.identityManager.getIdentity(String.valueOf(userIdentityId))) == null) {
            throw new IllegalArgumentException("User with identity id " + userIdentityId + " wasn't found.");
        }
        Set<Long> audienceIds = this.getUserSpaceAudienceIds(identity.getRemoteId());
        long limit = tagFilter.getLimit();
        List metadataNames = this.metadataService.findMetadataNamesByUserAndQuery(tagFilter.getTerm(), TagService.METADATA_TYPE.getName(), audienceIds, userIdentityId, limit * 3L);
        return metadataNames.stream().map(TagName::new).distinct().limit(limit).collect(Collectors.toList());
    }

    private void deleteTags(List<MetadataItem> tagMetadataItems, Set<TagName> tagsToDelete) {
        List metadataItemsToDelete = tagMetadataItems.stream().filter(item -> tagsToDelete.contains(new TagName(item.getMetadata().getName()))).collect(Collectors.toList());
        for (MetadataItem metadataItem : metadataItemsToDelete) {
            try {
                this.metadataService.deleteMetadataItem(metadataItem.getId(), metadataItem.getCreatorId());
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Tag with name {} wasn't found as associated to object {}/{}. Ignore error since it will not affect result.", new Object[]{metadataItem.getMetadata().getName(), metadataItem.getObjectType(), metadataItem.getObjectId(), e});
            }
        }
    }

    private void createTags(TagObject taggedObject, Set<TagName> tagsToCreate, long audienceId, long creatorId) {
        for (TagName newTag : tagsToCreate) {
            try {
                MetadataKey metadataKey = new MetadataKey(TagService.METADATA_TYPE.getName(), newTag.getName(), audienceId);
                this.metadataService.createMetadataItem((MetadataObject)taggedObject, metadataKey, creatorId);
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.warn("Tag with name {} is already associated to object {}. Ignore error since it will not affect result.", new Object[]{newTag, taggedObject, e});
            }
        }
    }

    private Set<Long> getUserSpaceAudienceIds(String username) {
        HashSet<Long> audienceIds = new HashSet<Long>();
        ListAccess spacesListAccess = this.spaceService.getMemberSpaces(username);
        try {
            Object[] spaces = (Space[])spacesListAccess.load(0, 10000);
            if (ArrayUtils.isNotEmpty((Object[])spaces)) {
                for (Object space : spaces) {
                    Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
                    if (spaceIdentity == null) continue;
                    audienceIds.add(Long.parseLong(spaceIdentity.getId()));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving list of spaces of user " + username, e);
        }
        return audienceIds;
    }
}

