/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KudosSentNotificationListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(KudosSentNotificationListener.class);
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("exo.kudos.sent", (ListenerBase)this);
    }

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        try {
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            ctx.append(Utils.KUDOS_DETAILS_PARAMETER, (Object)kudos);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"KudosActivityReceiverNotificationPlugin"))).execute(ctx);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error sending notification for Kudos with id " + kudos.getTechnicalId()), (Throwable)e);
        }
    }
}

