/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.storage.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Date;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;

@Entity(name="DeletedFileEntity")
@ExoEntity
@Table(name="FILES_ORPHAN_FILES")
@NamedQueries(value={@NamedQuery(name="deletedEntity.findDeletedFiles", query="SELECT t FROM DeletedFileEntity t WHERE t.deletedDate < :deletedDate")})
public class OrphanFileEntity {
    @Id
    @Column(name="ID")
    @SequenceGenerator(name="SEQ_FILES_ORPHAN_FILES_ID", sequenceName="SEQ_FILES_ORPHAN_FILES_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_FILES_ORPHAN_FILES_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="FILE_ID")
    private FileInfoEntity fileInfoEntity;
    @Column(name="CHECKSUM")
    private String checksum;
    @Column(name="DELETED_DATE")
    private Date deletedDate;

    public OrphanFileEntity() {
    }

    public Date getDeletedDate() {
        return this.deletedDate;
    }

    public void setDeletedDate(Date deletedDate) {
        this.deletedDate = deletedDate;
    }

    public FileInfoEntity getFileInfoEntity() {
        return this.fileInfoEntity;
    }

    public void setFileInfoEntity(FileInfoEntity fileInfoEntity) {
        this.fileInfoEntity = fileInfoEntity;
    }

    public OrphanFileEntity(long id, String checksum, Date deletedDate) {
        this.id = id;
        this.checksum = checksum;
        this.deletedDate = deletedDate;
    }

    public OrphanFileEntity(long id, long fileId, String checksum, Date deletedDate) {
        this(fileId, checksum, deletedDate);
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }
}

