/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeState;

public abstract class NodeChange<N> {
    final N target;

    private NodeChange(N target) {
        if (target == null) {
            throw new NullPointerException("No null target accepted");
        }
        this.target = target;
    }

    public final N getTarget() {
        return this.target;
    }

    protected abstract void dispatch(NodeChangeListener<N> var1);

    public static final class Updated<N>
    extends NodeChange<N> {
        final NodeState state;

        public Updated(N node, NodeState state) {
            super(node);
            this.state = state;
        }

        public NodeState getState() {
            return this.state;
        }

        @Override
        protected void dispatch(NodeChangeListener<N> listener) {
            listener.onUpdate(this.target, this.state);
        }

        public String toString() {
            return "NodeChange.Updated[target" + String.valueOf(this.target) + ",state=" + String.valueOf(this.state) + "]";
        }
    }

    public static final class Renamed<N>
    extends NodeChange<N> {
        final N parent;
        final String name;

        Renamed(N parent, N node, String name) {
            super(node);
            if (parent == null) {
                throw new NullPointerException("No null parent accepted");
            }
            if (name == null) {
                throw new NullPointerException("No null name accepted");
            }
            this.parent = parent;
            this.name = name;
        }

        public N getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        @Override
        protected void dispatch(NodeChangeListener<N> listener) {
            listener.onRename(this.target, this.parent, this.name);
        }

        public String toString() {
            return "NodeChange.Renamed[target" + String.valueOf(this.target) + ",name=" + this.name + "]";
        }
    }

    public static final class Moved<N>
    extends NodeChange<N> {
        final N from;
        final N to;
        final N previous;

        Moved(N from, N to, N previous, N node) {
            super(node);
            if (from == null) {
                throw new NullPointerException("No null from accepted");
            }
            if (to == null) {
                throw new NullPointerException("No null to accepted");
            }
            this.from = from;
            this.to = to;
            this.previous = previous;
        }

        public N getFrom() {
            return this.from;
        }

        public N getTo() {
            return this.to;
        }

        public N getPrevious() {
            return this.previous != null ? (N)this.previous : null;
        }

        @Override
        protected void dispatch(NodeChangeListener<N> listener) {
            listener.onMove(this.target, this.from, this.to, this.previous);
        }

        public String toString() {
            return "NodeChange.Moved[target" + String.valueOf(this.target) + ",from=" + String.valueOf(this.from) + ",to=" + String.valueOf(this.to) + ",previous=" + String.valueOf(this.previous) + "]";
        }
    }

    public static final class Added<N>
    extends NodeChange<N> {
        final N parent;
        final N previous;

        Added(N parent, N previous, N node) {
            super(node);
            if (parent == null) {
                throw new NullPointerException("No null parent accepted");
            }
            this.parent = parent;
            this.previous = previous;
        }

        public N getParent() {
            return this.parent;
        }

        public N getPrevious() {
            return this.previous != null ? (N)this.previous : null;
        }

        @Override
        protected void dispatch(NodeChangeListener<N> listener) {
            listener.onAdd(this.target, this.parent, this.previous);
        }

        public String toString() {
            return "NodeChange.Added[target" + String.valueOf(this.target) + ",previous" + String.valueOf(this.previous) + ",parent=" + String.valueOf(this.parent) + "]";
        }
    }

    public static final class Created<N>
    extends NodeChange<N> {
        final N parent;
        final N previous;
        final String name;

        Created(N parent, N previous, N node, String name) throws NullPointerException {
            super(node);
            if (parent == null) {
                throw new NullPointerException("No null parent accepted");
            }
            if (name == null) {
                throw new NullPointerException("No null name accepted");
            }
            this.parent = parent;
            this.previous = previous;
            this.name = name;
        }

        public N getParent() {
            return this.parent;
        }

        public N getPrevious() {
            return this.previous;
        }

        public String getName() {
            return this.name;
        }

        @Override
        protected void dispatch(NodeChangeListener<N> listener) {
            listener.onCreate(this.target, this.parent, this.previous, this.name);
        }

        public String toString() {
            return "NodeChange.Created[target" + String.valueOf(this.target) + ",previous" + String.valueOf(this.previous) + ",parent=" + String.valueOf(this.parent) + ",name=" + this.name + "]";
        }
    }

    public static final class Removed<N>
    extends NodeChange<N> {
        final N parent;

        Removed(N parent, N node) {
            super(node);
            if (parent == null) {
                throw new NullPointerException("No null parent accepted");
            }
            this.parent = parent;
        }

        public N getParent() {
            return this.parent;
        }

        @Override
        protected void dispatch(NodeChangeListener<N> listener) {
            listener.onRemove(this.target, this.parent);
        }

        public String toString() {
            return "NodeChange.Removed[target" + String.valueOf(this.target) + ",parent=" + String.valueOf(this.parent) + "]";
        }
    }

    public static final class Destroyed<N>
    extends NodeChange<N> {
        final N parent;

        Destroyed(N parent, N node) {
            super(node);
            if (parent == null) {
                throw new NullPointerException("No null parent accepted");
            }
            this.parent = parent;
        }

        public N getParent() {
            return this.parent;
        }

        @Override
        protected void dispatch(NodeChangeListener<N> listener) {
            listener.onDestroy(this.target, this.parent);
        }

        public String toString() {
            return "NodeChange.Destroyed[target" + String.valueOf(this.target) + ",parent=" + String.valueOf(this.parent) + "]";
        }
    }
}

