/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ClassLoading {
    private static final Log LOG = ExoLogger.getLogger("org.exoplatform.commons.utils.ClassLoader");

    public static Class<?> forName(String type, Object callerObject) throws ClassNotFoundException {
        return ClassLoading.forName(type, callerObject.getClass());
    }

    public static Class<?> forName(String type, Class<?> callerClass) throws ClassNotFoundException {
        try {
            return Class.forName(type, true, callerClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl;
            block12: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("The class " + type + " could not be found in the Class loader of " + String.valueOf(callerClass));
                }
                cl = Thread.currentThread().getContextClassLoader();
                try {
                    if (cl != null) {
                        return Class.forName(type, true, cl);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No thread context Class loader could be found to load the class " + type);
                    }
                }
                catch (ClassNotFoundException e1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("The class " + type + " could not be found in the thread context Class loader");
                    }
                    cl = null;
                }
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Exception e1) {
                    if (!LOG.isTraceEnabled()) break block12;
                    LOG.trace((Object)("The system Class loader could not be found to load the class " + type), e1);
                }
            }
            if (cl != null) {
                return Class.forName(type, true, cl);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("The system Class loader could not be found to load the class " + type);
            }
            throw e;
        }
    }

    public static Class<?> loadClass(String type, Object callerObject) throws ClassNotFoundException {
        return ClassLoading.loadClass(type, callerObject.getClass());
    }

    public static Class<?> loadClass(String type, Class<?> callerClass) throws ClassNotFoundException {
        ClassLoader localCl = callerClass.getClassLoader();
        try {
            return localCl.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl;
            block12: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("The class " + type + " could not be found in the Class loader of " + String.valueOf(callerClass));
                }
                cl = Thread.currentThread().getContextClassLoader();
                try {
                    if (cl != null) {
                        return cl.loadClass(type);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No thread context Class loader could be found to load the class " + type);
                    }
                }
                catch (ClassNotFoundException e1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("The class " + type + " could not be found in the thread context Class loader");
                    }
                    cl = null;
                }
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Exception e1) {
                    if (!LOG.isTraceEnabled()) break block12;
                    LOG.trace((Object)("The system Class loader could not be found to load the class " + type), e1);
                }
            }
            if (cl != null) {
                return cl.loadClass(type);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("The system Class loader could not be found to load the class " + type);
            }
            throw e;
        }
    }
}

