/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.codec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.AbstractCodecBuilder;
import org.exoplatform.web.security.codec.CodecKeyChangedException;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.picocontainer.Startable;

public class CodecInitializer
implements Startable {
    public static final String CODECKEY_RELATIVE_PATH_PARAM = "codeckey.relative.path";
    public static final String CONF_DIR_PARAM = "gatein.conf.dir";
    private static final Log LOG = ExoLogger.getLogger(CodecInitializer.class);
    private static final Context CONTEXT = Context.GLOBAL;
    private static final Scope SCOPE = Scope.GLOBAL.id("CodecInitializer");
    private static final String INIT_KEY = "CodecKeyInitialized";
    private String confDir;
    private String codecFileRelativePath;
    private SettingService settingService;
    private AbstractCodec codec;

    public CodecInitializer(SettingService settingService, InitParams initParams) {
        this(initParams);
        this.settingService = settingService;
    }

    public CodecInitializer(InitParams initParams) {
        this.confDir = this.getParamValue(initParams, CONF_DIR_PARAM, null);
        this.codecFileRelativePath = this.getParamValue(initParams, CODECKEY_RELATIVE_PATH_PARAM, "/codec/codeckey.txt");
    }

    public void start() {
        if (this.settingService == null) {
            return;
        }
        try {
            String encodedInitKey = this.getCodec().encode(INIT_KEY);
            SettingValue settingValue = this.settingService.get(CONTEXT, SCOPE, INIT_KEY);
            if (settingValue == null || settingValue.getValue() == null) {
                this.settingService.set(CONTEXT, SCOPE, INIT_KEY, SettingValue.create((String)encodedInitKey));
            } else {
                String savedEncodedInitKey = settingValue.getValue().toString();
                if (!StringUtils.equals((CharSequence)savedEncodedInitKey, (CharSequence)encodedInitKey)) {
                    throw new CodecKeyChangedException("Symetric-Key " + this.codecFileRelativePath + " used to encrypt/decrypt sensitive data seems to be changed. This may lead to data inconsistency.");
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while checking init key content", e);
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCodec getCodec() throws TokenServiceInitializationException {
        AbstractCodec helper = this.codec;
        if (helper == null) {
            CodecInitializer codecInitializer = this;
            synchronized (codecInitializer) {
                helper = this.codec;
                if (helper == null) {
                    this.codec = helper = this.initCodec();
                }
            }
        }
        return helper;
    }

    protected AbstractCodec initCodec() throws TokenServiceInitializationException {
        HashMap<String, String> config;
        String builderType;
        block26: {
            builderType = PropertyManager.getProperty((String)"gatein.codec.builderclass");
            config = new HashMap<String, String>();
            if (builderType != null) {
                String configFile = PropertyManager.getProperty((String)"gatein.codec.config");
                File f = new File(configFile);
                try (FileInputStream in = new FileInputStream(f);){
                    Properties properties = new Properties();
                    properties.load(in);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        config.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
                    break block26;
                }
                catch (IOException e) {
                    throw new TokenServiceInitializationException("Failed to read the config parameters from file '" + configFile + "'.", e);
                }
            }
            builderType = "org.exoplatform.web.security.codec.JCASymmetricCodecBuilder";
            String gtnConfDir = null;
            if (this.confDir != null) {
                ConfigurationManager confManager = (ConfigurationManager)RootContainer.getInstance().getComponentInstanceOfType(ConfigurationManager.class);
                try {
                    gtnConfDir = confManager.getResource(this.confDir).getPath();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Failed to process the path to gateinConfDir", (Throwable)ex);
                }
            }
            if (gtnConfDir == null && ((gtnConfDir = PropertyManager.getProperty((String)CONF_DIR_PARAM)) == null || gtnConfDir.length() == 0)) {
                throw new TokenServiceInitializationException("'gatein.conf.dir' property must be set.");
            }
            try {
                gtnConfDir = URLDecoder.decode(gtnConfDir, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("fail to decode the path " + gtnConfDir), (Throwable)e);
            }
            File f = new File(gtnConfDir + this.codecFileRelativePath);
            if (!f.exists()) {
                File codecDir = f.getParentFile();
                if (!codecDir.exists()) {
                    codecDir.mkdir();
                }
                try (FileOutputStream out = new FileOutputStream(f);){
                    KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                    keyGen.init(128);
                    SecretKey key = keyGen.generateKey();
                    KeyStore store = KeyStore.getInstance("JCEKS");
                    store.load(null, "gtnStorePass".toCharArray());
                    store.setEntry("gtnKey", new KeyStore.SecretKeyEntry(key), new KeyStore.PasswordProtection("gtnKeyPass".toCharArray()));
                    store.store(out, "gtnStorePass".toCharArray());
                }
                catch (Exception e) {
                    throw new TokenServiceInitializationException(e);
                }
            }
            config.put("gatein.codec.jca.symmetric.keyalg", "AES");
            config.put("gatein.codec.jca.symmetric.keystore", f.getName());
            config.put("gatein.codec.jca.symmetric.storetype", "JCEKS");
            config.put("gatein.codec.jca.symmetric.alias", "gtnKey");
            config.put("gatein.codec.jca.symmetric.keypass", "gtnKeyPass");
            config.put("gatein.codec.jca.symmetric.storepass", "gtnStorePass");
            config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
        }
        try {
            LOG.info((Object)("Initialized codec using builder " + builderType));
            return Class.forName(builderType).asSubclass(AbstractCodecBuilder.class).newInstance().build(config);
        }
        catch (Exception e) {
            throw new TokenServiceInitializationException("Could not initialize codec.", e);
        }
    }

    private String getParamValue(InitParams initParams, String param, String defaultValue) {
        ValueParam valueParam = initParams.getValueParam(param);
        String value = valueParam != null ? valueParam.getValue() : null;
        return StringUtils.isNotBlank((CharSequence)value) ? value : defaultValue;
    }

    public String getConfDir() {
        return this.confDir;
    }

    public String getCodecFileRelativePath() {
        return this.codecFileRelativePath;
    }
}

