/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.upgrade;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.upgrade.LayoutUpgradePlugin$AjcClosure1;
import io.meeds.social.upgrade.LayoutUpgradePlugin$AjcClosure3;
import io.meeds.social.upgrade.LayoutUpgradePlugin$AjcClosure5;
import io.meeds.social.upgrade.model.LayoutUpgrade;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.importer.NavigationImporter;
import org.exoplatform.portal.mop.importer.PageImporter;
import org.exoplatform.portal.mop.importer.PortalConfigImporter;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LayoutUpgradePlugin
extends UpgradeProductPlugin {
    private static final String ENABLED_PARAM = "enabled";
    private static final Log LOG;
    private LayoutService layoutService;
    private UserPortalConfigService portalConfigService;
    private NavigationService navigationService;
    private DescriptionStorage descriptionStorage;
    private List<LayoutUpgrade> upgrades;
    private boolean enabled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public LayoutUpgradePlugin(LayoutService layoutService, SettingService settingService, UserPortalConfigService portalConfigService, NavigationService navigationService, DescriptionStorage descriptionStorage, InitParams initParams) {
        super(settingService, initParams);
        this.layoutService = layoutService;
        this.portalConfigService = portalConfigService;
        this.navigationService = navigationService;
        this.descriptionStorage = descriptionStorage;
        this.upgrades = initParams.getObjectParamValues(LayoutUpgrade.class);
        this.enabled = !initParams.containsKey((Object)ENABLED_PARAM) || Boolean.parseBoolean(initParams.getValueParam(ENABLED_PARAM).getValue());
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long start = System.currentTimeMillis();
        LOG.info("Start:: Upgrade Portal Layout {}", new Object[]{this.getName()});
        this.upgrades.forEach(this::updateLayout);
        LOG.info("End:: Upgrade Portal Layout {} in {} ms", new Object[]{this.getName(), System.currentTimeMillis() - start});
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return this.enabled && CollectionUtils.isNotEmpty(this.upgrades);
    }

    @ExoTransactional
    public boolean updateLayout(LayoutUpgrade upgrade) {
        LayoutUpgrade layoutUpgrade = upgrade;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)layoutUpgrade);
        Object[] objectArray = new Object[]{this, layoutUpgrade, joinPoint};
        LayoutUpgradePlugin$AjcClosure1 layoutUpgradePlugin$AjcClosure1 = new LayoutUpgradePlugin$AjcClosure1(objectArray);
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(layoutUpgradePlugin$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    private boolean upgradePortalLayout(LayoutUpgrade upgrade, String portalType, String portalName) {
        String location = upgrade.getConfigPath();
        PortalConfig newPortalConfig = (PortalConfig)this.portalConfigService.getConfig(portalType, portalName, PortalConfig.class, location);
        if (newPortalConfig == null) {
            LOG.info("IGNORE:: Portal layout {}/{} wasn't found in path {}. The layout upgrade will be ignored", new Object[]{portalType, portalName, location});
            return false;
        }
        LOG.info("Process:: Upgrade Portal Layout {}/{}", new Object[]{portalType, portalName});
        PortalConfigImporter portalImporter = new PortalConfigImporter(this.getImportMode(upgrade), newPortalConfig, this.layoutService);
        try {
            portalImporter.perform();
            return true;
        }
        catch (Exception e) {
            LOG.warn("ERROR:: Upgrade Portal Layout {}/{} error. The layout upgrade will be ignored", new Object[]{portalType, portalName, e});
            return false;
        }
    }

    private boolean upgradePagesLayout(LayoutUpgrade upgrade, String portalType, String portalName) {
        String location = upgrade.getConfigPath();
        Page.PageSet pageSet = (Page.PageSet)this.portalConfigService.getConfig(portalType, portalName, Page.PageSet.class, location);
        if (pageSet == null || CollectionUtils.isEmpty((Collection)pageSet.getPages())) {
            LOG.info("IGNORE:: Pages layout of portal {}/{} wasn't found in path {}. The layout upgrade will be ignored", new Object[]{this.getName(), portalType, portalName, location});
            return false;
        }
        List<String> pageNames = upgrade.getPageNames();
        if (CollectionUtils.isEmpty(pageNames)) {
            LOG.info("IGNORE:: Configured pages for portal {}/{} was empty. The layout upgrade will be ignored", new Object[]{portalType, portalName, location});
            return false;
        }
        List<Page> pages = pageSet.getPages().stream().filter(page -> pageNames.contains(page.getName())).toList();
        if (pages.isEmpty()) {
            LOG.info("IGNORE:: Pages layout of portal {}/{} wasn't found from list {}. The layout upgrade will be ignored", new Object[]{this.getName(), portalType, portalName, StringUtils.join(pageNames, (String)",")});
            return false;
        }
        LOG.info("Process:: Upgrade pages ({}) layout from portal {}/{}", new Object[]{StringUtils.join(pageNames, (String)","), portalType, portalName});
        PageImporter pageImporter = new PageImporter(this.getImportMode(upgrade), new SiteKey(portalType, portalName), pages, this.layoutService);
        try {
            pageImporter.perform();
            return true;
        }
        catch (Exception e) {
            LOG.warn("ERROR:: Upgrade of pages ({}) layout from portal {}/{} was interrupted. The layout upgrade will be ignored", new Object[]{StringUtils.join(pageNames, (String)","), portalType, portalName, e});
            return false;
        }
    }

    private boolean upgradePortalNavigation(LayoutUpgrade upgrade, String portalType, String portalName, PortalConfig portalConfig) {
        LOG.info("Process:: Upgrade Portal navigation {}/{}", new Object[]{portalType, portalName});
        try {
            if (!CollectionUtils.isEmpty(upgrade.getDeleteNavigations())) {
                upgrade.getDeleteNavigations().forEach(nodeUri -> {
                    SiteKey siteKey = new SiteKey(SiteType.valueOf((String)portalType.toUpperCase()), portalName);
                    NodeContext node = this.navigationService.loadNode(siteKey, nodeUri);
                    if (node == null) {
                        LOG.warn("Node with uri '{}' in site '{}' wasn't found", new Object[]{nodeUri, siteKey});
                    } else {
                        LOG.info("Deleting Node with uri '{}' from site '{}'", new Object[]{nodeUri, siteKey});
                        this.deleteNavigationNode(Long.parseLong(node.getId()));
                    }
                });
            } else if (!CollectionUtils.isEmpty(upgrade.getHideNavigations())) {
                upgrade.getHideNavigations().forEach(nodeUri -> {
                    SiteKey siteKey = new SiteKey(SiteType.valueOf((String)portalType.toUpperCase()), portalName);
                    NodeContext node = this.navigationService.loadNode(siteKey, nodeUri);
                    if (node == null) {
                        LOG.warn("Node with uri '{}' in site '{}' wasn't found", new Object[]{nodeUri, siteKey});
                    } else {
                        LOG.info("Hiding Node with uri '{}' from site '{}'", new Object[]{nodeUri, siteKey});
                        this.hideNavigationNode((NodeContext<NodeContext<Object>>)node);
                    }
                });
            } else {
                String location = upgrade.getConfigPath();
                PageNavigation pageNavigation = (PageNavigation)this.portalConfigService.getConfig(portalType, portalName, PageNavigation.class, location);
                if (pageNavigation == null) {
                    LOG.info("IGNORE:: Portal navigation {}/{} wasn't found in path {}. The layout upgrade will be ignored", new Object[]{portalType, portalName, location});
                    return false;
                }
                Locale locale = portalConfig.getLocale() != null ? Locale.forLanguageTag(portalConfig.getLocale()) : Locale.ENGLISH;
                NavigationImporter navigationImporter = new NavigationImporter(locale, this.getImportMode(upgrade), pageNavigation, this.navigationService, this.descriptionStorage);
                navigationImporter.perform();
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn("ERROR:: Upgrade Portal navigation {}/{} error. The layout upgrade will be ignored", new Object[]{portalType, portalName, e});
            return false;
        }
    }

    @ContainerTransactional
    protected void hideNavigationNode(NodeContext<NodeContext<Object>> node) {
        NodeContext<NodeContext<Object>> nodeContext = node;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), nodeContext);
        Object[] objectArray = new Object[]{this, nodeContext, joinPoint};
        LayoutUpgradePlugin$AjcClosure3 layoutUpgradePlugin$AjcClosure3 = new LayoutUpgradePlugin$AjcClosure3(objectArray);
        ContainerTransactionalAspect.aspectOf().around(layoutUpgradePlugin$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ContainerTransactional
    protected void deleteNavigationNode(long nodeId) {
        long l = nodeId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        LayoutUpgradePlugin$AjcClosure5 layoutUpgradePlugin$AjcClosure5 = new LayoutUpgradePlugin$AjcClosure5(objectArray);
        ContainerTransactionalAspect.aspectOf().around(layoutUpgradePlugin$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    private ImportMode getImportMode(LayoutUpgrade upgrade) {
        return upgrade.getImportMode() == null ? ImportMode.MERGE : ImportMode.valueOf((String)upgrade.getImportMode().toUpperCase());
    }

    static {
        LayoutUpgradePlugin.ajc$preClinit();
        LOG = ExoLogger.getLogger(LayoutUpgradePlugin.class);
    }

    static /* synthetic */ boolean updateLayout_aroundBody0(LayoutUpgradePlugin ajc$this, LayoutUpgrade upgrade, JoinPoint joinPoint) {
        String portalType = upgrade.getPortalType();
        String portalName = upgrade.getPortalName();
        if (StringUtils.isBlank((CharSequence)portalType)) {
            LOG.info("IGNORE:: Upgrade Plugin '{}' has an empty portal type. The layout upgrade will be ignored", new Object[]{ajc$this.getName()});
        } else if (StringUtils.isBlank((CharSequence)portalName)) {
            LOG.info("IGNORE:: Upgrade Plugin '{}' has an empty portal name. The layout upgrade will be ignored", new Object[]{ajc$this.getName()});
        } else {
            PortalConfig portalConfig = ajc$this.layoutService.getPortalConfig(portalType, portalName);
            if (portalConfig == null) {
                LOG.info("IGNORE:: Portal {}/{} doesn't exist. The layout upgrade will be ignored", new Object[]{ajc$this.getName(), portalType, portalName});
            } else {
                boolean fullyUpgraded = true;
                if (upgrade.isUpdatePortalConfig()) {
                    boolean bl = fullyUpgraded = ajc$this.upgradePortalLayout(upgrade, portalType, portalName) && fullyUpgraded;
                }
                if (upgrade.isUpdatePageLayout()) {
                    boolean bl = fullyUpgraded = ajc$this.upgradePagesLayout(upgrade, portalType, portalName) && fullyUpgraded;
                    if (!fullyUpgraded) {
                        return false;
                    }
                }
                if (upgrade.isUpdateNavigation()) {
                    fullyUpgraded = ajc$this.upgradePortalNavigation(upgrade, portalType, portalName, portalConfig) && fullyUpgraded;
                }
                return fullyUpgraded;
            }
        }
        return false;
    }

    static /* synthetic */ void hideNavigationNode_aroundBody2(LayoutUpgradePlugin ajc$this, NodeContext node, JoinPoint joinPoint) {
        ajc$this.navigationService.updateNode(Long.valueOf(Long.parseLong(node.getId())), new NodeState.Builder(node.getState()).visibility(Visibility.HIDDEN).build());
    }

    static /* synthetic */ void deleteNavigationNode_aroundBody4(LayoutUpgradePlugin ajc$this, long nodeId, JoinPoint joinPoint) {
        ajc$this.navigationService.deleteNode(Long.valueOf(nodeId));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LayoutUpgradePlugin.java", LayoutUpgradePlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLayout", "io.meeds.social.upgrade.LayoutUpgradePlugin", "io.meeds.social.upgrade.model.LayoutUpgrade", "upgrade", "", "boolean"), 103);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "hideNavigationNode", "io.meeds.social.upgrade.LayoutUpgradePlugin", "org.exoplatform.portal.mop.navigation.NodeContext", "node", "", "void"), 264);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteNavigationNode", "io.meeds.social.upgrade.LayoutUpgradePlugin", "long", "nodeId", "", "void"), 270);
    }
}

