/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.job;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.service.BlockchainTransactionService;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class PendingEtherTransactionVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(PendingEtherTransactionVerifierJob.class);
    protected ExoContainer container = PortalContainer.getInstance();
    protected BlockchainTransactionService blockchainTransactionService = (BlockchainTransactionService)this.container.getComponentInstanceOfType(BlockchainTransactionService.class);
    protected WalletTransactionService walletTransactionService = (WalletTransactionService)this.container.getComponentInstanceOfType(WalletTransactionService.class);
    protected WalletAccountService walletAccountService = (WalletAccountService)this.container.getComponentInstanceOfType(WalletAccountService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            List transactionDetails;
            Wallet adminWallet = this.walletAccountService.getAdminWallet();
            if (adminWallet != null && CollectionUtils.isNotEmpty((Collection)(transactionDetails = this.walletTransactionService.getPendingEtherTransactions(adminWallet.getAddress())))) {
                LOG.info("Start refreshing Admin wallet ether {} transactions", new Object[]{transactionDetails.size()});
                transactionDetails.forEach(transactionDetail -> {
                    try {
                        this.blockchainTransactionService.addTransactionToRefreshFromBlockchain(transactionDetail);
                    }
                    catch (Exception e) {
                        LOG.warn("Error refreshing Ether Transaction {}", new Object[]{transactionDetail.getHash(), e});
                    }
                });
                LOG.info("End refreshing Admin wallet ether {} transactions", new Object[]{transactionDetails.size()});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

