/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.model;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class StatisticFieldMapping {
    private static final List<String> NUMERIC_TYPES = Arrays.asList("long", "double", "float", "short", "int");
    private String name;
    private String type;
    private boolean hasKeywordSubField;
    private boolean scriptedField;

    public StatisticFieldMapping(String name, String type, boolean hasKeywordSubField) {
        this.name = name;
        this.type = type;
        this.hasKeywordSubField = hasKeywordSubField;
    }

    public static final String computeESQueryValue(String value) {
        if (NumberUtils.isDigits((String)value)) {
            return value;
        }
        return "\"" + value + "\"";
    }

    public boolean isNumeric() {
        return NUMERIC_TYPES.contains(this.type);
    }

    public boolean isKeyword() {
        return StringUtils.equals((CharSequence)this.type, (CharSequence)"keyword") || this.hasKeywordSubField && StringUtils.equals((CharSequence)this.type, (CharSequence)"text");
    }

    public boolean isDate() {
        return StringUtils.equals((CharSequence)this.type, (CharSequence)"date");
    }

    public boolean isText() {
        return StringUtils.equals((CharSequence)this.type, (CharSequence)"text");
    }

    public boolean isAggregation() {
        return this.isNumeric() || this.isDate() || this.isKeyword();
    }

    public String getSearchFieldName() {
        return this.name;
    }

    public String getAggregationFieldName() {
        if (this.isAggregation() && this.hasKeywordSubField && StringUtils.equals((CharSequence)this.type, (CharSequence)"text")) {
            return this.name + ".keyword";
        }
        return this.name;
    }

    public String getESQueryValue(String value) {
        if (this.isNumeric()) {
            return value;
        }
        return "\"" + value + "\"";
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isHasKeywordSubField() {
        return this.hasKeywordSubField;
    }

    public boolean isScriptedField() {
        return this.scriptedField;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHasKeywordSubField(boolean hasKeywordSubField) {
        this.hasKeywordSubField = hasKeywordSubField;
    }

    public void setScriptedField(boolean scriptedField) {
        this.scriptedField = scriptedField;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticFieldMapping)) {
            return false;
        }
        StatisticFieldMapping other = (StatisticFieldMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticFieldMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "StatisticFieldMapping(name=" + this.getName() + ", type=" + this.getType() + ", hasKeywordSubField=" + this.isHasKeywordSubField() + ", scriptedField=" + this.isScriptedField() + ")";
    }

    public StatisticFieldMapping(String name, String type, boolean hasKeywordSubField, boolean scriptedField) {
        this.name = name;
        this.type = type;
        this.hasKeywordSubField = hasKeywordSubField;
        this.scriptedField = scriptedField;
    }

    public StatisticFieldMapping() {
    }
}

