/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.commons.utils.PortalPrinter;
import org.exoplatform.commons.xml.DOMSerializer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalURLBuilder;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.DynamicPortalLayoutService;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.web.security.sso.SSOHelper;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactory;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.common.http.QueryStringParser;
import org.gatein.common.util.ParameterMap;
import org.w3c.dom.Element;

public class PortalRequestContext
extends WebuiRequestContext {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalRequestContext");
    public static final int PUBLIC_ACCESS = 0;
    public static final int PRIVATE_ACCESS = 1;
    public static final String UI_COMPONENT_ACTION = "portal:action";
    public static final String UI_COMPONENT_ID = "portal:componentId";
    public static final String TARGET_NODE = "portal:targetNode";
    public static final String CACHE_LEVEL = "portal:cacheLevel";
    public static final String REQUEST_TITLE = "portal:requestTitle".intern();
    public static final String REQUEST_METADATA = "portal:requestMetadata".intern();
    private static final String DO_LOGIN_PATTERN = "login";
    private final String nodePath_;
    private final String requestURI_;
    private final String portalURI;
    private final String contextPath;
    private final SiteKey siteKey;
    private final Locale requestLocale;
    private HttpServletRequest request_;
    private final HttpServletResponse response_;
    private String cacheLevel_ = "cacheLevelPortlet";
    private boolean ajaxRequest_ = true;
    private boolean showMaxWindow;
    private boolean hideSharedLayout;
    private Boolean draftPage;
    private Boolean noCache;
    private boolean forceFullUpdate = false;
    private Writer writer_;
    protected JavascriptManager jsmanager_;
    private List<Element> extraMarkupHeaders;
    private final PortalURLBuilder urlBuilder;
    private Map<String, String[]> parameterMap;
    private Locale locale = Locale.ENGLISH;
    private List<Runnable> endRequestRunnables;
    private final URLFactoryService urlFactory = (URLFactoryService)PortalContainer.getComponent(URLFactoryService.class);
    private final ControllerContext controllerContext;
    private final DynamicPortalLayoutService portalLayoutService;
    private final UserPortalConfigService portalConfigService;
    private final LayoutService layoutService;
    private UserPortalConfig userPortalConfig;
    private PortalConfig currentPortalConfig;
    private UIPortal uiPortal;
    private UIPage uiPage;
    private List<UIPortlet> uiPortlets;
    private Page page;
    private UserNode userNode;
    private String skin;
    private String pageTitle = null;

    public PortalRequestContext(WebuiApplication app, ControllerContext controllerContext, String requestSiteType, String requestSiteName, String requestPath, Locale requestLocale) {
        super(app);
        this.controllerContext = controllerContext;
        this.jsmanager_ = new JavascriptManager();
        this.portalLayoutService = (DynamicPortalLayoutService)ExoContainerContext.getService(DynamicPortalLayoutService.class);
        this.layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
        this.portalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        this.request_ = controllerContext.getRequest();
        this.response_ = controllerContext.getResponse();
        this.response_.setBufferSize(102400);
        this.contextPath = this.request_.getContextPath();
        this.setSessionId(this.request_.getSession().getId());
        this.response_.setContentType("text/html");
        try {
            this.request_.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Encoding not supported", (Throwable)e);
        }
        this.parameterMap = new HashMap<String, String[]>();
        this.parameterMap.putAll(this.request_.getParameterMap());
        String queryString = this.request_.getQueryString();
        if (queryString != null) {
            queryString = queryString.replace("&amp;", "&");
            ParameterMap queryParams = QueryStringParser.getInstance().parseQueryString(queryString);
            this.parameterMap.putAll((Map<String, String[]>)queryParams);
        }
        this.ajaxRequest_ = "true".equals(this.request_.getParameter("ajaxRequest"));
        this.setShowMaxWindow("true".equals(this.request_.getParameter("showMaxWindow")));
        this.setHideSharedLayout("true".equals(this.request_.getParameter("hideSharedLayout")));
        String cache = this.request_.getParameter(CACHE_LEVEL);
        if (cache != null) {
            this.cacheLevel_ = cache;
        }
        this.requestURI_ = requestPath;
        this.siteKey = new SiteKey(SiteType.valueOf((String)requestSiteType.toUpperCase()), requestSiteName);
        this.nodePath_ = requestPath;
        this.requestLocale = requestLocale;
        NodeURL url = (NodeURL)this.createURL(NodeURL.TYPE);
        url.setResource(new NavigationResource(this.siteKey, requestPath));
        this.portalURI = url.toString();
        this.urlBuilder = new PortalURLBuilder(this, (ComponentURL)this.createURL(ComponentURL.TYPE));
    }

    public <R, U extends PortalURL<R, U>> U newURL(ResourceType<R, U> resourceType, URLFactory urlFactory) {
        PortalURLContext urlContext = new PortalURLContext(this.controllerContext, this.siteKey);
        PortalURL url = urlFactory.newURL(resourceType, (URLContext)urlContext);
        if (url != null) {
            url.setAjax(Boolean.valueOf(false));
            url.setLocale(this.requestLocale);
        }
        return (U)url;
    }

    @Override
    public JavascriptManager getJavascriptManager() {
        return this.jsmanager_;
    }

    public String getSkin() {
        if (this.skin == null) {
            String siteSkin = this.getUiPortal().getSkin();
            if (siteSkin == null) {
                return ((SkinService)ExoContainerContext.getService(SkinService.class)).getDefaultSkin();
            }
            return siteSkin;
        }
        return this.skin;
    }

    public UserPortal getUserPortal() {
        UserPortalConfig upc = this.getUserPortalConfig();
        if (upc != null) {
            return upc.getUserPortal();
        }
        return null;
    }

    public boolean isNoCache() {
        if (this.noCache == null) {
            this.noCache = StringUtils.equals((CharSequence)"true", (CharSequence)this.getRequest().getParameter("noCache"));
        }
        return this.noCache;
    }

    public boolean isDraftPage() {
        if (this.draftPage == null) {
            UserNode navigationNode = this.getNavigationNode();
            this.draftPage = navigationNode != null && navigationNode.getVisibility() == Visibility.DRAFT;
        }
        return this.draftPage;
    }

    public UserNode getNavigationNode() {
        if (this.userNode != null) {
            return this.userNode;
        }
        UserPortal userPortal = this.getUserPortalConfig().getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(this.siteKey);
        if (navigation != null) {
            UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder().withReadCheck();
            if (StringUtils.isBlank((CharSequence)this.nodePath_)) {
                this.userNode = this.portalConfigService.getPortalSiteRootNode(this.siteKey.getName(), this.siteKey.getTypeName(), this.request_);
                if (this.userNode != null) {
                    this.userNode = this.portalConfigService.getFirstAllowedPageNode(Collections.singletonList(this.userNode));
                }
            } else {
                this.userNode = userPortal.resolvePath(navigation, builder.build(), this.nodePath_);
            }
        }
        return this.userNode;
    }

    public UserPortalConfig getUserPortalConfig() {
        String remoteUser = null;
        if (this.userPortalConfig == null) {
            ConversationState conversationState = ConversationState.getCurrent();
            if (conversationState != null && conversationState.getIdentity() != null && !IdentityConstants.ANONIM.equals(conversationState.getIdentity().getUserId())) {
                remoteUser = conversationState.getIdentity().getUserId();
            }
            String portalName = this.getCurrentPortalSite();
            try {
                this.userPortalConfig = this.portalConfigService.getUserPortalConfig(portalName, remoteUser);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.userPortalConfig;
    }

    private String getCurrentPortalSite() {
        String portalName = null;
        if (SiteType.PORTAL == this.getSiteType()) {
            portalName = this.getSiteName();
        }
        if (portalName == null) {
            portalName = this.portalConfigService.getMetaPortal();
        }
        return portalName;
    }

    public void refreshPortalConfig() {
        this.userPortalConfig = null;
        this.currentPortalConfig = null;
    }

    public UIPage getUIPage(UserNode pageNode, UIPortal uiPortal) throws Exception {
        PageContext pageContext = null;
        String pageReference = null;
        if (pageNode != null && pageNode.getPageRef() != null) {
            pageReference = pageNode.getPageRef().format();
            pageContext = this.layoutService.getPageContext(pageNode.getPageRef());
        }
        if (pageContext == null) {
            uiPortal.clearUIPage(pageReference);
            return null;
        }
        this.setDraftPage(pageNode.getVisibility() == Visibility.DRAFT);
        this.page = this.layoutService.getPage(pageReference);
        if (uiPortal.getUIPage(pageReference) == null) {
            UIPageFactory clazz = UIPageFactory.getInstance(pageContext.getState().getFactoryId());
            this.uiPage = clazz.createUIPage(this);
            pageContext.update(this.page);
            PortalDataMapper.toUIPage(this.uiPage, this.page);
        }
        return this.uiPage;
    }

    public String getInitialURI() {
        return this.request_.getRequestURI();
    }

    public ControllerContext getControllerContext() {
        return this.controllerContext;
    }

    public void refreshResourceBundle() throws Exception {
        this.appRes_ = this.getApplication().getResourceBundle(this.getLocale());
    }

    public void requestAuthenticationLogin() throws Exception {
        this.requestAuthenticationLogin(null);
    }

    public void requestAuthenticationLogin(Map<String, String> params) throws Exception {
        StringBuilder initialURI = new StringBuilder();
        initialURI.append(this.request_.getRequestURI());
        if (this.request_.getQueryString() != null) {
            initialURI.append("?").append(this.request_.getQueryString());
        }
        StringBuilder loginPath = new StringBuilder();
        ExoContainer container = this.getApplication().getApplicationServiceContainer();
        SSOHelper ssoHelper = (SSOHelper)container.getComponentInstanceOfType(SSOHelper.class);
        if (ssoHelper != null && ssoHelper.isSSOEnabled() && ssoHelper.skipJSPRedirection()) {
            loginPath.append(this.getPortalContextPath()).append(ssoHelper.getSSORedirectURLSuffix());
        } else {
            loginPath.append(this.getPortalContextPath()).append("/").append(DO_LOGIN_PATTERN);
        }
        loginPath.append("?initialURI=").append(URLEncoder.encode(initialURI.toString(), "UTF-8"));
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                loginPath.append("&").append(URLEncoder.encode(param.getKey(), "UTF-8"));
                loginPath.append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
        }
        this.sendRedirect(loginPath.toString());
    }

    public void setPageTitle(String title) {
        this.pageTitle = title;
    }

    public PortalConfig getDynamicPortalConfig() throws Exception {
        if (this.currentPortalConfig == null) {
            SiteKey displayingSiteKey = this.getSiteKey();
            this.currentPortalConfig = this.portalLayoutService == null ? this.layoutService.getPortalConfig(displayingSiteKey.getTypeName(), displayingSiteKey.getName()) : this.portalLayoutService.getPortalConfigWithDynamicLayout(displayingSiteKey, this.getCurrentPortalSite());
        }
        return this.currentPortalConfig;
    }

    public void addOnRequestEnd(Runnable runnable) {
        if (this.endRequestRunnables == null) {
            this.endRequestRunnables = new ArrayList<Runnable>();
        }
        this.endRequestRunnables.add(runnable);
    }

    public void onRequestEnd() {
        if (this.endRequestRunnables != null) {
            this.endRequestRunnables.forEach(Runnable::run);
        }
    }

    public String getTitle() throws Exception {
        UIPortal uiportal;
        UserNode node;
        if (this.pageTitle != null) {
            return this.pageTitle;
        }
        String title = (String)this.getRequest().getAttribute(REQUEST_TITLE);
        if (title == null && (node = (uiportal = this.getUiPortal()).getSelectedUserNode()) != null) {
            String resolvedTitle;
            PageKey pageRef;
            ExoContainer container = this.getApplication().getApplicationServiceContainer();
            UserPortalConfigService configService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
            PageContext pageContext = configService.getPage(pageRef = node.getPageRef());
            if (pageContext != null && ExpressionUtil.isResourceBindingExpression((String)(title = pageContext.getState().getDisplayName())) && StringUtils.isNotBlank((CharSequence)(resolvedTitle = ExpressionUtil.getExpressionValue((ResourceBundle)this.getApplicationResourceBundle(), (String)title))) && !resolvedTitle.equals(title)) {
                return resolvedTitle;
            }
            title = node.getResolvedLabel();
        }
        return title == null ? "" : title;
    }

    public URLFactory getURLFactory() {
        return this.urlFactory;
    }

    public Orientation getOrientation() {
        return ((UIPortalApplication)this.uiApplication_).getOrientation();
    }

    public Locale getRequestLocale() {
        return this.requestLocale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getMetaInformation() {
        return (Map)this.request_.getAttribute(REQUEST_METADATA);
    }

    public String getCacheLevel() {
        return this.cacheLevel_;
    }

    public String getRequestParameter(String name) {
        if (this.parameterMap.get(name) != null && this.parameterMap.get(name).length > 0) {
            return this.parameterMap.get(name)[0];
        }
        return null;
    }

    public String[] getRequestParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getPortletParameters() {
        Map<String, String[]> unsortedParams = this.parameterMap;
        HashMap<String, String[]> sortedParams = new HashMap<String, String[]>();
        Set<String> keys = unsortedParams.keySet();
        for (String key : keys) {
            if (key.startsWith("portal:")) continue;
            sortedParams.put(key, unsortedParams.get(key));
        }
        return sortedParams;
    }

    @Override
    public final String getRequestContextPath() {
        return this.contextPath;
    }

    @Override
    public String getPortalContextPath() {
        return this.getRequestContextPath();
    }

    @Override
    public String getActionParameterName() {
        return UI_COMPONENT_ACTION;
    }

    @Override
    public String getUIComponentIdParameterName() {
        return UI_COMPONENT_ID;
    }

    public SiteType getSiteType() {
        return this.siteKey.getType();
    }

    public String getSiteName() {
        return this.siteKey.getName();
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public String getPortalOwner() {
        UserPortalConfig portalConfig = this.getUserPortalConfig();
        if (portalConfig != null && portalConfig.getPortalName() != null) {
            return portalConfig.getPortalName();
        }
        return this.portalConfigService.getMetaPortal();
    }

    public String getMetaPortal() {
        return this.portalConfigService.getMetaPortal();
    }

    public String getDefaultPortal() {
        return this.getMetaPortal();
    }

    public String getNodePath() {
        return this.nodePath_;
    }

    public String getRequestURI() {
        return this.requestURI_;
    }

    public String getPortalURI() {
        return this.portalURI;
    }

    @Override
    public URLBuilder<UIComponent> getURLBuilder() {
        return this.urlBuilder;
    }

    public int getAccessPath() {
        return this.request_.getRemoteUser() != null ? 1 : 0;
    }

    public final String getRemoteUser() {
        return this.request_.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request_.isUserInRole(roleUser);
    }

    public final Writer getWriter() throws IOException {
        if (this.writer_ == null) {
            this.writer_ = new PortalPrinter((OutputStream)this.response_.getOutputStream(), false, 30000);
        }
        return this.writer_;
    }

    public final void setWriter(Writer writer) {
        this.writer_ = writer;
    }

    public final boolean useAjax() {
        return this.ajaxRequest_;
    }

    public HttpServletRequest getRequest() {
        return this.request_;
    }

    public final HttpServletResponse getResponse() {
        return this.response_;
    }

    public final boolean getFullRender() {
        return this.forceFullUpdate;
    }

    @Deprecated
    public final void setFullRender(boolean forceFullUpdate) {
        this.forceFullUpdate = forceFullUpdate;
    }

    public final void ignoreAJAXUpdateOnPortlets(boolean ignoreAJAXUpdateOnPortlets) {
        this.forceFullUpdate = ignoreAJAXUpdateOnPortlets;
    }

    public final void sendError(int sc) throws IOException {
        this.setResponseComplete(true);
        this.response_.sendError(sc);
    }

    @Override
    public final void sendRedirect(String url) throws IOException {
        String globalSiteURI;
        this.setResponseComplete(true);
        if (url.contains(this.portalConfigService.getGlobalPortal()) && url.startsWith(globalSiteURI = "/" + PortalContainer.getCurrentPortalContainerName() + "/" + this.portalConfigService.getGlobalPortal())) {
            String metaSiteURI = "/" + PortalContainer.getCurrentPortalContainerName() + "/" + this.portalConfigService.getMetaPortal();
            url = url.replace(globalSiteURI, metaSiteURI);
            log.warn((Object)"An URI was sent with global site name, it will be replaced by default site to avoid returning HTTP 404");
        }
        this.response_.sendRedirect(url);
    }

    public void setHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        for (String key : keys) {
            this.response_.setHeader(key, headers.get(key));
        }
    }

    public List<String> getExtraMarkupHeadersAsStrings() throws Exception {
        ArrayList<String> markupHeaders = new ArrayList<String>();
        if (this.extraMarkupHeaders != null && !this.extraMarkupHeaders.isEmpty()) {
            for (Element element : this.extraMarkupHeaders) {
                StringWriter sw = new StringWriter();
                DOMSerializer.serialize((Element)element, (Writer)sw);
                markupHeaders.add(sw.toString());
            }
        }
        return markupHeaders;
    }

    public List<Element> getExtraMarkupHeaders() {
        return this.extraMarkupHeaders;
    }

    public void addExtraMarkupHeader(Element element, String portletWindowId) {
        element.setAttribute("class", "ExHead-" + portletWindowId);
        if (this.extraMarkupHeaders == null) {
            this.extraMarkupHeaders = new ArrayList<Element>();
        }
        this.extraMarkupHeaders.add(element);
    }

    public RequestNavigationData getNavigationData() {
        return new RequestNavigationData(this.controllerContext.getParameter(RequestNavigationData.REQUEST_SITE_TYPE), this.controllerContext.getParameter(RequestNavigationData.REQUEST_SITE_NAME), this.controllerContext.getParameter(RequestNavigationData.REQUEST_PATH));
    }

    public boolean isMaximizePortlet() {
        return StringUtils.isNotBlank((CharSequence)this.getMaximizedPortletId());
    }

    public String getMaximizedPortletId() {
        return this.getRequest().getParameter("maximizedPortletId");
    }

    public static PortalRequestContext getCurrentInstance() {
        RequestContext currentInstance = RequestContext.getCurrentInstance();
        if (currentInstance == null) {
            return null;
        }
        if (currentInstance instanceof PortalRequestContext) {
            PortalRequestContext portalRequestContext = (PortalRequestContext)currentInstance;
            return portalRequestContext;
        }
        return (PortalRequestContext)currentInstance.getParentAppRequestContext();
    }

    @Generated
    public boolean isShowMaxWindow() {
        return this.showMaxWindow;
    }

    @Generated
    public void setShowMaxWindow(boolean showMaxWindow) {
        this.showMaxWindow = showMaxWindow;
    }

    @Generated
    public boolean isHideSharedLayout() {
        return this.hideSharedLayout;
    }

    @Generated
    public void setHideSharedLayout(boolean hideSharedLayout) {
        this.hideSharedLayout = hideSharedLayout;
    }

    @Generated
    public void setDraftPage(Boolean draftPage) {
        this.draftPage = draftPage;
    }

    @Generated
    public void setNoCache(Boolean noCache) {
        this.noCache = noCache;
    }

    @Generated
    public UIPortal getUiPortal() {
        return this.uiPortal;
    }

    @Generated
    public void setUiPortal(UIPortal uiPortal) {
        this.uiPortal = uiPortal;
    }

    @Generated
    public UIPage getUiPage() {
        return this.uiPage;
    }

    @Generated
    public void setUiPage(UIPage uiPage) {
        this.uiPage = uiPage;
    }

    @Generated
    public List<UIPortlet> getUiPortlets() {
        return this.uiPortlets;
    }

    @Generated
    public void setUiPortlets(List<UIPortlet> uiPortlets) {
        this.uiPortlets = uiPortlets;
    }

    @Generated
    public Page getPage() {
        return this.page;
    }

    @Generated
    public void setPage(Page page) {
        this.page = page;
    }

    @Generated
    public UserNode getUserNode() {
        return this.userNode;
    }

    @Generated
    public void setUserNode(UserNode userNode) {
        this.userNode = userNode;
    }
}

