/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.dao;

import jakarta.persistence.TypedQuery;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.wallet.entity.TransactionEntity;

public class WalletTransactionDAO
extends GenericDAOJPAImpl<TransactionEntity, Long> {
    private static final String NONCE_PARAM = "nonce";
    private static final String HASH_PARAM = "hash";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String ADDRESS_PARAM = "address";
    private static final String CONTRACT_ADDRESS_PARAM = "contractAddress";
    private static final String CONTRACT_METHOD_NAME_PARAM = "methodName";
    private static final String NETWORK_ID_PARAM = "networkId";

    public List<TransactionEntity> getContractTransactions(String contractAddress, String contractMethodName, int limit) {
        contractAddress = StringUtils.lowerCase((String)contractAddress);
        String queryName = "WalletTransaction.getContractTransactions";
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            queryName = "WalletTransaction.getContractTransactionsWithMethodName";
        }
        TypedQuery query = this.getEntityManager().createNamedQuery(queryName, TransactionEntity.class);
        query.setParameter(CONTRACT_ADDRESS_PARAM, (Object)contractAddress.toLowerCase());
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            query.setParameter(CONTRACT_METHOD_NAME_PARAM, (Object)contractMethodName);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List result = query.getResultList();
        return this.toNotNullList(result);
    }

    public List<TransactionEntity> getTransactions(long networkId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getNetworkTransactions", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List result = query.getResultList();
        return this.toNotNullList(result);
    }

    public List<TransactionEntity> getWalletTransactions(long networkId, String address, String contractAddress, String contractMethodName, int limit, boolean onlyPending, boolean includeAdministrationTransactions) {
        address = StringUtils.lowerCase((String)address);
        contractAddress = StringUtils.lowerCase((String)contractAddress);
        StringBuilder queryString = new StringBuilder("SELECT tx FROM WalletTransaction tx WHERE tx.networkId = ");
        queryString.append(networkId);
        if (!includeAdministrationTransactions) {
            queryString.append(" AND tx.isAdminOperation = FALSE");
        }
        queryString.append(" AND tx.isDropped = FALSE");
        queryString.append(" AND (tx.fromAddress = '");
        queryString.append(address);
        queryString.append("' OR tx.toAddress = '");
        queryString.append(address);
        queryString.append("' OR tx.byAddress = '");
        queryString.append(address);
        queryString.append("')");
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            queryString.append(" AND tx.contractMethodName = '");
            queryString.append(contractMethodName);
            queryString.append("'");
        }
        if (onlyPending) {
            queryString.append(" AND tx.isPending = TRUE");
        }
        if (StringUtils.isNotBlank((CharSequence)contractAddress)) {
            queryString.append(" AND tx.contractAddress = '");
            queryString.append(contractAddress);
            queryString.append("' ");
        }
        queryString.append(" ORDER BY tx.createdDate DESC");
        TypedQuery query = this.getEntityManager().createQuery(queryString.toString(), TransactionEntity.class);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        List result = query.getResultList();
        return this.toNotNullList(result);
    }

    public List<TransactionEntity> getPendingEtherTransactions(String address, long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingEtherTransactions", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        List resultList = query.getResultList();
        return this.toNotNullList(resultList);
    }

    public List<TransactionEntity> getPendingWalletTransactionsNotSent(String address, long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingWalletTransactionsNotSent", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        List resultList = query.getResultList();
        return this.toNotNullList(resultList);
    }

    public List<TransactionEntity> getPendingWalletTransactionsSent(String address, long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingWalletTransactionsSent", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        List resultList = query.getResultList();
        return this.toNotNullList(resultList);
    }

    public long countContractPendingTransactionsSent(long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countContractPendingTransactionsSent", Long.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        Long result = (Long)query.getSingleResult();
        return this.toNotNullLong(result);
    }

    public long countContractPendingTransactionsToSend(long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countContractPendingTransactionsToSend", Long.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        Long result = (Long)query.getSingleResult();
        return this.toNotNullLong(result);
    }

    public TransactionEntity getTransactionByHash(String hash) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getTransactionByHash", TransactionEntity.class);
        query.setParameter(HASH_PARAM, (Object)StringUtils.lowerCase((String)hash));
        List resultList = query.getResultList();
        return this.getFirstItem(resultList);
    }

    public TransactionEntity getPendingTransactionByHash(String hash) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingTransactionByHash", TransactionEntity.class);
        query.setParameter(HASH_PARAM, (Object)StringUtils.lowerCase((String)hash));
        List resultList = query.getResultList();
        return this.getFirstItem(resultList);
    }

    public List<TransactionEntity> getPendingTransactionsWithSameNonce(long networkId, String transactionHash, String fromAddress, long nonce) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getPendingTransactionsWithSameNonce", TransactionEntity.class);
        query.setParameter(NONCE_PARAM, (Object)nonce);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)fromAddress));
        query.setParameter(HASH_PARAM, (Object)StringUtils.lowerCase((String)transactionHash));
        List resultList = query.getResultList();
        return this.toNotNullList(resultList);
    }

    public long countPendingTransactionsWithSameNonce(long networkId, String transactionHash, String fromAddress, long nonce) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countPendingTransactionsWithSameNonce", Long.class);
        query.setParameter(NONCE_PARAM, (Object)nonce);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)fromAddress));
        query.setParameter(HASH_PARAM, (Object)StringUtils.lowerCase((String)transactionHash));
        Long result = (Long)query.getSingleResult();
        return this.toNotNullLong(result);
    }

    public long getMaxUsedNonce(long networkId, String fromAddress) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getMaxUsedNonce", Long.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)fromAddress));
        Long result = (Long)query.getSingleResult();
        return this.toNotNullLong(result);
    }

    public double countReceivedContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countReceivedContractAmount", Double.class);
        query.setParameter(CONTRACT_ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)contractAddress));
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        query.setParameter(START_DATE, (Object)this.toMilliSeconds(startDate));
        query.setParameter(END_DATE, (Object)this.toMilliSeconds(endDate));
        Double result = (Double)query.getSingleResult();
        return this.toNotNullDouble(result);
    }

    public double countSentContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countSentContractAmount", Double.class);
        query.setParameter(CONTRACT_ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)contractAddress));
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)address));
        query.setParameter(START_DATE, (Object)this.toMilliSeconds(startDate));
        query.setParameter(END_DATE, (Object)this.toMilliSeconds(endDate));
        Double result = (Double)query.getSingleResult();
        return this.toNotNullDouble(result);
    }

    public List<TransactionEntity> getTransactionsToSend(long networkId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.getTransactionsToSend", TransactionEntity.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        List resultList = query.getResultList();
        return this.toNotNullList(resultList);
    }

    public long countPendingTransactionSent(long networkId, String fromAddress) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countPendingTransactionSent", Long.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)fromAddress));
        Long result = (Long)query.getSingleResult();
        return this.toNotNullLong(result);
    }

    public long countPendingTransactionAsSender(long networkId, String fromAddress) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WalletTransaction.countPendingTransactionAsSender", Long.class);
        query.setParameter(NETWORK_ID_PARAM, (Object)networkId);
        query.setParameter(ADDRESS_PARAM, (Object)StringUtils.lowerCase((String)fromAddress));
        Long result = (Long)query.getSingleResult();
        return this.toNotNullLong(result);
    }

    private long toMilliSeconds(ZonedDateTime date) {
        return date.toInstant().toEpochMilli();
    }

    private List<TransactionEntity> toNotNullList(List<TransactionEntity> result) {
        return result == null ? Collections.emptyList() : result;
    }

    private long toNotNullLong(Long result) {
        return result == null ? 0L : result;
    }

    private double toNotNullDouble(Double result) {
        return result == null ? 0.0 : result;
    }

    private TransactionEntity getFirstItem(List<TransactionEntity> resultList) {
        return resultList == null || resultList.isEmpty() ? null : resultList.get(0);
    }
}

