/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.news.model.News;
import io.meeds.news.service.NewsService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataItemModified
extends Listener<Long, MetadataItem> {
    @Autowired
    private IndexingService indexingService;
    @Autowired
    private NewsService newsService;
    @Autowired
    private ActivityStorage activityStorage;
    @Autowired
    private ListenerService listenerService;
    private CachedActivityStorage cachedActivityStorage;
    private String[] LISTENER_EVENTS = new String[]{"social.metadataItem.updated", "social.metadataItem.created", "social.metadataItem.deleted"};

    @PostConstruct
    public void init() {
        if (this.activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)this.activityStorage;
        }
        for (String listener : this.LISTENER_EVENTS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        News news;
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = metadataItem.getObjectType();
        String objectId = metadataItem.getObjectId();
        if (this.isNewsEvent(objectType) && (news = this.newsService.getNewsArticleById(StringUtils.substringBefore((String)objectId, (String)"-"))) != null) {
            if (StringUtils.isNotBlank((CharSequence)news.getActivityId())) {
                this.clearCache(news.getActivityId());
            }
            this.reindexNews(objectId);
        }
    }

    protected boolean isNewsEvent(String objectType) {
        return StringUtils.equals((CharSequence)objectType, (CharSequence)"news");
    }

    private void clearCache(String activityId) {
        if (this.cachedActivityStorage != null) {
            this.cachedActivityStorage.clearActivityCached(activityId);
        }
    }

    private void reindexNews(String newsId) {
        this.indexingService.reindex("news", newsId);
    }
}

