/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.pool.TypePool;

public class CoreTypePool
extends TypePool.AbstractBase
implements TypePool {
    private final ClassLoader hibernateClassLoader = CoreTypePool.class.getClassLoader();
    private final ConcurrentHashMap<String, TypePool.Resolution> resolutions = new ConcurrentHashMap();
    private final String[] acceptedPrefixes;

    public CoreTypePool() {
        this("jakarta.", "java.", "org.hibernate.annotations.");
    }

    public CoreTypePool(String ... acceptedPrefixes) {
        super((TypePool.CacheProvider)new TypePool.CacheProvider.Simple());
        this.acceptedPrefixes = acceptedPrefixes;
    }

    private boolean isCoreClassName(String name) {
        for (String acceptedPrefix : this.acceptedPrefixes) {
            if (!name.startsWith(acceptedPrefix)) continue;
            return true;
        }
        return false;
    }

    protected TypePool.Resolution doDescribe(String name) {
        if (this.isCoreClassName(name)) {
            TypePool.Resolution resolution = this.resolutions.get(name);
            if (resolution != null) {
                return resolution;
            }
            return this.resolutions.computeIfAbsent(name, this::actualResolve);
        }
        return new TypePool.Resolution.Illegal(name);
    }

    private TypePool.Resolution actualResolve(String name) {
        try {
            Class<?> aClass = Class.forName(name, false, this.hibernateClassLoader);
            return new TypePool.Resolution.Simple(TypeDescription.ForLoadedType.of(aClass));
        }
        catch (ClassNotFoundException e) {
            return new TypePool.Resolution.Illegal(name);
        }
    }
}

