/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.type.classreading;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.data.type.MethodsMetadata;
import org.springframework.data.type.classreading.MethodsMetadataReader;
import org.springframework.lang.Nullable;

@Deprecated
public class MethodsMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    public MethodsMetadataReaderFactory() {
    }

    public MethodsMetadataReaderFactory(@Nullable ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public MethodsMetadataReaderFactory(@Nullable ClassLoader classLoader) {
        super(classLoader);
    }

    public MethodsMetadataReader getMetadataReader(String className) throws IOException {
        return new MetadataReaderWrapper(super.getMetadataReader(className));
    }

    public MethodsMetadataReader getMetadataReader(Resource resource) throws IOException {
        return new MetadataReaderWrapper(super.getMetadataReader(resource));
    }

    private static class MetadataReaderWrapper
    implements MethodsMetadataReader {
        private final MetadataReader delegate;

        MetadataReaderWrapper(MetadataReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public MethodsMetadata getMethodsMetadata() {
            return new MethodsMetadataWrapper(this.getAnnotationMetadata(), this.getClassMetadata());
        }

        public Resource getResource() {
            return this.delegate.getResource();
        }

        public ClassMetadata getClassMetadata() {
            return this.delegate.getClassMetadata();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.delegate.getAnnotationMetadata();
        }
    }

    private static class MethodsMetadataWrapper
    implements MethodsMetadata,
    ClassMetadata {
        private final AnnotationMetadata annotationMetadata;
        private final ClassMetadata classMetadata;

        MethodsMetadataWrapper(AnnotationMetadata annotationMetadata, ClassMetadata classMetadata) {
            this.annotationMetadata = annotationMetadata;
            this.classMetadata = classMetadata;
        }

        @Override
        public Set<MethodMetadata> getMethods() {
            return this.annotationMetadata.getDeclaredMethods();
        }

        @Override
        public Set<MethodMetadata> getMethods(String name) {
            return this.annotationMetadata.getDeclaredMethods().stream().filter(it -> it.getMethodName().equals(name)).collect(Collectors.toSet());
        }

        public String getClassName() {
            return this.classMetadata.getClassName();
        }

        public boolean isInterface() {
            return this.classMetadata.isInterface();
        }

        public boolean isAnnotation() {
            return this.classMetadata.isAnnotation();
        }

        public boolean isAbstract() {
            return this.classMetadata.isAbstract();
        }

        public boolean isConcrete() {
            return this.classMetadata.isConcrete();
        }

        public boolean isFinal() {
            return this.classMetadata.isFinal();
        }

        public boolean isIndependent() {
            return this.classMetadata.isIndependent();
        }

        public boolean hasEnclosingClass() {
            return this.classMetadata.hasEnclosingClass();
        }

        @Nullable
        public String getEnclosingClassName() {
            return this.classMetadata.getEnclosingClassName();
        }

        public boolean hasSuperClass() {
            return this.classMetadata.hasSuperClass();
        }

        @Nullable
        public String getSuperClassName() {
            return this.classMetadata.getSuperClassName();
        }

        public String[] getInterfaceNames() {
            return this.classMetadata.getInterfaceNames();
        }

        public String[] getMemberClassNames() {
            return this.classMetadata.getMemberClassNames();
        }
    }
}

