/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.SerializablePageList;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormPopupWindow;
import org.exoplatform.webui.organization.MembershipListAccess;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;
import org.exoplatform.webui.organization.UISelector;

@ComponentConfig(template="system:/groovy/organization/webui/component/UIUserMembershipSelector.gtmpl", events={@EventConfig(listeners={UISelector.SelectMembershipActionListener.class}), @EventConfig(listeners={DeleteMembershipActionListener.class}, phase=Event.Phase.DECODE, confirm="UIUserMembershipSelector.deleteMembership")})
@Serialized
public class UIUserMembershipSelector
extends UISelector<String> {
    private List<Membership> membership_ = new ArrayList<Membership>();
    private String user_ = "site";
    private boolean isAdminRole_ = false;
    public static final String[] BEAN_FIELD = new String[]{"userName", "groupId", "membershipType"};
    public static final String[] ACTIONS = new String[]{"DeleteMembership"};

    public UIUserMembershipSelector() throws Exception {
        super("UIUserMembershipSelector", null);
        this.setComponentConfig(UIUserMembershipSelector.class, null);
        UIGrid uiGrid = this.addChild(UIGrid.class, null, "MembershipGrid");
        uiGrid.configure("id", BEAN_FIELD, ACTIONS);
        UIFormPopupWindow uiPopup = this.addChild(UIFormPopupWindow.class, null, "UserPermissionSelector");
        uiPopup.setWindowSize(540, 0);
        UIGroupMembershipSelector uiMembershipSelector = this.createUIComponent(UIGroupMembershipSelector.class, null, null);
        uiPopup.setUIComponent(uiMembershipSelector);
    }

    public String getUser() {
        return this.user_;
    }

    public void setUserName(String userName) {
        this.user_ = userName;
    }

    @Override
    public Class<String> getTypeValue() {
        return String.class;
    }

    public boolean isAdminRole() {
        return this.isAdminRole_;
    }

    public void setAdminRole(boolean b) {
        this.isAdminRole_ = b;
    }

    public void setUser(User user) throws Exception {
        this.user_ = user.getUserName();
        this.membership_.clear();
        OrganizationService service = this.getApplicationComponent(OrganizationService.class);
        Collection collection = service.getMembershipHandler().findMembershipsByUser(this.user_);
        for (org.exoplatform.services.organization.Membership membership : collection) {
            this.addMembership(new Membership(membership.getUserName(), membership.getId(), membership.getGroupId(), membership.getMembershipType()));
        }
        UIGrid uiGrid = this.getChild(UIGrid.class);
        SerializablePageList pageList = new SerializablePageList((ListAccess)new MembershipListAccess(this.getMembership()), 10);
        uiGrid.getUIPageIterator().setPageList((PageList)pageList);
    }

    public List<Membership> getMembership() {
        return this.membership_;
    }

    public void createMembership(String groupId, String membershipType) {
        Membership membership = new Membership(this.user_, "", groupId, membershipType);
        this.addMembership(membership);
    }

    public void addMembership(Membership mem) {
        String membershipType = null;
        for (Membership ele : this.membership_) {
            String groupId = ele.getGroupId();
            membershipType = ele.getMembershipType();
            if (!groupId.equals(mem.getGroupId()) || !membershipType.equals(mem.getMembershipType())) continue;
            return;
        }
        this.membership_.add(mem);
    }

    public void setUIInputValue(Object input) {
        this.user_ = (String)input;
    }

    public void save(OrganizationService service, boolean broadcast) throws Exception {
        GroupHandler groupHandler = service.getGroupHandler();
        MembershipTypeHandler mtHandler = service.getMembershipTypeHandler();
        User user = service.getUserHandler().findUserByName(this.user_);
        for (Membership membership : this.membership_) {
            if (user == null) {
                user = service.getUserHandler().findUserByName(membership.getUserName());
            }
            Group group = groupHandler.findGroupById(membership.getGroupId());
            MembershipType mt = mtHandler.findMembershipType(membership.getMembershipType());
            if (service.getMembershipHandler() == null) continue;
            service.getMembershipHandler().linkMembership(user, group, mt, broadcast);
        }
    }

    @Override
    void setMembership(String groupId, String membershipType) {
        this.createMembership(groupId, membershipType);
    }

    @Override
    public String event(String actionName, String beanId) throws Exception {
        UIForm uiForm = this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(actionName, this.getId(), beanId);
        }
        return super.event(this.name, beanId);
    }

    public static class Membership
    implements Serializable {
        private String groupId_;
        private String membershipType_;
        private String userName_;
        private String id_;

        public Membership(String userName, String id, String groupId, String membershipType) {
            this.userName_ = userName;
            this.id_ = id;
            this.groupId_ = groupId;
            this.membershipType_ = membershipType;
        }

        public Membership(String userName, String groupId, String membershipType) {
            this(userName, "", groupId, membershipType);
        }

        public String getId() {
            return this.id_;
        }

        public void setId(String id) {
            this.id_ = id;
        }

        public String getUserName() {
            return this.userName_;
        }

        public void setUserName(String userName) {
            this.userName_ = userName;
        }

        public String getGroupId() {
            return this.groupId_;
        }

        public void setGroupId(String groupId) {
            this.groupId_ = groupId;
        }

        public String getMembershipType() {
            return this.membershipType_;
        }

        public void setMembershipType(String membershipType) {
            this.membershipType_ = membershipType;
        }
    }

    public static class DeleteMembershipActionListener
    extends EventListener<UIUserMembershipSelector> {
        @Override
        public void execute(Event<UIUserMembershipSelector> event) throws Exception {
            int currentPage;
            UIUserMembershipSelector uiUserMembershipSelector = event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIPageIterator pageIterator = uiUserMembershipSelector.getChild(UIGrid.class).getUIPageIterator();
            OrganizationService service = uiUserMembershipSelector.getApplicationComponent(OrganizationService.class);
            service.getMembershipHandler().removeMembership(id, true);
            User user = service.getUserHandler().findUserByName(uiUserMembershipSelector.getUser(), UserStatus.ANY);
            uiUserMembershipSelector.setUser(user);
            for (currentPage = pageIterator.getCurrentPage(); currentPage > pageIterator.getAvailablePage(); --currentPage) {
            }
            pageIterator.setCurrentPage(currentPage);
        }
    }
}

