/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.management.data.RestResourceMethodParameter;
import org.exoplatform.management.invocation.MethodInvoker;
import org.exoplatform.management.invocation.SimpleMethodInvoker;
import org.exoplatform.management.spi.ManagedMethodMetaData;
import org.exoplatform.management.spi.ManagedMethodParameterMetaData;

public class RestResourceMethod {
    final ManagedMethodMetaData metaData;
    final List<RestResourceMethodParameter> parameters;
    final Set<String> parameterNames;
    final MethodInvoker methodInvoker;

    public RestResourceMethod(ManagedMethodMetaData metaData) {
        ArrayList<RestResourceMethodParameter> parameters = new ArrayList<RestResourceMethodParameter>();
        HashSet<String> parameterNames = new HashSet<String>();
        for (ManagedMethodParameterMetaData parameterMD : metaData.getParameters()) {
            parameters.add(new RestResourceMethodParameter(parameterMD));
            parameterNames.add(parameterMD.getName());
        }
        this.metaData = metaData;
        this.parameterNames = Collections.unmodifiableSet(parameterNames);
        this.parameters = Collections.unmodifiableList(parameters);
        this.methodInvoker = new SimpleMethodInvoker(metaData.getMethod()){

            @Override
            protected String getArgumentName(int index) {
                RestResourceMethodParameter param = RestResourceMethod.this.parameters.get(index);
                return param != null ? param.getName() : null;
            }
        };
    }

    public String getName() {
        return this.metaData.getName();
    }

    public String getMethod() {
        switch (this.metaData.getImpact()) {
            case READ: {
                return "get";
            }
            case WRITE: {
                return "post";
            }
            case IDEMPOTENT_WRITE: {
                return "put";
            }
        }
        throw new AssertionError();
    }

    public String getDescription() {
        return this.metaData.getDescription();
    }

    public List<RestResourceMethodParameter> getParameters() {
        return this.parameters;
    }

    MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }
}

