/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ResponseBodyEmitter {
    @Nullable
    private final Long timeout;
    @Nullable
    private Handler handler;
    private final Set<DataWithMediaType> earlySendAttempts = new LinkedHashSet<DataWithMediaType>(8);
    private boolean complete;
    @Nullable
    private Throwable failure;
    private final DefaultCallback timeoutCallback = new DefaultCallback();
    private final ErrorCallback errorCallback = new ErrorCallback();
    private final DefaultCallback completionCallback = new DefaultCallback();

    public ResponseBodyEmitter() {
        this.timeout = null;
    }

    public ResponseBodyEmitter(Long timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public Long getTimeout() {
        return this.timeout;
    }

    synchronized void initialize(Handler handler) throws IOException {
        this.handler = handler;
        try {
            this.sendInternal(this.earlySendAttempts);
        }
        finally {
            this.earlySendAttempts.clear();
        }
        if (this.complete) {
            if (this.failure != null) {
                this.handler.completeWithError(this.failure);
            } else {
                this.handler.complete();
            }
        } else {
            this.handler.onTimeout(this.timeoutCallback);
            this.handler.onError(this.errorCallback);
            this.handler.onCompletion(this.completionCallback);
        }
    }

    synchronized void initializeWithError(Throwable ex) {
        this.complete = true;
        this.failure = ex;
        this.earlySendAttempts.clear();
        this.errorCallback.accept(ex);
    }

    protected void extendResponse(ServerHttpResponse outputMessage) {
    }

    public void send(Object object) throws IOException {
        this.send(object, null);
    }

    public synchronized void send(Object object, @Nullable MediaType mediaType) throws IOException {
        Assert.state((!this.complete ? 1 : 0) != 0, () -> "ResponseBodyEmitter has already completed" + (String)(this.failure != null ? " with error: " + this.failure : ""));
        if (this.handler != null) {
            try {
                this.handler.send(object, mediaType);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to send " + object, ex);
            }
        } else {
            this.earlySendAttempts.add(new DataWithMediaType(object, mediaType));
        }
    }

    public synchronized void send(Set<DataWithMediaType> items) throws IOException {
        Assert.state((!this.complete ? 1 : 0) != 0, () -> "ResponseBodyEmitter has already completed" + (String)(this.failure != null ? " with error: " + this.failure : ""));
        this.sendInternal(items);
    }

    private void sendInternal(Set<DataWithMediaType> items) throws IOException {
        if (items.isEmpty()) {
            return;
        }
        if (this.handler != null) {
            try {
                this.handler.send(items);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to send " + items, ex);
            }
        } else {
            this.earlySendAttempts.addAll(items);
        }
    }

    public synchronized void complete() {
        this.complete = true;
        if (this.handler != null) {
            this.handler.complete();
        }
    }

    public synchronized void completeWithError(Throwable ex) {
        this.complete = true;
        this.failure = ex;
        if (this.handler != null) {
            this.handler.completeWithError(ex);
        }
    }

    public synchronized void onTimeout(Runnable callback) {
        this.timeoutCallback.setDelegate(callback);
    }

    public synchronized void onError(Consumer<Throwable> callback) {
        this.errorCallback.setDelegate(callback);
    }

    public synchronized void onCompletion(Runnable callback) {
        this.completionCallback.setDelegate(callback);
    }

    public String toString() {
        return "ResponseBodyEmitter@" + ObjectUtils.getIdentityHexString((Object)this);
    }

    private class DefaultCallback
    implements Runnable {
        @Nullable
        private Runnable delegate;

        private DefaultCallback() {
        }

        public void setDelegate(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            ResponseBodyEmitter.this.complete = true;
            if (this.delegate != null) {
                this.delegate.run();
            }
        }
    }

    private class ErrorCallback
    implements Consumer<Throwable> {
        @Nullable
        private Consumer<Throwable> delegate;

        private ErrorCallback() {
        }

        public void setDelegate(Consumer<Throwable> callback) {
            this.delegate = callback;
        }

        @Override
        public void accept(Throwable t) {
            ResponseBodyEmitter.this.complete = true;
            if (this.delegate != null) {
                this.delegate.accept(t);
            }
        }
    }

    static interface Handler {
        public void send(Object var1, @Nullable MediaType var2) throws IOException;

        public void send(Set<DataWithMediaType> var1) throws IOException;

        public void complete();

        public void completeWithError(Throwable var1);

        public void onTimeout(Runnable var1);

        public void onError(Consumer<Throwable> var1);

        public void onCompletion(Runnable var1);
    }

    public static class DataWithMediaType {
        private final Object data;
        @Nullable
        private final MediaType mediaType;

        public DataWithMediaType(Object data, @Nullable MediaType mediaType) {
            this.data = data;
            this.mediaType = mediaType;
        }

        public Object getData() {
            return this.data;
        }

        @Nullable
        public MediaType getMediaType() {
            return this.mediaType;
        }
    }
}

