/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.constant;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

public enum RecurrenceType {
    NONE,
    ONCE,
    DAILY,
    WEEKLY,
    MONTHLY;

    private static final Date ONCE_RECURRENCE_START_DATE;

    public Date getPeriodStartDate() {
        return switch (this.ordinal()) {
            case 0 -> null;
            case 1 -> ONCE_RECURRENCE_START_DATE;
            case 2 -> Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
            case 3 -> Date.from(LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).atStartOfDay(ZoneId.systemDefault()).toInstant());
            case 4 -> Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this));
        };
    }

    public Date getNextPeriodStartDate() {
        return switch (this.ordinal()) {
            case 0 -> null;
            case 1 -> ONCE_RECURRENCE_START_DATE;
            case 2 -> Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).plusDays(1L).toInstant());
            case 3 -> Date.from(LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).atStartOfDay(ZoneId.systemDefault()).plusWeeks(1L).toInstant());
            case 4 -> Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfNextMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this));
        };
    }

    static {
        ONCE_RECURRENCE_START_DATE = new Date(1200000000000L);
    }
}

