/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.web.client.RestClientSsl;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;

class AutoConfiguredRestClientSsl
implements RestClientSsl {
    private final SslBundles sslBundles;

    AutoConfiguredRestClientSsl(SslBundles sslBundles) {
        this.sslBundles = sslBundles;
    }

    @Override
    public Consumer<RestClient.Builder> fromBundle(String bundleName) {
        return this.fromBundle(this.sslBundles.getBundle(bundleName));
    }

    @Override
    public Consumer<RestClient.Builder> fromBundle(SslBundle bundle) {
        return builder -> {
            ClientHttpRequestFactorySettings settings = ClientHttpRequestFactorySettings.DEFAULTS.withSslBundle(bundle);
            ClientHttpRequestFactory requestFactory = ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)settings);
            builder.requestFactory(requestFactory);
        };
    }
}

