/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.expression;

import org.springframework.core.env.Environment;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.expression.EvaluationException;

record PlaceholderExpression(String expression) implements ValueExpression
{
    @Override
    public String getExpressionString() {
        return this.expression;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public Object evaluate(ValueEvaluationContext context) {
        Environment environment = context.getEnvironment();
        if (environment != null) {
            try {
                return environment.resolveRequiredPlaceholders(this.expression);
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(e.getMessage(), (Throwable)e);
            }
        }
        return this.expression;
    }
}

