/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebAppController;

public class PortalController
extends AbstractHttpServlet {
    protected static Log log = ExoLogger.getLogger((String)"org.gatein.portal.application.PortalController");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInit(ServletConfig sConfig, PortalContainer portalContainer) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        try {
            PortalServletConfig config = new PortalServletConfig(sConfig, portalContainer);
            WebAppController controller = (WebAppController)portalContainer.getComponentInstanceOfType(WebAppController.class);
            Thread.currentThread().setContextClassLoader(portalContainer.getPortalClassLoader());
            hasChanged = true;
            controller.onHandlersInit((ServletConfig)config);
            log.info((Object)("The WebAppController has been successfully initialized for the portal '" + portalContainer.getName() + "'"));
        }
        catch (Throwable t) {
            log.error((Object)("The WebAppController could not be initialized for the portal '" + portalContainer.getName() + "'"), t);
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    public void afterInit(final ServletConfig config) throws ServletException {
        RootContainer.PortalContainerPostCreateTask task = new RootContainer.PortalContainerPostCreateTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                PortalController.this.onInit(config, portalContainer);
            }
        };
        ServletContext context = config.getServletContext();
        RootContainer rootContainer = RootContainer.getInstance();
        rootContainer.addInitTask(context, (RootContainer.PortalContainerInitTask)task);
        rootContainer.registerPortalContainer(context);
    }

    protected void onService(ExoContainer container, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
            controller.service(req, res);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean requirePortalEnvironment() {
        return true;
    }

    private static class PortalServletConfig
    implements ServletConfig {
        private final ServletConfig sConfig;
        private final PortalContainer portalContainer;

        public PortalServletConfig(ServletConfig sConfig, PortalContainer portalContainer) {
            this.sConfig = sConfig;
            this.portalContainer = portalContainer;
        }

        public String getServletName() {
            return this.sConfig.getServletName();
        }

        public ServletContext getServletContext() {
            return this.portalContainer.getPortalContext();
        }

        public Enumeration getInitParameterNames() {
            return this.sConfig.getInitParameterNames();
        }

        public String getInitParameter(String name) {
            return this.sConfig.getInitParameter(name);
        }
    }
}

