/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.rcs.impl;

import org.suigeneris.jrcs.rcs.BranchNotFoundException;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.Node;
import org.suigeneris.jrcs.rcs.impl.NodeNotFoundException;

public class BranchNode
extends Node {
    BranchNode(Version vernum, BranchNode next) {
        super(vernum, next);
        if (vernum == null) {
            throw new IllegalArgumentException(vernum.toString());
        }
    }

    public BranchNode getLeafNode() {
        BranchNode result = this;
        while (result.getRCSNext() != null) {
            result = (BranchNode)result.getRCSNext();
        }
        return result;
    }

    public void setRCSNext(Node node) {
        super.setRCSNext(node);
        if (this.getChild() != null) {
            this.getChild().parent = null;
        }
        this.child = node;
        if (this.getChild() != null) {
            this.getChild().parent = this;
        }
    }

    public Node deltaRevision() {
        return this;
    }

    public Node nextInPathTo(Version vernum, boolean soft) throws NodeNotFoundException {
        Version branchPoint = vernum.getBase(this.version.size());
        Version thisBase = this.version.getBase(branchPoint.size());
        if (thisBase.isGreaterThan(branchPoint) && !soft) {
            throw new NodeNotFoundException(vernum);
        }
        if (this.version.equals(vernum)) {
            return null;
        }
        if (this.version.isLessThan(branchPoint)) {
            return this.getChild();
        }
        if (vernum.size() <= this.version.size()) {
            if (vernum.size() < this.version.size() || branchPoint.last() == 0) {
                return this.getChild();
            }
            return null;
        }
        BranchNode branch = this.getBranch(vernum.at(this.version.size()));
        if (branch != null || soft) {
            return branch;
        }
        throw new BranchNotFoundException(vernum.getBase(this.version.size() + 1));
    }
}

