/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.security.FieldSecurity;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndicesPrivileges
implements JsonpSerializable {
    @Nullable
    private final FieldSecurity fieldSecurity;
    private final List<String> names;
    private final List<String> privileges;
    @Nullable
    private final Query query;
    @Nullable
    private final Boolean allowRestrictedIndices;
    public static final JsonpDeserializer<IndicesPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesPrivileges::setupIndicesPrivilegesDeserializer);

    private IndicesPrivileges(Builder builder) {
        this.fieldSecurity = builder.fieldSecurity;
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
        this.query = builder.query;
        this.allowRestrictedIndices = builder.allowRestrictedIndices;
    }

    public static IndicesPrivileges of(Function<Builder, ObjectBuilder<IndicesPrivileges>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FieldSecurity fieldSecurity() {
        return this.fieldSecurity;
    }

    public final List<String> names() {
        return this.names;
    }

    public final List<String> privileges() {
        return this.privileges;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Boolean allowRestrictedIndices() {
        return this.allowRestrictedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fieldSecurity != null) {
            generator.writeKey("field_security");
            this.fieldSecurity.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (String item0 : this.names) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.privileges)) {
            generator.writeKey("privileges");
            generator.writeStartArray();
            for (String item0 : this.privileges) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(JsonpUtils.toJsonString(this.query, mapper));
        }
        if (this.allowRestrictedIndices != null) {
            generator.writeKey("allow_restricted_indices");
            generator.write(this.allowRestrictedIndices.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndicesPrivilegesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldSecurity, FieldSecurity._DESERIALIZER, "field_security");
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names");
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "privileges");
        op.add(Builder::query, JsonpDeserializer.jsonString(Query._DESERIALIZER), "query");
        op.add(Builder::allowRestrictedIndices, JsonpDeserializer.booleanDeserializer(), "allow_restricted_indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndicesPrivileges> {
        @Nullable
        private FieldSecurity fieldSecurity;
        private List<String> names;
        private List<String> privileges;
        @Nullable
        private Query query;
        @Nullable
        private Boolean allowRestrictedIndices;

        public final Builder fieldSecurity(@Nullable FieldSecurity value) {
            this.fieldSecurity = value;
            return this;
        }

        public final Builder fieldSecurity(Function<FieldSecurity.Builder, ObjectBuilder<FieldSecurity>> fn) {
            return this.fieldSecurity(fn.apply(new FieldSecurity.Builder()).build());
        }

        public final Builder names(List<String> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(String value, String ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder privileges(List<String> list) {
            this.privileges = Builder._listAddAll(this.privileges, list);
            return this;
        }

        public final Builder privileges(String value, String ... values) {
            this.privileges = Builder._listAdd(this.privileges, value, values);
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder allowRestrictedIndices(@Nullable Boolean value) {
            this.allowRestrictedIndices = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndicesPrivileges build() {
            this._checkSingleUse();
            return new IndicesPrivileges(this);
        }
    }
}

