/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryRegistrationAotContribution;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.util.TypeContributor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RepositoryRegistrationAotProcessor
implements BeanRegistrationAotProcessor,
BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, RepositoryConfiguration<?>> configMap;

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean bean) {
        return this.isRepositoryBean(bean) ? this.newRepositoryRegistrationAotContribution(bean) : null;
    }

    protected void contribute(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        repositoryContext.getResolvedTypes().stream().filter(it -> !RepositoryRegistrationAotContribution.isJavaOrPrimitiveType(it)).forEach(it -> this.contributeType((Class<?>)it, generationContext));
        repositoryContext.getResolvedAnnotations().stream().filter(RepositoryRegistrationAotProcessor::isSpringDataManagedAnnotation).map(MergedAnnotation::getType).forEach(it -> this.contributeType((Class<?>)it, generationContext));
    }

    private void registerReflectiveForAggregateRoot(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        RepositoryInformation information = repositoryContext.getRepositoryInformation();
        ReflectiveRuntimeHintsRegistrar registrar = new ReflectiveRuntimeHintsRegistrar();
        RuntimeHints hints = generationContext.getRuntimeHints();
        ArrayList aggregateRootTypes = new ArrayList();
        aggregateRootTypes.add(information.getDomainType());
        aggregateRootTypes.addAll(information.getAlternativeDomainTypes());
        Stream.concat(Stream.of(information.getDomainType()), information.getAlternativeDomainTypes().stream()).forEach(it -> registrar.registerRuntimeHints(hints, new Class[]{it}));
    }

    private boolean isRepositoryBean(RegisteredBean bean) {
        return this.getConfigMap().containsKey(bean.getBeanName());
    }

    protected RepositoryRegistrationAotContribution newRepositoryRegistrationAotContribution(RegisteredBean repositoryBean) {
        RepositoryRegistrationAotContribution contribution = RepositoryRegistrationAotContribution.fromProcessor(this).forBean(repositoryBean);
        BiConsumer<AotRepositoryContext, GenerationContext> moduleContribution = this::registerReflectiveForAggregateRoot;
        return contribution.withModuleContribution(moduleContribution.andThen(this::contribute));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, () -> "AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory: " + beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setConfigMap(@Nullable Map<String, RepositoryConfiguration<?>> configMap) {
        this.configMap = configMap;
    }

    public Map<String, RepositoryConfiguration<?>> getConfigMap() {
        return this.nullSafeMap(this.configMap);
    }

    private <K, V> Map<K, V> nullSafeMap(@Nullable Map<K, V> map) {
        return map != null ? map : Collections.emptyMap();
    }

    @Nullable
    protected RepositoryConfiguration<?> getRepositoryMetadata(RegisteredBean bean) {
        return this.getConfigMap().get(this.nullSafeBeanName(bean));
    }

    private String nullSafeBeanName(RegisteredBean bean) {
        String beanName = bean.getBeanName();
        return StringUtils.hasText((String)beanName) ? beanName : "";
    }

    protected Log getLogger() {
        return this.logger;
    }

    private void logAt(Predicate<Log> logLevelPredicate, BiConsumer<Log, String> logOperation, String message, Object ... arguments) {
        Log logger = this.getLogger();
        if (logLevelPredicate.test(logger)) {
            logOperation.accept(logger, String.format(message, arguments));
        }
    }

    protected void logDebug(String message, Object ... arguments) {
        this.logAt(Log::isDebugEnabled, Log::debug, message, arguments);
    }

    protected void logTrace(String message, Object ... arguments) {
        this.logAt(Log::isTraceEnabled, Log::trace, message, arguments);
    }

    private static boolean isSpringDataManagedAnnotation(@Nullable MergedAnnotation<?> annotation) {
        return annotation != null && (RepositoryRegistrationAotProcessor.isInSpringDataNamespace(annotation.getType()) || annotation.getMetaTypes().stream().anyMatch(RepositoryRegistrationAotProcessor::isInSpringDataNamespace));
    }

    protected void contributeType(Class<?> type, GenerationContext generationContext) {
        TypeContributor.contribute(type, it -> true, generationContext);
    }

    private static boolean isInSpringDataNamespace(Class<?> type) {
        return type.getPackage().getName().startsWith("org.springframework.data");
    }
}

