/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.upgrade;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.ApplicationReferenceUpgrade;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.plugin.upgrade.LayoutApplicationReferenceUpgradePlugin$AjcClosure1;
import io.meeds.layout.service.PortletInstanceService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LayoutApplicationReferenceUpgradePlugin
extends UpgradeProductPlugin {
    private static final String ENABLED_PARAM = "enabled";
    private static final Log LOG;
    private CacheService cacheService;
    private PortletInstanceService portletInstanceService;
    private WindowDAO windowDAO;
    private List<ApplicationReferenceUpgrade> upgrades;
    private boolean enabled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public LayoutApplicationReferenceUpgradePlugin(CacheService cacheService, SettingService settingService, PortletInstanceService portletInstanceService, WindowDAO windowDAO, InitParams initParams) {
        super(settingService, initParams);
        this.portletInstanceService = portletInstanceService;
        this.windowDAO = windowDAO;
        this.cacheService = cacheService;
        this.upgrades = initParams.getObjectParamValues(ApplicationReferenceUpgrade.class);
        this.enabled = !initParams.containsKey((Object)ENABLED_PARAM) || Boolean.parseBoolean(initParams.getValueParam(ENABLED_PARAM).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long start = System.currentTimeMillis();
        LOG.info("Start:: Upgrade Application ContentId {}", new Object[]{this.getName()});
        try {
            this.upgradeApplications();
            LOG.info("End:: Upgrade Application ContentId {} in {} ms", new Object[]{this.getName(), System.currentTimeMillis() - start});
        }
        finally {
            this.cacheService.getCacheInstance("portal.PortletPreferences").clearCache();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return this.enabled && CollectionUtils.isNotEmpty(this.upgrades);
    }

    @ContainerTransactional
    public void upgradeApplications() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        LayoutApplicationReferenceUpgradePlugin$AjcClosure1 layoutApplicationReferenceUpgradePlugin$AjcClosure1 = new LayoutApplicationReferenceUpgradePlugin$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(layoutApplicationReferenceUpgradePlugin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        LayoutApplicationReferenceUpgradePlugin.ajc$preClinit();
        LOG = ExoLogger.getLogger(LayoutApplicationReferenceUpgradePlugin.class);
    }

    static final /* synthetic */ void upgradeApplications_aroundBody0(LayoutApplicationReferenceUpgradePlugin ajc$this, JoinPoint joinPoint) {
        List<PortletInstance> portletInstances = ajc$this.portletInstanceService.getPortletInstances();
        for (ApplicationReferenceUpgrade applicationModification : ajc$this.upgrades) {
            String oldContentId = applicationModification.getOldContentId();
            String newContentId = applicationModification.getNewContentId();
            int modifiedLines = 0;
            if (applicationModification.isModification()) {
                if (applicationModification.isUpgradePages()) {
                    modifiedLines = ajc$this.windowDAO.updateContentId(oldContentId, newContentId);
                }
                if (applicationModification.isUpgradePortletInstance() && (portletInstance = (PortletInstance)portletInstances.stream().filter(p -> StringUtils.equals((CharSequence)oldContentId, (CharSequence)p.getContentId())).findFirst().orElse(null)) != null) {
                    portletInstance.setContentId(newContentId);
                    ajc$this.portletInstanceService.updatePortletInstance(portletInstance);
                }
            } else if (applicationModification.isRemoval()) {
                if (applicationModification.isUpgradePages()) {
                    modifiedLines = ajc$this.windowDAO.deleteByContentId(oldContentId);
                }
                if (applicationModification.isUpgradePortletInstance() && (portletInstance = (PortletInstance)portletInstances.stream().filter(p -> StringUtils.equals((CharSequence)oldContentId, (CharSequence)p.getContentId())).findFirst().orElse(null)) != null) {
                    ajc$this.portletInstanceService.deletePortletInstance(portletInstance.getId());
                }
            }
            if (modifiedLines <= 0) continue;
            LOG.info("| -- UPDATE::Application Reference: {} items migrated from '{}' to '{}' successfully", new Object[]{modifiedLines, oldContentId, newContentId});
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LayoutApplicationReferenceUpgradePlugin.java", LayoutApplicationReferenceUpgradePlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "upgradeApplications", "io.meeds.layout.plugin.upgrade.LayoutApplicationReferenceUpgradePlugin", "", "", "", "void"), 92);
    }
}

