/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractFunction;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.List;

class Escape
extends AbstractFunction {
    Escape() {
    }

    @Override
    public Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression parameter;
        if (parameters.size() > 1) {
            problemsHandler.wrongNumberOfArgumentsToFunctionMax(call.getParameter(), call.getName(), 1);
        }
        if ((parameter = parameters.get(0)).getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.evaluate((CssString)parameter);
        }
        if (parameter.getType() == ASTCssNodeType.ESCAPED_VALUE) {
            return this.evaluate((EscapedValue)parameter);
        }
        problemsHandler.warnEscapeFunctionArgument(call.getParameter());
        if (parameter.getType() == ASTCssNodeType.COLOR_EXPRESSION) {
            return this.evaluate((ColorExpression)parameter);
        }
        return call.getParameter();
    }

    private Expression evaluate(ColorExpression parameters) {
        return new CssString(parameters.getUnderlyingStructure(), "undefined", "");
    }

    private CssString evaluate(EscapedValue parameters) {
        String newValue = PrintUtils.toUtf8ExceptURL(parameters.getValue());
        return new CssString(parameters.getUnderlyingStructure(), newValue, "");
    }

    private CssString evaluate(CssString parameters) {
        String newValue = PrintUtils.toUtf8ExceptURL(parameters.getValue());
        return new CssString(parameters.getUnderlyingStructure(), newValue, "");
    }
}

