/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sequence;

import org.hibernate.MappingException;
import org.hibernate.dialect.sequence.SequenceSupport;

public class TiDBSequenceSupport
implements SequenceSupport {
    public static final SequenceSupport INSTANCE = new TiDBSequenceSupport();

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return "nextval(" + sequenceName + ")";
    }

    @Override
    public String getSelectSequencePreviousValString(String sequenceName) throws MappingException {
        return "lastval(" + sequenceName + ")";
    }

    @Override
    public boolean sometimesNeedsStartingValue() {
        return true;
    }

    @Override
    public String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        return this.getCreateSequenceString(sequenceName) + " start with " + initialValue + " increment by " + incrementSize + this.startingValue(initialValue, incrementSize);
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }
}

