/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.plugin.attachment;

import io.meeds.social.space.template.service.SpaceTemplateService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SpaceTemplateBannerAttachmentPlugin
extends AttachmentPlugin {
    public static final String OBJECT_TYPE = "spaceTemplateBanner";
    @Autowired
    protected SpaceTemplateService spaceTemplateService;
    @Autowired
    protected AttachmentService attachmentService;

    @PostConstruct
    public void init() {
        this.attachmentService.addPlugin((AttachmentPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        if (userIdentity == null) {
            return false;
        }
        return this.spaceTemplateService.canManageTemplates(userIdentity.getUserId());
    }

    public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        if (entityId == null || userIdentity == null) {
            return false;
        }
        long templateId = Long.parseLong(entityId);
        String username = userIdentity.getUserId();
        if (this.spaceTemplateService.getSpaceTemplate(templateId) == null) {
            throw new ObjectNotFoundException(String.format("Space Template with id %s not found", templateId));
        }
        return this.spaceTemplateService.canViewTemplate(templateId, username);
    }

    public long getAudienceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }
}

