/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.event.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;

public class EventManagerImpl<S, D>
extends ListenerService
implements EventManager<S, D> {
    private Map<String, List<ListenerBase<S, D>>> listenerMap = new HashMap<String, List<ListenerBase<S, D>>>();
    private static final Log LOG = ExoLogger.getLogger(EventManagerImpl.class);

    public EventManagerImpl(ExoContainerContext ctx, InitParams params) {
        super(ctx, params);
    }

    public EventManagerImpl(ExoContainerContext ctx, InitialContextInitializer initializer, InitParams params) {
        super(ctx, initializer, params);
    }

    @Override
    public void addEventListener(Listener<S, D> listener) {
        this.addEventListener(listener.getName(), (ListenerBase<S, D>)listener);
    }

    @Override
    public void addEventListener(String eventName, ListenerBase<S, D> listener) {
        Class listenerClass = listener.getClass();
        do {
            if (!listenerClass.isAnnotationPresent(Asynchronous.class)) continue;
            listener = new ListenerService.AsynchronousListener((ListenerService)this, listener);
            break;
        } while ((listenerClass = listenerClass.getSuperclass()) != null);
        List<ListenerBase<S, D>> list = this.listenerMap.get(eventName);
        if (list == null) {
            list = new ArrayList<ListenerBase<S, D>>();
        }
        list.add((ListenerBase<S, D>)listener);
        this.listenerMap.put(eventName, list);
    }

    @Override
    public void removeEventListener(Listener<S, D> listener) {
        this.removeEventListener(listener.getName(), (ListenerBase<S, D>)listener);
    }

    @Override
    public void removeEventListener(String eventName, ListenerBase<S, D> listener) {
        List<ListenerBase<S, D>> listeners = this.getEventListeners(eventName);
        listeners.remove(listener);
        if (listeners.size() == 0) {
            this.listenerMap.remove(eventName);
        }
        this.listenerMap.put(eventName, listeners);
    }

    @Override
    public void broadcastEvent(Event<S, D> event) {
        List<ListenerBase<S, D>> listeners = this.getEventListeners(event.getEventName());
        if (listeners.size() == 0) {
            return;
        }
        for (ListenerBase<S, D> listener : listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on broadcasting events occures: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public List<ListenerBase<S, D>> getEventListeners(String type) {
        if (!this.listenerMap.containsKey(type)) {
            return new ArrayList<ListenerBase<S, D>>();
        }
        return this.listenerMap.get(type);
    }
}

