/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.service;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.utils.Utils;
import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.model.DistributionForecast;
import io.meeds.wallet.model.RewardBudgetType;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.model.RewardStatus;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.model.WalletRewardPeriodSummary;
import io.meeds.wallet.model.WalletRewardStatus;
import io.meeds.wallet.model.WalletType;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.reward.service.WalletRewardReportService$AjcClosure1;
import io.meeds.wallet.reward.service.WalletRewardReportService$AjcClosure3;
import io.meeds.wallet.reward.storage.WalletRewardReportStorage;
import io.meeds.wallet.service.WalletAccountService;
import io.meeds.wallet.service.WalletTokenAdminService;
import io.meeds.wallet.utils.RewardUtils;
import io.meeds.wallet.utils.WalletUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.identity.model.Identity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WalletRewardReportService
implements RewardReportService {
    private static final Log LOG;
    private static final String EMPTY_SETTINGS = "Error computing rewards using empty settings";
    private static final String[] COLUMNS;
    private static final String SHEET_NAME = "reward-detail";
    private WalletAccountService walletAccountService;
    private WalletTokenAdminService walletTokenAdminService;
    private RewardSettingsService rewardSettingsService;
    private WalletRewardReportStorage rewardReportStorage;
    private RealizationService realizationService;
    private ResourceBundleService resourceBundleService;
    private boolean rewardSendingInProgress;
    public Map<Long, Boolean> rewardSettingChanged = new ConcurrentHashMap<Long, Boolean>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public WalletRewardReportService(WalletAccountService walletAccountService, WalletTokenAdminService walletTokenAdminService, RewardSettingsService rewardSettingsService, WalletRewardReportStorage rewardReportStorage, RealizationService realizationService, ResourceBundleService resourceBundleService) {
        this.walletAccountService = walletAccountService;
        this.walletTokenAdminService = walletTokenAdminService;
        this.rewardSettingsService = rewardSettingsService;
        this.rewardReportStorage = rewardReportStorage;
        this.realizationService = realizationService;
        this.resourceBundleService = resourceBundleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRewards(LocalDate date, String username) throws IllegalAccessException {
        if (!WalletUtils.isUserRewardingAdmin((String)username)) {
            throw new IllegalAccessException("User " + username + " is not allowed to send rewards");
        }
        RewardReport rewardReport = this.computeRewards(date);
        if (rewardReport.getPeriod().getEndDateInSeconds() > System.currentTimeMillis() / 1000L) {
            throw new IllegalStateException("Can't send rewards for current period");
        }
        if (rewardReport.getRewards() == null || rewardReport.getRewards().isEmpty()) {
            return;
        }
        if (rewardReport.getPendingTransactionCount() > 0L) {
            String startDateFormatted = rewardReport.getPeriod().getStartDateFormatted(Locale.getDefault().getLanguage());
            String endDateFormatted = rewardReport.getPeriod().getEndDateFormatted(Locale.getDefault().getLanguage());
            throw new IllegalStateException("There are some pending transactions for rewards of period between " + startDateFormatted + " and " + endDateFormatted + ", thus no reward sending is allowed until the transactions finishes");
        }
        String adminWalletAddress = this.getTokenAdminService().getAdminWalletAddress();
        if (StringUtils.isBlank((CharSequence)adminWalletAddress)) {
            throw new IllegalStateException("No admin wallet is configured");
        }
        HashSet rewards = new HashSet(rewardReport.getRewards());
        Iterator rewardedWalletsIterator = rewards.iterator();
        while (rewardedWalletsIterator.hasNext()) {
            WalletReward walletReward = (WalletReward)rewardedWalletsIterator.next();
            if (walletReward == null || !walletReward.isEnabled() || walletReward.getAmount() == 0.0 || walletReward.getTransaction() != null && (walletReward.getTransaction().isPending() || walletReward.getTransaction().isSucceeded())) {
                rewardedWalletsIterator.remove();
                continue;
            }
            if (walletReward.getAmount() < 0.0) {
                throw new IllegalStateException("Can't send reward transaction for wallet of " + walletReward.getWallet().getType() + " " + walletReward.getWallet().getId() + " with a negative amount" + walletReward.getAmount());
            }
            if (!StringUtils.equals((CharSequence)walletReward.getStatus(), (CharSequence)"success") && !StringUtils.equals((CharSequence)walletReward.getStatus(), (CharSequence)"pending")) continue;
            rewardedWalletsIterator.remove();
        }
        if (rewards.isEmpty()) {
            throw new IllegalStateException("No rewards to send for selected period");
        }
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        BigInteger adminTokenBalance = this.getTokenAdminService().getTokenBalanceOf(adminWalletAddress);
        double adminBalance = WalletUtils.convertFromDecimals((BigInteger)adminTokenBalance, (int)contractDetail.getDecimals());
        double rewardsAmount = rewardReport.getRemainingTokensToSend();
        if (rewardsAmount > adminBalance) {
            throw new IllegalStateException("Admin doesn't have enough funds to send rewards");
        }
        RewardPeriod rewardPeriod = rewardReport.getPeriod();
        for (WalletReward walletReward : rewards) {
            try {
                TransactionDetail transactionDetail = new TransactionDetail();
                transactionDetail.setFrom(adminWalletAddress);
                transactionDetail.setTo(walletReward.getWallet().getAddress());
                transactionDetail.setContractAmount(walletReward.getAmount());
                transactionDetail.setValue(walletReward.getAmount());
                String transactionLabel = this.getTransactionLabel(walletReward, contractDetail, rewardPeriod);
                transactionDetail.setLabel(transactionLabel);
                String transactionMessage = this.getTransactionMessage(walletReward, contractDetail, rewardPeriod);
                transactionDetail.setMessage(transactionMessage);
                walletReward.setTransaction(transactionDetail);
                this.getTokenAdminService().reward(transactionDetail, username);
            }
            catch (Exception e) {
                LOG.warn("Error while sending reward transaction for user '{}'", new Object[]{walletReward.getWallet().getName(), e});
            }
        }
        this.rewardSendingInProgress = true;
        try {
            this.rewardReportStorage.saveRewardReport(rewardReport);
        }
        finally {
            this.rewardSendingInProgress = false;
        }
    }

    public boolean isRewardSendingInProgress() {
        return this.rewardSendingInProgress;
    }

    @ExoTransactional
    public WalletRewardPeriodSummary getReport(RewardPeriod rewardPeriod) {
        RewardPeriod rewardPeriod2 = rewardPeriod;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)rewardPeriod2);
        Object[] objectArray = new Object[]{this, rewardPeriod2, joinPoint};
        WalletRewardReportService$AjcClosure1 walletRewardReportService$AjcClosure1 = new WalletRewardReportService$AjcClosure1(objectArray);
        return (WalletRewardPeriodSummary)ExoTransactionalAspect.aspectOf().around(walletRewardReportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public RewardReport computeRewards(LocalDate date) {
        LocalDate localDate = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)localDate);
        Object[] objectArray = new Object[]{this, localDate, joinPoint};
        WalletRewardReportService$AjcClosure3 walletRewardReportService$AjcClosure3 = new WalletRewardReportService$AjcClosure3(objectArray);
        return (RewardReport)ExoTransactionalAspect.aspectOf().around(walletRewardReportService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public RewardReport computeRewardsByUser(LocalDate date, long userIdentityId) {
        RewardReport rewardReport = this.computeRewards(date);
        Set rewards = rewardReport.getRewards().stream().filter(reward -> reward.getIdentityId() == userIdentityId).collect(Collectors.toSet());
        rewardReport.setRewards(rewards);
        return rewardReport;
    }

    public RewardReport getRewardReportByPeriodId(long periodId) {
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        return this.rewardReportStorage.getRewardReportByPeriodId(periodId, rewardSettings.zoneId());
    }

    public RewardReport getRewardReport(LocalDate date) {
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        if (rewardSettings == null) {
            throw new IllegalStateException(EMPTY_SETTINGS);
        }
        if (rewardSettings.getPeriodType() == null) {
            throw new IllegalStateException("Error computing rewards using empty period type");
        }
        return this.rewardReportStorage.getRewardReport(rewardSettings.getPeriodType(), date, rewardSettings.zoneId());
    }

    public RewardPeriod getRewardPeriod(RewardPeriodType periodType, LocalDate date) {
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        return this.rewardReportStorage.getRewardPeriod(periodType, date, rewardSettings.zoneId());
    }

    public RewardPeriod getRewardPeriodById(long rewardPeriodId) {
        return this.rewardReportStorage.getRewardPeriodById(rewardPeriodId);
    }

    public void saveRewardReport(RewardReport rewardReport) {
        if (rewardReport == null) {
            throw new IllegalArgumentException("Reward report to save is null");
        }
        this.rewardReportStorage.saveRewardReport(rewardReport);
    }

    public DistributionForecast computeDistributionForecast(RewardSettings rewardSettings) {
        RewardPeriod rewardPeriod = RewardPeriod.getCurrentPeriod((RewardSettings)rewardSettings);
        Date start = new Date(rewardPeriod.getStartDateInSeconds() * 1000L);
        Date end = new Date(rewardPeriod.getEndDateInSeconds() * 1000L);
        RealizationFilter realizationFilter = new RealizationFilter();
        realizationFilter.setEarnerType(IdentityType.USER);
        realizationFilter.setFromDate(start);
        realizationFilter.setToDate(end);
        List participants = this.realizationService.getParticipantsBetweenDates(start, end);
        Set wallets = this.walletAccountService.listWalletsByIdentityIds(participants).stream().filter(Wallet::isEnabled).collect(Collectors.toSet());
        Map<Long, Double> earnedPoints = this.getEarnedPoints(wallets.stream().map(Wallet::getTechnicalId).collect(Collectors.toSet()), rewardPeriod.getStartDateInSeconds(), rewardPeriod.getEndDateInSeconds());
        double acceptedContributions = earnedPoints.values().stream().mapToDouble(Double::doubleValue).sum();
        earnedPoints.entrySet().removeIf(entry -> (Double)entry.getValue() < rewardSettings.getThreshold());
        double totalBudget = rewardSettings.getAmount();
        if (RewardBudgetType.FIXED_PER_MEMBER.equals((Object)rewardSettings.getBudgetType())) {
            double totalEligibleMembersCount = earnedPoints.size();
            totalBudget = rewardSettings.getAmount() * totalEligibleMembersCount;
        }
        DistributionForecast distributionForecast = new DistributionForecast();
        distributionForecast.setBudget(totalBudget);
        distributionForecast.setAcceptedContributions(acceptedContributions);
        distributionForecast.setParticipantsCount(participants.size());
        distributionForecast.setEligibleContributorsCount(earnedPoints.size());
        return distributionForecast;
    }

    public Page<RewardPeriod> findRewardReportPeriods(Pageable pageable) {
        return this.rewardReportStorage.findRewardReportPeriods(pageable);
    }

    public Page<RewardPeriod> findRewardPeriodsBetween(long from, long to, Pageable pageable) {
        return this.rewardReportStorage.findRewardPeriodsBetween(from, to, pageable);
    }

    public Page<RewardPeriod> findRewardReportPeriods(String currentUser, Pageable pageable) throws IllegalAccessException {
        if (!this.realizationService.isRealizationManager(currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access reward periods ");
        }
        return this.rewardReportStorage.findRewardReportPeriods(pageable);
    }

    public Page<RewardPeriod> findRewardPeriodsBetween(String currentUser, long from, long to, Pageable pageable) throws IllegalAccessException {
        if (!this.realizationService.isRealizationManager(currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access reward periods ");
        }
        return this.rewardReportStorage.findRewardPeriodsBetween(from, to, pageable);
    }

    public List<RewardPeriod> getRewardPeriodsInProgress() {
        return this.rewardReportStorage.findRewardPeriodsByStatus(RewardStatus.PENDING);
    }

    public List<RewardPeriod> getRewardPeriodsNotSent() {
        return this.rewardReportStorage.findRewardPeriodsByStatus(RewardStatus.ESTIMATION);
    }

    public List<WalletReward> listRewards(String currentUser, int limit) {
        Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)currentUser);
        if (identity == null) {
            return Collections.emptyList();
        }
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        return this.rewardReportStorage.listRewards(Long.parseLong(identity.getId()), rewardSettings.zoneId(), limit);
    }

    public double countRewards(String currentUser) {
        Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)currentUser);
        if (identity == null) {
            throw new IllegalArgumentException("can't get user");
        }
        return this.rewardReportStorage.countRewards(Long.parseLong(identity.getId()));
    }

    public void replaceRewardTransactions(String oldHash, String newHash) {
        this.rewardReportStorage.replaceRewardTransactions(oldHash, newHash);
    }

    public Page<WalletReward> findWalletRewardsByPeriodIdAndStatus(long periodId, List<Long> identityIds, WalletRewardStatus walletRewardStatus, ZoneId zoneId, Pageable pageable) {
        if (identityIds == null || identityIds.isEmpty()) {
            return this.rewardReportStorage.findWalletRewardsByPeriodId(periodId, zoneId, walletRewardStatus, pageable);
        }
        return this.rewardReportStorage.findWalletRewardsByPeriodIdAndIdentityIds(periodId, identityIds, zoneId, walletRewardStatus, pageable);
    }

    public InputStream exportXlsx(long periodId, WalletRewardStatus walletRewardStatus, ZoneId zoneId, String fileName, Locale locale) {
        File temp = null;
        try {
            temp = this.createTempFile(fileName);
            Page<WalletReward> walletRewardPage = this.rewardReportStorage.findWalletRewardsByPeriodId(periodId, zoneId, walletRewardStatus, null);
            try (XSSFWorkbook workbook = new XSSFWorkbook();
                 FileOutputStream outputStream = new FileOutputStream(temp);){
                int rowIndex = 0;
                XSSFCreationHelper helper = workbook.getCreationHelper();
                XSSFSheet sheet = workbook.createSheet(SHEET_NAME);
                this.appendRewardsHeaderRow((Sheet)sheet, rowIndex++, (CreationHelper)helper, locale);
                for (WalletReward walletReward : walletRewardPage.getContent()) {
                    this.appendWalletRewardRow((Sheet)sheet, rowIndex++, (CreationHelper)helper, walletReward);
                }
                workbook.write((OutputStream)outputStream);
            }
            FileInputStream fileInputStream = new FileInputStream(temp);
            return fileInputStream;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error exporting XLSX file for wallet rewards ", e);
        }
        finally {
            if (temp != null && temp.exists()) {
                temp.deleteOnExit();
            }
        }
    }

    public double countWalletRewardsPointsByPeriodIdAndStatus(long periodId, boolean isValid) {
        return this.rewardReportStorage.countWalletRewardsPointsByPeriodIdAndStatus(periodId, isValid);
    }

    public void setRewardSettingChanged(Map<Long, Boolean> updatedSettings) {
        this.rewardSettingChanged.putAll(updatedSettings);
    }

    private WalletRewardPeriodSummary handleExistingRewardPeriod(RewardPeriod storedRewardPeriod) {
        WalletRewardPeriodSummary summary = this.rewardReportStorage.findWalletRewardPeriodSummaryByRewardPeriodId(storedRewardPeriod.getId());
        if (storedRewardPeriod.getId() > 0L && Boolean.TRUE.equals(this.getRewardSettingChanged().get(storedRewardPeriod.getId()))) {
            RewardReport rewardReport = this.computeAndSaveRewards(storedRewardPeriod);
            return this.updateSummaryWithReport(storedRewardPeriod, rewardReport);
        }
        if (summary == null) {
            RewardReport rewardReport = this.computeRewards(storedRewardPeriod.getPeriodMedianDate());
            return this.updateSummaryWithReport(storedRewardPeriod, rewardReport);
        }
        if (RewardStatus.SUCCESS.equals((Object)storedRewardPeriod.getStatus()) && (!summary.isCompletelyProcessed() || summary.getSentDate() == 0L)) {
            RewardReport rewardReport = this.computeRewards(storedRewardPeriod.getPeriodMedianDate());
            summary = this.buildAndSaveSummary(rewardReport, storedRewardPeriod);
            this.rewardReportStorage.createOrUpdateSummary(summary);
        }
        return summary;
    }

    private WalletRewardPeriodSummary handleNewRewardPeriod(RewardPeriod rewardPeriod) {
        Date end;
        Date start = new Date(rewardPeriod.getStartDateInSeconds() * 1000L);
        long participantsCount = this.realizationService.countParticipantsBetweenDates(start, end = new Date(rewardPeriod.getEndDateInSeconds() * 1000L));
        if (participantsCount > 0L) {
            RewardReport rewardReport = this.computeAndSaveRewards(rewardPeriod);
            rewardPeriod = this.getRewardPeriod(rewardPeriod.getRewardPeriodType(), rewardPeriod.getPeriodMedianDate());
            rewardReport.setPeriod(rewardPeriod);
            return this.buildAndSaveSummary(rewardReport, rewardPeriod);
        }
        WalletRewardPeriodSummary summary = new WalletRewardPeriodSummary();
        summary.setPeriod(rewardPeriod);
        return summary;
    }

    private RewardReport computeAndSaveRewards(RewardPeriod rewardPeriod) {
        RewardReport rewardReport = this.computeRewards(rewardPeriod.getPeriodMedianDate());
        if (!rewardReport.isCompletelyProcessed()) {
            this.saveRewardReport(rewardReport);
        }
        return rewardReport;
    }

    private WalletRewardPeriodSummary updateSummaryWithReport(RewardPeriod storedRewardPeriod, RewardReport rewardReport) {
        WalletRewardPeriodSummary summary = this.buildReportStatus(rewardReport, storedRewardPeriod);
        Map<Long, Boolean> rewardSettingChangedMap = this.getRewardSettingChanged();
        rewardSettingChangedMap.put(storedRewardPeriod.getId(), false);
        this.setRewardSettingChanged(rewardSettingChangedMap);
        return this.rewardReportStorage.createOrUpdateSummary(summary);
    }

    private WalletRewardPeriodSummary buildAndSaveSummary(RewardReport rewardReport, RewardPeriod rewardPeriod) {
        WalletRewardPeriodSummary summary = this.buildReportStatus(rewardReport, rewardPeriod);
        return this.rewardReportStorage.createOrUpdateSummary(summary);
    }

    private File createTempFile(String fileName) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd_HH-mm-ss");
        fileName = (String)fileName + formatter.format(new Date());
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> tempFileAttributes = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
            return Files.createTempFile((String)fileName, ".xlsx", tempFileAttributes).toFile();
        }
        File temp = Files.createTempFile((String)fileName, ".xlsx", new FileAttribute[0]).toFile();
        if (!temp.setReadable(true, true) || !temp.setWritable(true, true)) {
            throw new IllegalStateException("Can't write a temp file to export XLS achievements file");
        }
        return temp;
    }

    private void appendRewardsHeaderRow(Sheet sheet, int rowIndex, CreationHelper helper, Locale locale) {
        Row row = sheet.createRow(rowIndex);
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.addon.Wallet", locale);
        for (int i = 0; i < COLUMNS.length; ++i) {
            row.createCell(i).setCellValue(helper.createRichTextString(resourceBundle.getString("wallet.administration.rewardDetails.label." + COLUMNS[i])));
        }
    }

    private void appendWalletRewardRow(Sheet sheet, int rowIndex, CreationHelper helper, WalletReward walletReward) {
        Row row = sheet.createRow(rowIndex);
        try {
            int cellIndex = 0;
            row.createCell(cellIndex++).setCellValue(Utils.getUserFullName((String)String.valueOf(walletReward.getIdentityId())));
            row.createCell(cellIndex++).setCellValue(walletReward.getWallet().getAddress());
            row.createCell(cellIndex++).setCellValue(walletReward.getPoints());
            double amount = walletReward.getAmount();
            String amountText = amount % 1.0 == 0.0 ? String.format("MEED %.0f", amount) : String.format("MEED %.2f", amount);
            row.createCell(cellIndex++).setCellValue(amountText);
            row.createCell(cellIndex++).setCellValue(walletReward.getStatus());
            this.appendTransactionCells(row, cellIndex, helper, walletReward.getTransaction());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when computing to XLSX ", (Throwable)e);
        }
    }

    private void appendTransactionCells(Row row, int cellIndex, CreationHelper helper, TransactionDetail transaction) {
        if (transaction != null) {
            row.createCell(cellIndex++).setCellValue(helper.createRichTextString(String.valueOf(new Date(transaction.getSentTimestamp()))));
            Cell hashCell = row.createCell(cellIndex);
            String hashUrl = WalletUtils.getTransactionEtherScanLink() + transaction.getHash();
            hashCell.setCellValue(transaction.getHash());
            Hyperlink link = helper.createHyperlink(HyperlinkType.URL);
            link.setAddress(hashUrl);
            hashCell.setHyperlink(link);
        }
    }

    private RewardPeriod getRewardPeriod(LocalDate date) {
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        RewardPeriodType periodType = rewardSettings.getPeriodType();
        return periodType.getPeriodOfTime(date, rewardSettings.zoneId());
    }

    private void computeRewardDetails(RewardReport rewardReport, Set<Wallet> wallets) {
        RewardPeriod period = rewardReport.getPeriod();
        Set<WalletReward> walletRewards = this.retrieveWalletRewards(rewardReport, wallets);
        Set<WalletReward> enabledRewards = walletRewards.stream().filter(WalletReward::isEnabled).collect(Collectors.toSet());
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        Set<Long> identityIds = walletRewards.stream().map(WalletReward::getIdentityId).collect(Collectors.toSet());
        Map<Long, Double> earnedPoints = this.getEarnedPoints(identityIds, period.getStartDateInSeconds(), period.getEndDateInSeconds());
        this.computeReward(rewardSettings, earnedPoints, enabledRewards);
        rewardReport.setRewards(enabledRewards);
    }

    private Map<Long, Double> getEarnedPoints(Set<Long> identityIds, long startDateInSeconds, long endDateInSeconds) {
        HashMap<Long, Double> earnedPoints = new HashMap<Long, Double>();
        if (identityIds == null || identityIds.isEmpty()) {
            return earnedPoints;
        }
        Date startDate = new Date(startDateInSeconds * 1000L);
        Date endDate = new Date(endDateInSeconds * 1000L);
        Map points = new HashMap();
        try {
            points = this.realizationService.getScoresByIdentityIdsAndBetweenDates(identityIds.stream().map(Object::toString).toList(), startDate, endDate);
        }
        catch (Exception e) {
            LOG.warn("Error getting points for user with ids {}", new Object[]{identityIds, e});
        }
        return points.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Long)entry.getValue()).doubleValue()));
    }

    private Set<WalletReward> retrieveWalletRewards(RewardReport rewardReport, Set<Wallet> wallets) {
        HashSet<WalletReward> walletRewards = rewardReport.getRewards();
        if (walletRewards == null) {
            walletRewards = new HashSet<WalletReward>();
            rewardReport.setRewards(walletRewards);
        }
        for (Wallet wallet : wallets) {
            List<WalletReward> walletRewardList = walletRewards.stream().filter(wr -> wallet != null && wr.getWallet() != null && wr.getIdentityId() == wallet.getTechnicalId()).toList();
            WalletReward walletReward = walletRewardList.stream().filter(r -> r.getTransaction() != null).min((r2, r1) -> Double.compare(r1.getTokensSent(), r2.getTokensSent())).orElseGet(() -> walletRewardList.isEmpty() ? null : (WalletReward)walletRewardList.getFirst());
            if (walletReward == null) {
                walletReward = new WalletReward();
                walletRewards.add(walletReward);
            }
            walletReward.setWallet(wallet);
        }
        return walletRewards;
    }

    private void computeReward(RewardSettings rewardSettings, Map<Long, Double> earnedPoints, Set<WalletReward> enabledRewards) {
        RewardBudgetType budgetType = rewardSettings.getBudgetType();
        if (budgetType == null) {
            LOG.warn((Object)"Budget type of reward is empty, thus no computing is possible");
            return;
        }
        double configuredPluginAmount = rewardSettings.getAmount();
        if (configuredPluginAmount < 0.0) {
            throw new IllegalStateException("reward amount has a configured negative (" + configuredPluginAmount + ")");
        }
        this.filterEligibleMembers(earnedPoints.entrySet(), enabledRewards, rewardSettings);
        switch (budgetType) {
            case FIXED: {
                double totalFixedBudget = configuredPluginAmount;
                this.addTeamMembersReward(earnedPoints, totalFixedBudget, enabledRewards);
                break;
            }
            case FIXED_PER_MEMBER: {
                int totalEligibleMembersCount = earnedPoints.size();
                double totalFixedBudget = configuredPluginAmount * (double)totalEligibleMembersCount;
                this.addTeamMembersReward(earnedPoints, totalFixedBudget, enabledRewards);
                break;
            }
            default: {
                throw new IllegalStateException("Budget type is not recognized, budget type = " + String.valueOf(budgetType));
            }
        }
    }

    private void addTeamMembersReward(Map<Long, Double> earnedPoints, double totalFixedBudget, Set<WalletReward> enabledRewards) {
        if (totalFixedBudget <= 0.0) {
            return;
        }
        double totalPoints = earnedPoints.values().stream().mapToDouble(v -> v).sum();
        if (totalPoints <= 0.0) {
            return;
        }
        double amountPerPoint = totalFixedBudget / totalPoints;
        this.addRewardsSwitchPointAmount(enabledRewards, earnedPoints.entrySet(), amountPerPoint);
    }

    private void addRewardsSwitchPointAmount(Set<WalletReward> enabledRewards, Set<Map.Entry<Long, Double>> identitiesPointsEntries, double amountPerPoint) {
        Set identityIds = identitiesPointsEntries.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        WalletReward reward = enabledRewards.stream().filter(r -> r.getPeriod() != null).findFirst().orElse(null);
        RewardPeriod rewardPeriod = reward != null ? reward.getPeriod() : null;
        Date startDate = rewardPeriod != null ? new Date(rewardPeriod.getStartDateInSeconds() * 1000L) : null;
        Date endDate = rewardPeriod != null ? new Date(rewardPeriod.getEndDateInSeconds() * 1000L) : null;
        enabledRewards.removeIf(walletReward -> {
            long score;
            if (!identityIds.contains(walletReward.getIdentityId()) && reward != null && (score = this.realizationService.getScoreByIdentityIdAndBetweenDates(String.valueOf(walletReward.getWallet().getTechnicalId()), startDate, endDate)) == 0L) {
                this.rewardReportStorage.deleteRewardById(walletReward.getId());
                return true;
            }
            return false;
        });
        identitiesPointsEntries.forEach(entry -> {
            Long identityId = (Long)entry.getKey();
            Double points = (Double)entry.getValue();
            double amount = points * amountPerPoint;
            WalletReward walletReward = enabledRewards.stream().filter(r -> r.getIdentityId() == identityId.longValue()).findFirst().orElse(null);
            if (walletReward != null) {
                walletReward.setPoints(points.doubleValue());
                walletReward.setAmount(amount);
            }
        });
    }

    private void filterEligibleMembers(Set<Map.Entry<Long, Double>> identitiesPointsEntries, Set<WalletReward> enabledRewards, RewardSettings rewardSettings) {
        Set validIdentityIdsToUse = enabledRewards.stream().map(WalletReward::getIdentityId).collect(Collectors.toSet());
        double threshold = rewardSettings.getThreshold();
        Iterator<Map.Entry<Long, Double>> identitiesPointsIterator = identitiesPointsEntries.iterator();
        while (identitiesPointsIterator.hasNext()) {
            WalletReward walletReward;
            Map.Entry<Long, Double> entry = identitiesPointsIterator.next();
            Long identityId = entry.getKey();
            Double points = entry.getValue();
            points = points == null ? 0.0 : points;
            if (points < 0.0) {
                throw new IllegalStateException("Negative points has assigned (" + points + ") to user with id " + identityId);
            }
            if (!(points < threshold) && points != 0.0 && validIdentityIdsToUse.contains(identityId)) continue;
            identitiesPointsIterator.remove();
            if (!(points > 0.0) || (walletReward = (WalletReward)enabledRewards.stream().filter(enabledReward -> enabledReward.getIdentityId() == identityId.longValue()).findFirst().orElse(null)) == null) continue;
            walletReward.setPoints(points.doubleValue());
            walletReward.setAmount(0.0);
        }
    }

    private String getTransactionLabel(WalletReward walletReward, ContractDetail contractDetail, RewardPeriod periodOfTime) {
        Wallet wallet = walletReward.getWallet();
        Locale locale = WalletUtils.getLocale((Wallet)wallet);
        String label = WalletUtils.getResourceBundleKey((Locale)locale, (String)"exoplatform.wallet.label.rewardTransactionLabel");
        if (StringUtils.isBlank((CharSequence)label)) {
            return "";
        }
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        return label.replace("{0}", wallet.getName()).replace("{1}", WalletUtils.formatNumber((Object)walletReward.getAmount(), (String)locale.getLanguage())).replace("{2}", contractDetail.getSymbol()).replace("{3}", RewardUtils.formatTime((Object)periodOfTime.getStartDateInSeconds(), (ZoneId)rewardSettings.zoneId(), (String)locale.getLanguage())).replace("{4}", RewardUtils.formatTime((Object)(periodOfTime.getEndDateInSeconds() - 1L), (ZoneId)rewardSettings.zoneId(), (String)locale.getLanguage()));
    }

    private String getTransactionMessage(WalletReward walletReward, ContractDetail contractDetail, RewardPeriod periodOfTime) {
        StringBuilder transactionMessage = new StringBuilder();
        Locale locale = WalletUtils.getLocale((Wallet)walletReward.getWallet());
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        ZoneId zoneId = rewardSettings.zoneId();
        String label = WalletUtils.getResourceBundleKey((Locale)locale, (String)"exoplatform.wallet.label.rewardTransactionMessageNoPool");
        if (StringUtils.isBlank((CharSequence)label)) {
            return null;
        }
        String transactionMessagePart = label.replace("{0}", WalletUtils.formatNumber((Object)walletReward.getAmount(), (String)locale.getLanguage())).replace("{1}", contractDetail.getSymbol()).replace("{2}", WalletUtils.formatNumber((Object)walletReward.getPoints(), (String)locale.getLanguage())).replace("{4}", RewardUtils.formatTime((Object)periodOfTime.getStartDateInSeconds(), (ZoneId)zoneId, (String)locale.getLanguage())).replace("{5}", RewardUtils.formatTime((Object)(periodOfTime.getEndDateInSeconds() - 1L), (ZoneId)zoneId, (String)locale.getLanguage()));
        transactionMessage.append(transactionMessagePart);
        transactionMessage.append("\r\n");
        return transactionMessage.toString();
    }

    private WalletTokenAdminService getTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }

    private WalletRewardPeriodSummary buildReportStatus(RewardReport rewardReport, RewardPeriod rewardPeriod) {
        Date fromDate = new Date(rewardPeriod.getStartDateInSeconds() * 1000L);
        Date toDate = new Date(rewardPeriod.getEndDateInSeconds() * 1000L);
        long participantsCount = this.realizationService.countParticipantsBetweenDates(fromDate, toDate);
        RealizationFilter realizationFilter = new RealizationFilter();
        realizationFilter.setFromDate(fromDate);
        realizationFilter.setToDate(toDate);
        realizationFilter.setEarnerType(IdentityType.USER);
        realizationFilter.setStatuses(Collections.singletonList(RealizationStatus.ACCEPTED));
        int achievementsCount = this.realizationService.countRealizationsByFilter(realizationFilter);
        WalletReward succeededTransaction = rewardReport.getRewards().stream().filter(reward -> reward.getTransaction() != null && reward.getTransaction().isSucceeded()).findFirst().orElse(null);
        double points = rewardPeriod.getId() > 0L ? this.countWalletRewardsPointsByPeriodIdAndStatus(rewardPeriod.getId(), true) : 0.0;
        return new WalletRewardPeriodSummary(succeededTransaction != null ? succeededTransaction.getTransaction().getSentTimestamp() : 0L, rewardReport.getPeriod(), participantsCount, rewardReport.getValidRewardCount(), (long)achievementsCount, points, rewardReport.getTokensSent(), rewardReport.getTokensToSend(), CollectionUtils.isNotEmpty((Collection)rewardReport.getRewards()) && rewardReport.isCompletelyProcessed());
    }

    @Generated
    public void setRewardSendingInProgress(boolean rewardSendingInProgress) {
        this.rewardSendingInProgress = rewardSendingInProgress;
    }

    @Generated
    public Map<Long, Boolean> getRewardSettingChanged() {
        return this.rewardSettingChanged;
    }

    static {
        WalletRewardReportService.ajc$preClinit();
        LOG = ExoLogger.getLogger(WalletRewardReportService.class);
        COLUMNS = new String[]{"fullName", "address", "points", "rewards", "status", "sentDate", "transactionHash"};
    }

    static final /* synthetic */ WalletRewardPeriodSummary getReport_aroundBody0(WalletRewardReportService ajc$this, RewardPeriod rewardPeriod, JoinPoint joinPoint) {
        RewardPeriod storedRewardPeriod = ajc$this.getRewardPeriod(rewardPeriod.getRewardPeriodType(), rewardPeriod.getPeriodMedianDate());
        if (storedRewardPeriod != null) {
            return ajc$this.handleExistingRewardPeriod(storedRewardPeriod);
        }
        return ajc$this.handleNewRewardPeriod(rewardPeriod);
    }

    static final /* synthetic */ RewardReport computeRewards_aroundBody2(WalletRewardReportService ajc$this, LocalDate date, JoinPoint joinPoint) {
        if (date == null) {
            throw new IllegalArgumentException("date is mandatory");
        }
        RewardPeriod rewardPeriod = ajc$this.getRewardPeriod(date);
        Date start = new Date(rewardPeriod.getStartDateInSeconds() * 1000L);
        Date end = new Date(rewardPeriod.getEndDateInSeconds() * 1000L);
        RealizationFilter realizationFilter = new RealizationFilter();
        realizationFilter.setEarnerType(IdentityType.USER);
        realizationFilter.setFromDate(start);
        realizationFilter.setToDate(end);
        int participationsCount = ajc$this.realizationService.countRealizationsByFilter(realizationFilter);
        if (participationsCount == 0) {
            RewardReport rewardReport = new RewardReport();
            rewardReport.setPeriod(ajc$this.getRewardPeriod(date));
            rewardReport.setParticipationsCount(0);
            return rewardReport;
        }
        RewardReport rewardReport = ajc$this.getRewardReport(date);
        if (rewardReport == null) {
            rewardReport = new RewardReport();
            rewardReport.setPeriod(ajc$this.getRewardPeriod(date));
        }
        rewardReport.setParticipationsCount(ajc$this.realizationService.countRealizationsByFilter(realizationFilter));
        List participants = ajc$this.realizationService.getParticipantsBetweenDates(start, end);
        if (CollectionUtils.isNotEmpty((Collection)participants)) {
            Set wallets = ajc$this.walletAccountService.listWalletsByIdentityIds(participants);
            ajc$this.computeRewardDetails(rewardReport, wallets);
        } else {
            RewardPeriod period = ajc$this.getRewardPeriod(rewardPeriod.getRewardPeriodType(), date);
            ajc$this.rewardReportStorage.deleteRewardsByPeriodId(period.getId());
            rewardReport.setRewards(new HashSet());
        }
        return rewardReport;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WalletRewardReportService.java", WalletRewardReportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReport", "io.meeds.wallet.reward.service.WalletRewardReportService", "io.meeds.wallet.model.RewardPeriod", "rewardPeriod", "", "io.meeds.wallet.model.WalletRewardPeriodSummary"), 219);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeRewards", "io.meeds.wallet.reward.service.WalletRewardReportService", "java.time.LocalDate", "date", "", "io.meeds.wallet.model.RewardReport"), 230);
    }
}

