/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.DatabaseVersion;

public class SimpleDatabaseVersion
implements DatabaseVersion {
    public static final SimpleDatabaseVersion ZERO_VERSION = new SimpleDatabaseVersion(0, 0);
    private final int major;
    private final int minor;
    private final int micro;

    public SimpleDatabaseVersion(DatabaseVersion copySource) {
        this(copySource, true);
    }

    public SimpleDatabaseVersion(DatabaseVersion version, boolean noVersionAsZero) {
        this.major = version.getDatabaseMajorVersion();
        this.minor = version.getDatabaseMinorVersion() == -9999 ? (noVersionAsZero ? 0 : -9999) : version.getDatabaseMinorVersion();
        this.micro = version.getDatabaseMicroVersion() == -9999 ? (noVersionAsZero ? 0 : -9999) : version.getDatabaseMicroVersion();
    }

    public SimpleDatabaseVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public SimpleDatabaseVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public SimpleDatabaseVersion(Integer major, Integer minor) {
        if (major == null) {
            throw new IllegalArgumentException("Major version can not be null");
        }
        this.major = major;
        this.minor = minor == null ? -9999 : minor;
        this.micro = 0;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return this.major;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return this.minor;
    }

    @Override
    public int getDatabaseMicroVersion() {
        return this.micro;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getMicro() {
        return this.micro;
    }

    public String toString() {
        StringBuilder version = new StringBuilder();
        if (this.major != -9999) {
            version.append(this.major);
        }
        if (this.minor != -9999) {
            version.append(".");
            version.append(this.minor);
            if (this.micro > 0) {
                version.append(".");
                version.append(this.micro);
            }
        }
        return version.toString();
    }
}

