/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.rest;

import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.service.HubService;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"hub"})
@Tag(name="hub", description="An endpoint to manage current Hub as a WoM member")
public class HubController {
    @Autowired
    private HubService hubService;

    @GetMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Retrieves Deed NFT properties", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public Hub getHub(@Parameter(description="Whether to force Refresh the Hub characteristics from WoM or not", required=false) @RequestParam(name="forceRefresh", required=false) boolean forceRefresh) {
        HubTenant hub = this.hubService.getHub(forceRefresh);
        if (hub == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return hub;
    }

    @PostMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Connect current Hub to the WoM", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="503", description="Service Unavailable")})
    public WomConnectionResponse connectToWoM(@Parameter(description="WoM connection request data", required=true) @RequestBody WomConnectionRequest connectionRequest) {
        if (connectionRequest == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptyConnectionRequest");
        }
        if (connectionRequest.getDeedId() < 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptyDeedId");
        }
        if (connectionRequest.getDeedManagerAddress() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptyDeedManagerAddress");
        }
        if (connectionRequest.getSignedMessage() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptySignedMessage");
        }
        if (connectionRequest.getToken() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptyTokenForSignedMessage");
        }
        try {
            return this.hubService.connectToWoM(connectionRequest);
        }
        catch (WomException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @DeleteMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Disconnect current Hub from the WoM", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="503", description="Service Unavailable")})
    public void disconnectFromWoM(@Parameter(description="WoM disconnection request data", required=true) @RequestBody WomDisconnectionRequest disconnectionRequest) {
        if (disconnectionRequest == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptyConnectionRequest");
        }
        if (disconnectionRequest.getDeedManagerAddress() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptyDeedManagerAddress");
        }
        if (disconnectionRequest.getSignedMessage() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptySignedMessage");
        }
        if (disconnectionRequest.getToken() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "wom.emptyTokenForSignedMessage");
        }
        try {
            this.hubService.disconnectFromWom(disconnectionRequest);
        }
        catch (WomException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @GetMapping(value={"token"})
    @Secured(value={"rewarding"})
    @Operation(summary="Retrieves Deed NFT properties", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public String generateWoMToken() {
        try {
            return this.hubService.generateWomToken();
        }
        catch (WomException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @GetMapping(value={"manager"})
    @Secured(value={"rewarding"})
    @Operation(summary="Checks whether a wallet is the provisioning manager of a Deed or not", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public boolean isDeedManager(@Parameter(description="Wallet address", required=true) @RequestParam(value="address") String address, @Parameter(description="Deed NFT identifier", required=true) @RequestParam(value="nftId") long nftId) {
        try {
            return this.hubService.isDeedManager(address, nftId);
        }
        catch (WomException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }
}

