/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.service;

import io.meeds.wallet.blockchain.service.EthereumClientConnector;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.tx.gas.ContractGasProvider;

@Component
public class PolygonContractGasProvider
implements ContractGasProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PolygonContractGasProvider.class);
    private static final BigInteger GAS_LIMIT = BigInteger.valueOf(1000000L);
    @Autowired(required=false)
    private EthereumClientConnector clientConnector;
    private Web3j web3j;
    private long chainId;

    public BigInteger getGasPrice() {
        BigInteger gasPrice = ((EthGasPrice)this.getWeb3j().ethGasPrice().send()).getGasPrice();
        return new BigDecimal(gasPrice).multiply(BigDecimal.valueOf(1.2)).setScale(0, RoundingMode.HALF_EVEN).toBigInteger();
    }

    public BigInteger getGasPrice(String contractFunc) {
        return this.getGasPrice();
    }

    public BigInteger getGasLimit(String contractFunc) {
        return this.getGasLimit();
    }

    public BigInteger getGasLimit() {
        return GAS_LIMIT;
    }

    public long getChainId() {
        if (this.chainId == 0L) {
            try {
                this.chainId = ((EthChainId)this.getWeb3j().ethChainId().send()).getChainId().longValue();
            }
            catch (IOException e) {
                LOG.warn("Error retrieving Network Identifier", (Throwable)e);
                return 137L;
            }
        }
        return this.chainId;
    }

    public Web3j getWeb3j() {
        if (this.web3j == null) {
            this.web3j = this.clientConnector.getWeb3j(false);
        }
        return this.web3j;
    }
}

