/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.ide.model.Widget;
import jakarta.annotation.PostConstruct;
import org.apache.commons.collections.MapUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
@Profile(value={"layout"})
public class StaticResourcesAnalyticsListener
extends Listener<String, Widget> {
    private static final String STATISTICS_TYPE_PARAM = "type";
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("ide.widget.created", (ListenerBase)this);
    }

    public void onEvent(Event<String, Widget> event) {
        Widget widget = (Widget)event.getData();
        if (widget == null || MapUtils.isEmpty(widget.getProperties())) {
            return;
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule("layout");
        statisticData.setOperation("addStatisticResource");
        statisticData.setUserId(widget.getCreatorId().longValue());
        statisticData.addParameter("siteName", (Object)widget.getProperties().get("siteName"));
        statisticData.addParameter(STATISTICS_TYPE_PARAM, (Object)widget.getType());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

