/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.RepositoryBase;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVariant;
import co.elastic.clients.elasticsearch.snapshot.SourceOnlyRepositorySettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SourceOnlyRepository
extends RepositoryBase
implements RepositoryVariant {
    private final SourceOnlyRepositorySettings settings;
    public static final JsonpDeserializer<SourceOnlyRepository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceOnlyRepository::setupSourceOnlyRepositoryDeserializer);

    private SourceOnlyRepository(Builder builder) {
        super(builder);
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
    }

    public static SourceOnlyRepository of(Function<Builder, ObjectBuilder<SourceOnlyRepository>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Repository.Kind _repositoryKind() {
        return Repository.Kind.Source;
    }

    public final SourceOnlyRepositorySettings settings() {
        return this.settings;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "source");
        super.serializeInternal(generator, mapper);
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    protected static void setupSourceOnlyRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        RepositoryBase.setupRepositoryBaseDeserializer(op);
        op.add(Builder::settings, SourceOnlyRepositorySettings._DESERIALIZER, "settings");
        op.ignore("type");
    }

    public static class Builder
    extends RepositoryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SourceOnlyRepository> {
        private SourceOnlyRepositorySettings settings;

        public final Builder settings(SourceOnlyRepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<SourceOnlyRepositorySettings.Builder, ObjectBuilder<SourceOnlyRepositorySettings>> fn) {
            return this.settings(fn.apply(new SourceOnlyRepositorySettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SourceOnlyRepository build() {
            this._checkSingleUse();
            return new SourceOnlyRepository(this);
        }
    }
}

