/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Comparator;
import org.exoplatform.portal.config.model.PortalConfig;
import org.gatein.api.common.Sorting;
import org.gatein.api.page.Page;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteImpl;

class Comparators {
    Comparators() {
    }

    public static Comparator<PortalConfig> site(final Sorting<Site> sorting) {
        if (sorting == null) {
            return null;
        }
        if (sorting.getComparator() == null) {
            return new Comparator<PortalConfig>(){

                @Override
                public int compare(PortalConfig o1, PortalConfig o2) {
                    SiteImpl site = new SiteImpl(o1);
                    SiteImpl other = new SiteImpl(o2);
                    if (sorting.getOrder() == Sorting.Order.descending) {
                        SiteImpl tmp = site;
                        site = other;
                        other = tmp;
                    }
                    return site.compareTo(other);
                }
            };
        }
        return new ComparatorWrapper<Site, PortalConfig>(sorting.getComparator()){

            @Override
            protected Site from(PortalConfig entity) {
                return new SiteImpl(entity);
            }
        };
    }

    public static Comparator<Page> page(final Sorting<Page> sorting) {
        if (sorting == null) {
            return null;
        }
        if (sorting.getComparator() == null) {
            return new Comparator<Page>(){

                @Override
                public int compare(Page page, Page other) {
                    if (sorting.getOrder() == Sorting.Order.descending) {
                        Page tmp = page;
                        page = other;
                        other = tmp;
                    }
                    return page.compareTo((Object)other);
                }
            };
        }
        return sorting.getComparator();
    }

    private static abstract class ComparatorWrapper<T, F>
    implements Comparator<F> {
        private final Comparator<T> comparator;

        public ComparatorWrapper(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(F o1, F o2) {
            return this.comparator.compare(this.from(o1), this.from(o2));
        }

        protected abstract T from(F var1);
    }
}

