/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.listener;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.NavigationConfiguration;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NavigationConfigurationPageDisplayListener
implements ListenerBase<NavigationConfiguration, NavigationConfiguration> {
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private NavigationService navigationService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("social.navigation.configuration.updated", (ListenerBase)this);
    }

    public void onEvent(Event<NavigationConfiguration, NavigationConfiguration> event) throws Exception {
        NavigationConfiguration oldConfiguration = (NavigationConfiguration)event.getSource();
        NavigationConfiguration newConfiguration = (NavigationConfiguration)event.getData();
        List oldPages = oldConfiguration == null ? Collections.emptyList() : this.getPages(oldConfiguration);
        List<Page> pagesWithSharedLayout = this.getPages(newConfiguration);
        ArrayList<Page> pagesWithoutSharedLayout = new ArrayList<Page>(oldPages);
        pagesWithoutSharedLayout.removeAll(pagesWithSharedLayout);
        pagesWithoutSharedLayout.forEach(page -> {
            page.setShowSharedLayout(false);
            this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)));
        });
        pagesWithSharedLayout.forEach(page -> {
            page.setShowSharedLayout(true);
            this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)));
        });
    }

    private List<Page> getPages(NavigationConfiguration configuration) {
        return configuration.getSidebar().getItems().stream().filter(item -> item.getType() == SidebarItemType.PAGE).map(item -> {
            NodeData node;
            String nodeId = (String)item.getProperties().get("navigationNodeId");
            if (nodeId != null && (node = this.navigationService.getNodeById(Long.valueOf(Long.parseLong(nodeId)))) != null && node.getState().getPageRef() != null) {
                Page page = this.layoutService.getPage(node.getState().getPageRef());
                if (PageType.PAGE.name().equals(page.getType())) {
                    return page;
                }
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }
}

