/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.attachment;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.FileAttachmentObject;
import org.exoplatform.social.attachment.model.FileAttachmentResourceList;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.ObjectAttachmentOperationReport;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.attachment.storage.FileAttachmentStorage;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class AttachmentServiceImpl
implements AttachmentService {
    private static final Log LOG = ExoLogger.getLogger(AttachmentServiceImpl.class);
    private static final String ATTACHMENT_ALT_TEXT = "alt";
    private static final String ATTACHMENT_FORMAT = "format";
    private final Map<String, AttachmentPlugin> attachmentPlugins = new HashMap<String, AttachmentPlugin>();
    private FileAttachmentStorage attachmentStorage;
    private IdentityManager identityManager;
    private MetadataService metadataService;
    private UploadService uploadService;
    private ListenerService listenerService;

    public AttachmentServiceImpl(FileAttachmentStorage attachmentStorage, MetadataService metadataService, IdentityManager identityManager, UploadService uploadService, ListenerService listenerService) {
        this.attachmentStorage = attachmentStorage;
        this.metadataService = metadataService;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        this.listenerService = listenerService;
    }

    public void addPlugin(AttachmentPlugin attachmentPlugin) {
        this.attachmentPlugins.put(attachmentPlugin.getObjectType(), attachmentPlugin);
    }

    public Set<String> getSupportedObjectTypes() {
        return this.attachmentPlugins.keySet();
    }

    public Map<String, AttachmentPlugin> getAttachmentPlugins() {
        return this.attachmentPlugins;
    }

    public ObjectAttachmentOperationReport saveAttachments(FileAttachmentResourceList attachmentList, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        this.checkEditPermissions(attachmentList, userAclIdentity);
        if (!this.attachmentPlugins.get(attachmentList.getObjectType()).canUpdateAttachmentList()) {
            throw new IllegalStateException("Updating the attachment list is not allowed for object type: " + attachmentList.getObjectType());
        }
        return this.saveAttachments(attachmentList);
    }

    public ObjectAttachmentOperationReport saveAttachments(FileAttachmentResourceList attachmentList) {
        List<FileAttachmentObject> remainingFiles;
        long userIdentityId = attachmentList.getUserIdentityId();
        String username = this.getUserName(userIdentityId);
        String objectType = attachmentList.getObjectType();
        String objectId = attachmentList.getObjectId();
        MetadataObject metadataObject = new MetadataObject(objectType, objectId);
        List existingAttachments = this.metadataService.getMetadataItemsByMetadataTypeAndObject(AttachmentService.METADATA_TYPE.getName(), metadataObject);
        ObjectAttachmentOperationReport report = null;
        List<FileAttachmentObject> list = remainingFiles = CollectionUtils.isEmpty((Collection)attachmentList.getAttachedFiles()) ? Collections.emptyList() : attachmentList.getAttachedFiles();
        if (CollectionUtils.isNotEmpty((Collection)existingAttachments)) {
            List<String> remainingFileIds = remainingFiles.stream().map(file -> file.getId()).distinct().toList();
            existingAttachments.stream().map(existingAttachment -> existingAttachment.getMetadata().getName()).filter(fileId -> !remainingFileIds.contains(fileId)).forEach(fileId -> this.deleteAttachment(objectType, objectId, (String)fileId, username));
            remainingFiles = remainingFiles.stream().filter(remainingFile -> StringUtils.isNotEmpty((CharSequence)remainingFile.getId())).toList();
        }
        String parentObjectId = attachmentList.getParentObjectId();
        List uploadedFiles = attachmentList.getUploadedFiles();
        if (CollectionUtils.isNotEmpty((Collection)remainingFiles)) {
            uploadedFiles.addAll(remainingFiles);
        }
        if (CollectionUtils.isNotEmpty((Collection)uploadedFiles)) {
            report = this.attachUploadFiles(uploadedFiles, objectType, objectId, parentObjectId, userIdentityId);
        }
        this.broadcastAttachmentsChange("attachments.updated", objectType, objectId, username);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachment(UploadedAttachmentDetail uploadedAttachmentDetail, String objectType, String objectId, String parentObjectId, long userIdentityId) throws IOException, ObjectAlreadyExistsException, ObjectNotFoundException {
        Long attachmentId;
        UploadResource uploadResource = uploadedAttachmentDetail.getUploadedResource();
        String altText = uploadedAttachmentDetail.getAltText();
        String format = uploadedAttachmentDetail.getFormat();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(ATTACHMENT_ALT_TEXT, altText);
        properties.put(ATTACHMENT_FORMAT, format);
        Long l = attachmentId = !StringUtils.isBlank((CharSequence)uploadedAttachmentDetail.getId()) ? Long.valueOf(Long.parseLong(uploadedAttachmentDetail.getId())) : null;
        if (uploadResource == null) {
            if (attachmentId != null) {
                this.updateAttachment(String.valueOf(attachmentId), objectType, objectId, userIdentityId, properties);
            }
        } else {
            String fileDiskLocation = uploadResource.getStoreLocation();
            String uploadId = uploadResource.getUploadId();
            try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                String fileId = this.attachmentStorage.uploadAttachment(attachmentId, objectType, objectId, uploadResource.getFileName(), uploadResource.getMimeType(), inputStream, userIdentityId);
                if (attachmentId == null) {
                    this.createAttachment(fileId, objectType, objectId, parentObjectId, userIdentityId, properties);
                    uploadedAttachmentDetail.setId(fileId);
                } else {
                    this.updateAttachment(fileId, objectType, objectId, userIdentityId, properties);
                }
            }
            finally {
                this.uploadService.removeUploadResource(uploadId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAttachmentDetail createAttachment(String objectType, String objectId, FileAttachmentObject attachmentObject, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        this.checkAccessPermission(objectType, objectId, userAclIdentity);
        String uploadId = attachmentObject.getUploadId();
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource != null) {
            String fileId = null;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(ATTACHMENT_ALT_TEXT, attachmentObject.getAltText());
            properties.put(ATTACHMENT_FORMAT, attachmentObject.getFormat());
            String fileDiskLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                long userIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(userAclIdentity.getUserId()).getId());
                fileId = this.attachmentStorage.uploadAttachment(null, objectType, objectId, uploadResource.getFileName(), uploadResource.getMimeType(), inputStream, userIdentityId);
                this.createAttachment(fileId, objectType, objectId, null, userIdentityId, properties);
            }
            catch (Exception e) {
                LOG.error("Error creating attachment of objectType: {} and objectId: {}", new Object[]{objectType, objectId, e});
            }
            finally {
                this.uploadService.removeUploadResource(uploadId);
            }
            return this.getAttachment(objectType, objectId, fileId);
        }
        return null;
    }

    public void deleteAttachments(String objectType, String objectId) {
        List<String> fileIds = this.getAttachmentFileIds(objectType, objectId);
        fileIds.forEach(fileId -> this.deleteAttachment(objectType, objectId, (String)fileId));
        this.broadcastAttachmentsChange("attachments.deleted", objectType, objectId, null);
    }

    public void deleteAttachment(String objectType, String objectId, String fileId) {
        this.deleteAttachment(objectType, objectId, fileId, null);
    }

    public ObjectAttachmentList getAttachments(String objectType, String objectId, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        return this.getAttachments(objectType, objectId, userAclIdentity, 0, 0);
    }

    public ObjectAttachmentList getAttachments(String objectType, String objectId, Identity userAclIdentity, int offset, int limit) throws ObjectNotFoundException, IllegalAccessException {
        this.checkAccessPermission(objectType, objectId, userAclIdentity);
        return this.getAttachments(objectType, objectId, offset, limit);
    }

    public List<String> getAttachmentFileIds(String objectType, String objectId, Identity userAclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        this.checkAccessPermission(objectType, objectId, userAclIdentity);
        return this.getAttachmentFileIds(objectType, objectId);
    }

    public List<String> getAttachmentFileIds(String objectType, String objectId) {
        return this.getAttachmentFileIds(objectType, objectId, 0, 0);
    }

    public ObjectAttachmentList getAttachments(String objectType, String objectId) {
        return this.getAttachments(objectType, objectId, 0, 0);
    }

    public ObjectAttachmentDetail getAttachment(String objectType, String objectId, String fileId, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        this.checkAccessPermission(objectType, objectId, fileId, userAclIdentity);
        return this.getAttachment(objectType, objectId, fileId);
    }

    public ObjectAttachmentDetail getAttachment(String objectType, String objectId, String fileId) {
        List<String> fileIds = this.getAttachmentFileIds(objectType, objectId);
        if (fileIds.contains(fileId)) {
            ObjectAttachmentDetail attachmentDetail = this.attachmentStorage.getAttachment(new ObjectAttachmentId(fileId, objectType, objectId));
            this.enrichAttachmentWithMetadata(attachmentDetail, objectType, objectId);
            return attachmentDetail;
        }
        return null;
    }

    public InputStream getAttachmentInputStream(String objectType, String objectId, String fileId, String imageDimensions, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException, IOException {
        if (objectType == null) {
            throw new IllegalArgumentException("objectType is mandatory");
        }
        if (objectId == null) {
            throw new IllegalArgumentException("objectId is mandatory");
        }
        if (fileId == null) {
            throw new IllegalArgumentException("fileId is mandatory");
        }
        if (!this.hasAccessPermission(userAclIdentity, objectType, objectId)) {
            throw new IllegalAccessException(String.format("User %s doesn't have enough permissions to get attached files on object %s/%s", userAclIdentity.getUserId(), objectType, objectId));
        }
        return this.attachmentStorage.getAttachmentInputStream(new ObjectAttachmentId(fileId, objectType, objectId), imageDimensions);
    }

    public boolean hasAccessPermission(Identity userIdentity, String objectType, String objectId) throws ObjectNotFoundException {
        AttachmentPlugin attachmentPlugin = this.attachmentPlugins.get(objectType);
        return attachmentPlugin != null && attachmentPlugin.hasAccessPermission(userIdentity, objectId);
    }

    public boolean hasEditPermission(Identity userIdentity, String objectType, String objectId) throws ObjectNotFoundException {
        AttachmentPlugin attachmentPlugin = this.attachmentPlugins.get(objectType);
        return attachmentPlugin != null && attachmentPlugin.hasEditPermission(userIdentity, objectId);
    }

    public void moveAttachments(String sourceObjectType, String sourceObjectId, String destinationObjectType, String destinationObjectId, String destinationParentObjectId, long userIdentityId) {
        ObjectAttachmentList objectAttachmentList = this.getAttachments(sourceObjectType, sourceObjectId);
        List attachments = objectAttachmentList.getAttachments();
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            attachments.forEach(attachment -> {
                String altText = attachment.getAltText();
                String format = attachment.getFormat();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(ATTACHMENT_ALT_TEXT, altText);
                properties.put(ATTACHMENT_FORMAT, format);
                try {
                    this.createAttachment(attachment.getId(), destinationObjectType, destinationObjectId, destinationParentObjectId, userIdentityId, properties);
                    List metadataItemToDelete = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(attachment.getId(), AttachmentService.METADATA_TYPE.getName(), sourceObjectType, sourceObjectId, 0L, 0L);
                    if (CollectionUtils.isNotEmpty((Collection)metadataItemToDelete)) {
                        metadataItemToDelete.forEach(metadataItem -> {
                            try {
                                this.metadataService.deleteMetadataItem(metadataItem.getId(), true);
                            }
                            catch (ObjectNotFoundException e) {
                                LOG.error((Object)"Error when deleting metadata item", (Throwable)e);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when creating attachment", (Throwable)e);
                }
            });
        }
    }

    public void createAttachment(String fileId, String objectType, String objectId, String parentObjectId, long userIdentityId, Map<String, String> properties) throws ObjectNotFoundException, ObjectAlreadyExistsException {
        MetadataKey metadataKey = null;
        metadataKey = new MetadataKey(METADATA_TYPE.getName(), fileId, this.getAudienceId(objectType, objectId));
        MetadataObject object = new MetadataObject(objectType, objectId, parentObjectId, this.getSpaceId(objectType, objectId));
        this.metadataService.createMetadataItem(object, metadataKey, properties, userIdentityId);
        this.broadcastAttachmentChange("attachment.created", fileId, objectType, objectId, this.getUserName(userIdentityId));
    }

    private org.exoplatform.social.core.identity.model.Identity checkAccessPermission(String objectType, String objectId, String fileId, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)fileId)) {
            throw new IllegalArgumentException("File identifier is mandatory");
        }
        return this.checkAccessPermission(objectType, objectId, userAclIdentity);
    }

    private org.exoplatform.social.core.identity.model.Identity checkAccessPermission(String objectType, String objectId, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            throw new IllegalArgumentException("Object type is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            throw new IllegalArgumentException("Object identifier is mandatory");
        }
        if (userAclIdentity == null) {
            throw new IllegalArgumentException("User ACL identity is mandatory");
        }
        if (!this.hasAccessPermission(userAclIdentity, objectType, objectId)) {
            throw new IllegalAccessException("User " + userAclIdentity.getUserId() + " doesn't have enough permissions to attach files on object " + objectType + "/" + objectId);
        }
        return this.isAnonymous(userAclIdentity) ? null : this.identityManager.getOrCreateUserIdentity(userAclIdentity.getUserId());
    }

    private void checkEditPermissions(FileAttachmentResourceList attachmentList, Identity userAclIdentity) throws ObjectNotFoundException, IllegalAccessException {
        if (attachmentList == null) {
            throw new IllegalArgumentException("Attachment is mandatory");
        }
        if (userAclIdentity == null) {
            throw new IllegalArgumentException("User ACL identity is mandatory");
        }
        long userIdentityId = attachmentList.getUserIdentityId();
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("User identity id is mandatory");
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null || userIdentity.isDeleted() || !userIdentity.isEnable()) {
            throw new IllegalStateException("User with id " + userIdentityId + " isn't valid");
        }
        String objectType = attachmentList.getObjectType();
        String objectId = attachmentList.getObjectId();
        if (StringUtils.isBlank((CharSequence)objectType)) {
            throw new IllegalArgumentException("Object type is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            throw new IllegalArgumentException("Object identifier is mandatory");
        }
        if (!this.hasEditPermission(userAclIdentity, objectType, objectId)) {
            throw new IllegalAccessException(String.format("User %s doesn't have enough permissions to update file attachments of object %s/%s", userAclIdentity.getUserId(), objectType, objectId));
        }
    }

    private long getAudienceId(String objectType, String objectId) throws ObjectNotFoundException {
        AttachmentPlugin attachmentPlugin = this.attachmentPlugins.get(objectType);
        return attachmentPlugin == null ? 0L : attachmentPlugin.getAudienceId(objectId);
    }

    private long getSpaceId(String objectType, String objectId) throws ObjectNotFoundException {
        AttachmentPlugin attachmentPlugin = this.attachmentPlugins.get(objectType);
        return attachmentPlugin == null ? 0L : attachmentPlugin.getSpaceId(objectId);
    }

    private ObjectAttachmentOperationReport attachUploadFiles(List<FileAttachmentObject> uploadedFiles, String objectType, String objectId, String parentObjectId, long userIdentityId) {
        ObjectAttachmentOperationReport report = new ObjectAttachmentOperationReport();
        uploadedFiles.stream().distinct().map(uploadedFile -> {
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail();
            UploadResource uploadedResource = this.uploadService.getUploadResource(uploadedFile.getUploadId());
            if (uploadedResource == null) {
                LOG.warn((Object)("Uploaded resource with id " + uploadedFile.getUploadId() + " wasn't found"));
                report.addError(uploadedFile.getUploadId(), "attachment.uploadIdNotFound");
            }
            uploadedAttachmentDetail.setId(uploadedFile.getId());
            uploadedAttachmentDetail.setAltText(uploadedFile.getAltText());
            uploadedAttachmentDetail.setFormat(uploadedFile.getFormat());
            uploadedAttachmentDetail.setUploadedResource(uploadedResource);
            return uploadedAttachmentDetail;
        }).filter(Objects::nonNull).forEach(uploadedAttachmentDetail -> this.saveAttachment((UploadedAttachmentDetail)uploadedAttachmentDetail, objectType, objectId, parentObjectId, userIdentityId, report));
        return report;
    }

    private void saveAttachment(UploadedAttachmentDetail uploadedAttachmentDetail, String objectType, String objectId, String parentObjectId, long userIdentityId, ObjectAttachmentOperationReport report) {
        try {
            this.saveAttachment(uploadedAttachmentDetail, objectType, objectId, parentObjectId, userIdentityId);
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)"Uploaded File wasn't found", (Throwable)e);
            report.addError(uploadedAttachmentDetail.getUploadedResource().getUploadId(), "attachment.uploadIdFileNotExistsError");
        }
        catch (IOException e) {
            LOG.warn((Object)"Error accessing Uploaded resource", (Throwable)e);
            report.addError(uploadedAttachmentDetail.getUploadedResource().getUploadId(), "attachment.uploadIdIOError");
        }
        catch (Exception e) {
            LOG.warn((Object)"Error attaching uploaded file", (Throwable)e);
            report.addError(uploadedAttachmentDetail.getUploadedResource().getUploadId(), "attachment.uploadIdNotAttachedError");
        }
    }

    private void updateAttachment(String fileId, String objectType, String objectId, long userIdentityId, Map<String, String> properties) {
        List attachmentItem = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(fileId, AttachmentService.METADATA_TYPE.getName(), objectType, objectId, 0L, 0L);
        if (CollectionUtils.isNotEmpty((Collection)attachmentItem)) {
            MetadataItem attachmentItemMetadata = (MetadataItem)attachmentItem.get(0);
            attachmentItemMetadata.setProperties(properties);
            this.metadataService.updateMetadataItem(attachmentItemMetadata, userIdentityId);
            this.broadcastAttachmentChange("attachments.updated", fileId, objectType, objectId, this.getUserName(userIdentityId));
        }
    }

    private void deleteAttachment(String objectType, String objectId, String fileId, String username) {
        List metadataItemToDelete = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(fileId, AttachmentService.METADATA_TYPE.getName(), objectType, objectId, 0L, 0L);
        if (CollectionUtils.isNotEmpty((Collection)metadataItemToDelete)) {
            metadataItemToDelete.forEach(metadataItem -> {
                try {
                    this.metadataService.deleteMetadataItem(metadataItem.getId(), true);
                    this.attachmentStorage.deleteAttachment(new ObjectAttachmentId(fileId, objectType, objectId));
                }
                catch (Exception e) {
                    LOG.warn("Error while deleting metadata ite {} for attachment deletion. Continue processing object attachments update.", new Object[]{metadataItem, e});
                }
            });
            this.broadcastAttachmentChange("attachment.deleted", fileId, objectType, objectId, username);
        }
    }

    private void broadcastAttachmentChange(String eventName, String fileId, String objectType, String objectId, String username) {
        ObjectAttachmentId payload = new ObjectAttachmentId(fileId, objectType, objectId);
        try {
            this.listenerService.broadcast(eventName, (Object)username, (Object)payload);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting event {} for attachment {}", new Object[]{eventName, payload, e});
        }
    }

    private void broadcastAttachmentsChange(String eventName, String objectType, String objectId, String username) {
        ObjectAttachmentId payload = new ObjectAttachmentId(objectType, objectId);
        try {
            this.listenerService.broadcast(eventName, (Object)username, (Object)payload);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting event {} for attachment {}", new Object[]{eventName, payload, e});
        }
    }

    private String getUserName(long userIdentityId) {
        org.exoplatform.social.core.identity.model.Identity identity = userIdentityId > 0L ? this.identityManager.getIdentity(String.valueOf(userIdentityId)) : null;
        return identity == null ? null : identity.getRemoteId();
    }

    private boolean isAnonymous(Identity userAclIdentity) {
        return userAclIdentity == null || IdentityConstants.ANONIM.equals(userAclIdentity.getUserId());
    }

    private List<String> getAttachmentFileIds(String objectType, String objectId, int offset, int limit) {
        return this.metadataService.getMetadataNamesByMetadataTypeAndObject(METADATA_TYPE.getName(), objectType, objectId, offset, limit).stream().toList();
    }

    private ObjectAttachmentList getAttachments(String objectType, String objectId, int offset, int limit) {
        List<String> fileIds = this.getAttachmentFileIds(objectType, objectId, offset, limit);
        if (fileIds.isEmpty()) {
            return new ObjectAttachmentList(Collections.emptyList(), objectType, objectId);
        }
        List<ObjectAttachmentDetail> attachments = fileIds.stream().map(fileId -> this.attachmentStorage.getAttachment(new ObjectAttachmentId(fileId, objectType, objectId))).filter(Objects::nonNull).toList();
        if (attachments.isEmpty()) {
            return new ObjectAttachmentList(Collections.emptyList(), objectType, objectId);
        }
        attachments.forEach(attachment -> this.enrichAttachmentWithMetadata((ObjectAttachmentDetail)attachment, objectType, objectId));
        return new ObjectAttachmentList(attachments, objectType, objectId);
    }

    private void enrichAttachmentWithMetadata(ObjectAttachmentDetail attachment, String objectType, String objectId) {
        MetadataItem metadataItem;
        Map properties;
        List attachmentItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(attachment.getId(), AttachmentService.METADATA_TYPE.getName(), objectType, objectId, 0L, 0L);
        if (CollectionUtils.isNotEmpty((Collection)attachmentItems) && (properties = (metadataItem = (MetadataItem)attachmentItems.getFirst()).getProperties()) != null && properties.containsKey(ATTACHMENT_ALT_TEXT)) {
            attachment.setAltText((String)properties.get(ATTACHMENT_ALT_TEXT));
            attachment.setFormat((String)properties.get(ATTACHMENT_FORMAT));
        }
    }
}

