/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.AnnouncementService;
import io.meeds.gamification.service.RealizationService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class AnnouncementActivityUpdater
extends ActivityListenerPlugin {
    public static final String ANNOUNCEMENT_ID_PARAM = "announcementId";
    public static final String ANNOUNCEMENT_COMMENT_PARAM = "announcementComment";
    private static final Log LOG = ExoLogger.getLogger(AnnouncementActivityUpdater.class);
    private ActivityManager activityManager;
    private AnnouncementService announcementService;
    private RealizationService realizationService;

    public AnnouncementActivityUpdater(ActivityManager activityManager, AnnouncementService announcementService, RealizationService realizationService) {
        this.activityManager = activityManager;
        this.announcementService = announcementService;
        this.realizationService = realizationService;
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        this.processAnnouncementActivityUpdated(event);
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        this.processAnnouncementActivityUpdated(event);
    }

    public void deleteActivity(ActivityLifeCycleEvent event) {
        this.processAnnouncementActivityDeleted(event);
    }

    public void deleteComment(ActivityLifeCycleEvent event) {
        this.processAnnouncementActivityDeleted(event);
    }

    private void processAnnouncementActivityUpdated(ActivityLifeCycleEvent activityLifeCycleEvent) {
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        if (!this.isActivityAnnouncementType(activity)) {
            return;
        }
        long announcementId = Long.parseLong((String)activity.getTemplateParams().get(ANNOUNCEMENT_ID_PARAM));
        try {
            this.announcementService.updateAnnouncementComment(announcementId, activity.getTitle());
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Announcement with id {} wasn't found, only the activity message will be updated", new Object[]{announcementId, e});
        }
        if (activity.getTemplateParams().containsKey(ANNOUNCEMENT_COMMENT_PARAM)) {
            activity.getTemplateParams().put(ANNOUNCEMENT_COMMENT_PARAM, null);
            this.activityManager.updateActivity(activity, false);
        }
    }

    private void processAnnouncementActivityDeleted(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (!this.isActivityAnnouncementType(activity)) {
            return;
        }
        long realizationId = Long.parseLong((String)activity.getTemplateParams().get(ANNOUNCEMENT_ID_PARAM));
        try {
            RealizationDTO realization = this.realizationService.getRealizationById(realizationId);
            if (!RealizationStatus.CANCELED.name().equals(realization.getStatus())) {
                this.realizationService.updateRealizationStatus(realizationId, RealizationStatus.DELETED);
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Realization with id {} does not exist", new Object[]{realizationId, e});
        }
    }

    private boolean isActivityAnnouncementType(ExoSocialActivity activity) {
        return StringUtils.equals((CharSequence)activity.getType(), (CharSequence)"challenges-announcement") || StringUtils.equals((CharSequence)activity.getType(), (CharSequence)"gamificationActionAnnouncement");
    }
}

